/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.mob;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.entity.mob.EntityHumanBender;
import com.crowsofwar.avatar.item.scroll.Scrolls;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.gorecore.format.FormattedMessage;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityAirbender
extends EntityHumanBender {
    private static final ResourceLocation LOOT_TABLE = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("avatarmod", "airbender"));

    public EntityAirbender(World world) {
        super(world);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25 + (double)((float)this.getLevel() / 100.0f));
    }

    @Override
    protected FormattedMessage getTradeFailMessage() {
        return AvatarChatMessages.MSG_NEED_AIR_TRADE_ITEM;
    }

    @Override
    protected void addBendingTasks() {
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)Objects.requireNonNull(Abilities.getAi("air_bubble", (EntityLiving)this, Bender.get((EntityLivingBase)this))));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)Objects.requireNonNull(Abilities.getAi("air_gust", (EntityLiving)this, Bender.get((EntityLivingBase)this))));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)Objects.requireNonNull(Abilities.getAi("airblade", (EntityLiving)this, Bender.get((EntityLivingBase)this))));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)Objects.requireNonNull(Abilities.getAi("air_burst", (EntityLiving)this, Bender.get((EntityLivingBase)this))));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)Objects.requireNonNull(Abilities.getAi("cloudburst", (EntityLiving)this, Bender.get((EntityLivingBase)this))));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)Objects.requireNonNull(Abilities.getAi("air_jump", (EntityLiving)this, Bender.get((EntityLivingBase)this))));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5 + (double)((float)this.getLevel() / 20.0f), true));
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    protected int getNumSkins() {
        return 7;
    }

    @Override
    public void applyAbilityLevels(int level) {
        boolean airGustPath = this.field_70170_p.field_73012_v.nextBoolean();
        boolean cloudBurstPath = this.field_70170_p.field_73012_v.nextBoolean();
        boolean airBubblePath = this.field_70170_p.field_73012_v.nextBoolean();
        boolean airbladePath = this.field_70170_p.field_73012_v.nextBoolean();
        switch (level) {
            default: {
                this.getData().getAbilityData("air_bubble").setLevel(-1);
                this.getData().getAbilityData("air_gust").setLevel(0);
                this.getData().getAbilityData("air_jump").setLevel(0);
                this.getData().getAbilityData("airblade").setLevel(0);
                this.getData().getAbilityData("cloudburst").setLevel(-1);
                this.getData().getAbilityData("air_burst").setLevel(-1);
                break;
            }
            case 2: {
                this.getData().getAbilityData("air_bubble").setLevel(-1);
                this.getData().getAbilityData("air_gust").setLevel(1);
                this.getData().getAbilityData("air_jump").setLevel(0);
                this.getData().getAbilityData("airblade").setLevel(0);
                this.getData().getAbilityData("cloudburst").setLevel(0);
                this.getData().getAbilityData("air_burst").setLevel(-1);
                break;
            }
            case 3: {
                this.getData().getAbilityData("air_bubble").setLevel(0);
                this.getData().getAbilityData("air_gust").setLevel(2);
                this.getData().getAbilityData("air_jump").setLevel(1);
                this.getData().getAbilityData("airblade").setLevel(1);
                this.getData().getAbilityData("cloudburst").setLevel(0);
                this.getData().getAbilityData("air_burst").setLevel(-1);
                break;
            }
            case 4: {
                this.getData().getAbilityData("air_bubble").setLevel(0);
                this.getData().getAbilityData("air_gust").setLevel(2);
                this.getData().getAbilityData("air_jump").setLevel(2);
                this.getData().getAbilityData("airblade").setLevel(2);
                this.getData().getAbilityData("cloudburst").setLevel(1);
                this.getData().getAbilityData("air_burst").setLevel(0);
                break;
            }
            case 5: {
                this.getData().getAbilityData("air_bubble").setLevel(1);
                this.getData().getAbilityData("air_gust").setPath(airGustPath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("air_jump").setLevel(2);
                this.getData().getAbilityData("airblade").setPath(airbladePath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("cloudburst").setLevel(1);
                this.getData().getAbilityData("air_burst").setLevel(0);
                break;
            }
            case 6: {
                this.getData().getAbilityData("air_bubble").setLevel(2);
                this.getData().getAbilityData("air_gust").setPath(airGustPath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("air_jump").setPath(AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("airblade").setPath(airbladePath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("cloudburst").setPath(cloudBurstPath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("air_burst").setLevel(1);
                break;
            }
            case 7: {
                this.getData().getAbilityData("air_bubble").setPath(airBubblePath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("air_gust").setPath(airGustPath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("air_jump").setPath(AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("airblade").setPath(airbladePath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("cloudburst").setPath(cloudBurstPath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("air_burst").setLevel(2);
            }
        }
    }

    @Override
    public void modifyAbilities(Ability ability) {
        super.modifyAbilities(ability);
        AbilityData abilityData = AbilityData.get((EntityLivingBase)this, ability.getName());
        if (abilityData != null) {
            abilityData.setAbilityCooldown((int)((double)abilityData.getAbilityCooldown() * 1.25));
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        ItemStack stack = new ItemStack((Item)Scrolls.AIR, 1, this.getLevel() - 1);
        if (AvatarUtils.getRandomNumberInRange(1, 100) < 50 && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(stack, 1.0f);
        }
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        TextComponentString textcomponentstring = new TextComponentString("Level " + this.getLevel() + " " + ScorePlayerTeam.func_96667_a((Team)this.func_96124_cp(), (String)this.func_70005_c_()));
        textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
        textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
        return textcomponentstring;
    }
}

