/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.mob;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.config.ConfigMobs;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BenderEntityComponent;
import com.crowsofwar.avatar.util.data.BendingData;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public abstract class EntityBender
extends EntityCreature
implements IEntityAdditionalSpawnData {
    private Bender bender;
    private static final DataParameter<Integer> SYNC_LEVEL = EntityDataManager.func_187226_a(EntityBender.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityBender(World world) {
        super(world);
    }

    protected Bender initBender() {
        return new BenderEntityComponent(this);
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_LEVEL);
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(SYNC_LEVEL, (Object)level);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.bender = this.initBender();
        this.field_70180_af.func_187214_a(SYNC_LEVEL, (Object)1);
        this.getData().addBending(this.getElement());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.applyAbilityLevels(this.getLevel());
        this.getData().addBending(this.getElement());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setLevel(nbt.func_74762_e("Level"));
        this.bender.getData().readFromNbt(nbt);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Level", this.getLevel());
        this.bender.getData().writeToNbt(nbt);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.bender.onUpdate();
    }

    public abstract void applyAbilityLevels(int var1);

    public abstract void applyModifiers(int var1);

    public Bender getBender() {
        return this.bender;
    }

    public BendingData getData() {
        return this.bender.getData();
    }

    public void modifyAbilities(Ability ability) {
    }

    public BendingStyle getElement() {
        return new Airbending();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setLevel(AvatarUtils.getRandomNumberInRange(1, ConfigMobs.MOBS_CONFIG.benderSettings.maxLevel));
        this.applyAbilityLevels(this.getLevel());
        this.getData().addBending(this.getElement());
        return super.func_180482_a(difficulty, livingdata);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.getLevel());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setLevel(additionalData.readInt());
    }
}

