/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.mob;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.entity.mob.EntityHumanBender;
import com.crowsofwar.avatar.item.scroll.Scrolls;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.gorecore.format.FormattedMessage;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityFirebender
extends EntityHumanBender {
    private static final ResourceLocation LOOT_TABLE = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("avatarmod", "firebender"));

    public EntityFirebender(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void applyAbilityLevels(int level) {
        boolean flameStrikePath = this.field_70170_p.field_73012_v.nextBoolean();
        boolean flamethrowerPath = this.field_70170_p.field_73012_v.nextBoolean();
        boolean fireBlastPath = this.field_70170_p.field_73012_v.nextBoolean();
        boolean fireballPath = this.field_70170_p.field_73012_v.nextBoolean();
        boolean flameGlidePath = this.field_70170_p.field_73012_v.nextBoolean();
        switch (level) {
            case 2: {
                this.getData().getAbilityData("fireball").setLevel(-1);
                this.getData().getAbilityData("flamethrower").setLevel(0);
                this.getData().getAbilityData("flame_strike").setLevel(0);
                this.getData().getAbilityData("fire_shot").setLevel(1);
                this.getData().getAbilityData("flame_glide").setLevel(0);
                break;
            }
            case 3: {
                this.getData().getAbilityData("fireball").setLevel(-1);
                this.getData().getAbilityData("flamethrower").setLevel(0);
                this.getData().getAbilityData("flame_strike").setLevel(1);
                this.getData().getAbilityData("fire_shot").setLevel(1);
                this.getData().getAbilityData("flame_glide").setLevel(1);
                break;
            }
            case 4: {
                this.getData().getAbilityData("fireball").setLevel(0);
                this.getData().getAbilityData("flamethrower").setLevel(1);
                this.getData().getAbilityData("flame_strike").setLevel(1);
                this.getData().getAbilityData("fire_shot").setLevel(2);
                this.getData().getAbilityData("flame_glide").setLevel(1);
                break;
            }
            case 5: {
                this.getData().getAbilityData("fireball").setLevel(1);
                this.getData().getAbilityData("flamethrower").setLevel(2);
                this.getData().getAbilityData("flame_strike").setLevel(2);
                this.getData().getAbilityData("fire_shot").setPath(flameStrikePath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("flame_glide").setLevel(2);
                break;
            }
            case 6: {
                this.getData().getAbilityData("fireball").setLevel(2);
                this.getData().getAbilityData("flamethrower").setLevel(2);
                this.getData().getAbilityData("flame_strike").setPath(fireBlastPath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("fire_shot").setPath(flameStrikePath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("flame_glide").setPath(flameGlidePath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                break;
            }
            case 7: {
                this.getData().getAbilityData("fireball").setPath(fireballPath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("flamethrower").setPath(flamethrowerPath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("flame_strike").setPath(fireBlastPath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("fire_shot").setPath(flameStrikePath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                this.getData().getAbilityData("flame_glide").setPath(flameGlidePath ? AbilityData.AbilityTreePath.FIRST : AbilityData.AbilityTreePath.SECOND);
                break;
            }
            default: {
                this.getData().getAbilityData("fireball").setLevel(-1);
                this.getData().getAbilityData("flamethrower").setLevel(-1);
                this.getData().getAbilityData("flame_strike").setLevel(0);
                this.getData().getAbilityData("fire_shot").setLevel(0);
                this.getData().getAbilityData("flame_glide").setLevel(0);
            }
        }
        this.getData().saveAll();
    }

    @Override
    public BendingStyle getElement() {
        return new Firebending();
    }

    @Override
    protected FormattedMessage getTradeFailMessage() {
        return AvatarChatMessages.MSG_NEED_FIRE_TRADE_ITEM;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @Override
    protected void addBendingTasks() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)Objects.requireNonNull(Abilities.getAi("flamethrower", (EntityLiving)this, this.getBender())));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)Objects.requireNonNull(Abilities.getAi("fireball", (EntityLiving)this, this.getBender())));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)Objects.requireNonNull(Abilities.getAi("fire_shot", (EntityLiving)this, this.getBender())));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)Objects.requireNonNull(Abilities.getAi("flame_strike", (EntityLiving)this, this.getBender())));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)Objects.requireNonNull(Abilities.getAi("flame_glide", (EntityLiving)this, this.getBender())));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.4, true));
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.getData().addBendingId(Firebending.ID);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    protected int getNumSkins() {
        return 1;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return super.func_184645_a(player, hand);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        TextComponentString textcomponentstring = new TextComponentString("Level " + this.getLevel() + " " + ScorePlayerTeam.func_96667_a((Team)this.func_96124_cp(), (String)this.func_70005_c_()));
        textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
        textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
        return textcomponentstring;
    }

    public void func_70106_y() {
        super.func_70106_y();
        ItemStack stack = new ItemStack((Item)Scrolls.FIRE, 1, this.getLevel() - 1);
        if (AvatarUtils.getRandomNumberInRange(1, 100) < 50 && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(stack, 1.0f);
        }
    }
}

