/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.mob;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.config.ConfigMobs;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.item.scroll.Scrolls;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.registry.AvatarItems;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.WildCardTradeList;
import com.crowsofwar.gorecore.format.FormattedMessage;
import com.crowsofwar.gorecore.util.GoreCoreNBTUtil;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityHumanBender
extends EntityBender
implements IMerchant,
INpc {
    private static final DataParameter<Integer> SYNC_SKIN = EntityDataManager.func_187226_a(EntityHumanBender.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SYNC_SCROLLS_LEFT = EntityDataManager.func_187226_a(EntityHumanBender.class, (DataSerializer)DataSerializers.field_187192_b);
    protected Predicate<Entity> targetSelector;
    private MerchantRecipeList trades;
    @Nullable
    private EntityPlayer customer;
    private int timeUntilReset;
    private boolean updateRecipes;

    public EntityHumanBender(World world) {
        super(world);
    }

    public int getScrollsLeft() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_SCROLLS_LEFT);
    }

    public void setScrollsLeft(int scrolls) {
        this.field_70180_af.func_187227_b(SYNC_SCROLLS_LEFT, (Object)scrolls);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_SKIN, (Object)AvatarUtils.getRandomNumberInRange(1, this.getNumSkins()));
        this.field_70180_af.func_187214_a(SYNC_SCROLLS_LEFT, (Object)this.getLevel());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITradePlayer(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILookAtTradePlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityHumanBender.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.targetSelector = entity -> {
            if (entity != null && !entity.func_82150_aj() && entity.func_70075_an() && (entity.func_96124_cp() == null || this.func_96124_cp() == null || entity.func_96124_cp() != null && this.func_96124_cp() != null && entity.func_96124_cp() == this.func_96124_cp())) {
                return entity instanceof EntityMob && ((EntityMob)entity).func_70662_br() || entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_110144_aD() == this;
            }
            return false;
        };
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, true, this.targetSelector));
        this.addBendingTasks();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("trades")) {
            NBTTagCompound nbttagcompound1 = nbt.func_74775_l("trades");
            this.trades = new WildCardTradeList(nbttagcompound1);
        }
        this.setSkin(nbt.func_74762_e("Skin"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.trades != null) {
            GoreCoreNBTUtil.storeTagSafely(nbt, "trades", (NBTBase)this.trades.func_77202_a());
        }
        nbt.func_74768_a("Skin", this.getSkin());
    }

    protected abstract void addBendingTasks();

    protected boolean isTradeItem(Item item) {
        return ConfigMobs.MOBS_CONFIG.isTradeItem(item);
    }

    protected abstract int getNumSkins();

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_SKIN);
    }

    public void setSkin(int skin) {
        this.field_70180_af.func_187227_b(SYNC_SKIN, (Object)skin);
    }

    protected FormattedMessage getTradeFailMessage() {
        return AvatarChatMessages.MSG_NEED_TRADE_ITEM;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_180481_a(difficulty);
        this.func_175449_a(this.func_180425_c(), 40);
        this.setSkin((int)(this.field_70146_Z.nextDouble() * (double)this.getNumSkins()));
        this.setLevel(AvatarUtils.getRandomNumberInRange(1, ConfigMobs.MOBS_CONFIG.benderSettings.maxLevel));
        this.applyAbilityLevels(this.getLevel());
        this.applyModifiers(this.getLevel());
        this.generateRecipes();
        return livingdata;
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.getSkin());
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.setSkin(additionalData.readInt());
    }

    @Override
    public void applyModifiers(int level) {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    protected abstract ResourceLocation func_184647_J();

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.func_70089_S() && !this.isTrading() && !this.func_70631_g_() && !player.func_70093_af() && this.func_70638_az() != player) {
            if (!this.field_70170_p.field_72995_K && this.trades != null && !this.trades.isEmpty()) {
                this.func_70932_a_(player);
                player.func_180472_a((IMerchant)this);
            }
            return true;
        }
        return false;
    }

    public void setInitialScrolls(int level) {
        this.setScrollsLeft(level);
    }

    protected void func_70619_bc() {
        if (!this.isTrading() && this.timeUntilReset > 0) {
            --this.timeUntilReset;
            if (this.timeUntilReset <= 0) {
                if (this.updateRecipes) {
                    for (MerchantRecipe merchantrecipe : this.trades) {
                        if (!merchantrecipe.func_82784_g()) continue;
                        merchantrecipe.func_82783_a(this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(6) + 2);
                    }
                    if (this.trades.size() < 12) {
                        this.addRandomRecipes(1);
                        this.addReverseRandomRecipes(1);
                    }
                    this.updateRecipes = false;
                }
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 0));
            }
        }
        super.func_70619_bc();
    }

    public EntityPlayer func_70931_l_() {
        return this.customer;
    }

    public void func_70932_a_(EntityPlayer player) {
        this.customer = player;
    }

    public boolean isTrading() {
        return this.func_70931_l_() != null;
    }

    public void func_110297_a_(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.field_70757_a > -this.func_70627_aG() + 20) {
            this.field_70757_a = -this.func_70627_aG();
            this.func_184185_a(stack.func_190926_b() ? SoundEvents.field_187913_gm : SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Override
    public BendingStyle getElement() {
        return new Airbending();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70930_a(@Nullable MerchantRecipeList recipeList) {
    }

    public void func_70933_a(MerchantRecipe merchantrecipe) {
        merchantrecipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        this.func_184185_a(SoundEvents.field_187915_go, this.func_70599_aP(), this.func_70647_i());
        if (this.field_70146_Z.nextInt(5) > 0) {
            this.timeUntilReset = 40;
            this.updateRecipes = true;
            if (this.func_70931_l_() != null) {
                this.func_70931_l_().func_70005_c_();
            }
        }
    }

    public MerchantRecipeList func_70934_b(EntityPlayer par1EntityPlayer) {
        return this.trades;
    }

    private void addReverseRandomRecipes(int numberOfItemsToAdd) {
        MerchantRecipeList recipeList = new MerchantRecipeList();
        for (int i = 0; i < numberOfItemsToAdd; ++i) {
            boolean greaterTier;
            ItemStack itemToSell = ItemStack.field_190927_a;
            ItemStack item2nd = ItemStack.field_190927_a;
            ItemStack firstPrice = ItemStack.field_190927_a;
            ItemStack secondPrice = ItemStack.field_190927_a;
            boolean itemAlreadySold = true;
            int tier = 1;
            int maxTier = this.getLevel();
            int finalTier = tier;
            double tierInc = (float)(maxTier - tier) / 3.0f;
            while (itemAlreadySold) {
                itemAlreadySold = false;
                double tierIncreaseChance = 0.7 + 0.04 * (double)Math.max(this.trades == null ? 0 : this.trades.size() - 4, 0);
                if (this.field_70146_Z.nextDouble() < tierIncreaseChance) {
                    tier = (int)((double)tier + tierInc);
                    if (this.field_70146_Z.nextDouble() < tierIncreaseChance) {
                        tier = (int)((double)tier + tierInc);
                        if (this.field_70146_Z.nextDouble() < tierIncreaseChance * 0.6) {
                            tier = (int)((double)tier + tierInc);
                        }
                    }
                }
                tier = Math.min(tier, maxTier);
                finalTier = Math.min(AvatarUtils.getRandomNumberInRange(Math.max(tier - 1, 1), tier) + (int)tierIncreaseChance * AvatarUtils.getRandomNumberInRange(2, 4) + 1, maxTier);
                itemToSell = this.getRandomItemOfTier(finalTier);
                item2nd = this.getRandomItemOfTier(finalTier);
                firstPrice = this.getRandomPrice(finalTier);
                secondPrice = this.getRandomPrice(finalTier);
                if (this.trades == null) continue;
                for (Object recipe : this.trades) {
                    if (!ItemStack.func_77989_b((ItemStack)((MerchantRecipe)recipe).func_77397_d(), (ItemStack)firstPrice) && !ItemStack.func_77989_b((ItemStack)((MerchantRecipe)recipe).func_77397_d(), (ItemStack)secondPrice)) continue;
                    itemAlreadySold = true;
                }
            }
            if (itemToSell == ItemStack.field_190927_a) {
                return;
            }
            boolean bl = greaterTier = ConfigMobs.MOBS_CONFIG.getTradeItemTier(firstPrice.func_77973_b()) > finalTier;
            if (greaterTier) {
                recipeList.add((Object)new MerchantRecipe(itemToSell, firstPrice));
                continue;
            }
            boolean bl2 = greaterTier = ConfigMobs.MOBS_CONFIG.getTradeItemTier(secondPrice.func_77973_b()) > finalTier;
            if (greaterTier) {
                recipeList.add((Object)new MerchantRecipe(itemToSell, secondPrice));
                continue;
            }
            recipeList.add((Object)new MerchantRecipe(itemToSell, item2nd, this.field_70170_p.field_73012_v.nextBoolean() ? firstPrice : secondPrice));
        }
        Collections.shuffle(recipeList);
        if (this.trades == null) {
            this.trades = new WildCardTradeList();
        }
        this.trades.addAll((Collection)recipeList);
    }

    private void addRandomRecipes(int numberOfItemsToAdd) {
        MerchantRecipeList recipeList = new MerchantRecipeList();
        for (int i = 0; i < numberOfItemsToAdd; ++i) {
            boolean greaterTier;
            ItemStack itemToSell = ItemStack.field_190927_a;
            boolean itemAlreadySold = true;
            int tier = 1;
            int maxTier = Math.max(this.getLevel(), tier);
            int finalTier = tier;
            double tierInc = (float)(maxTier - tier) / 3.0f;
            while (itemAlreadySold) {
                itemAlreadySold = false;
                double tierIncreaseChance = 0.76 + 0.04 * (double)Math.max(this.trades == null ? 0 : this.trades.size() - 4, 0);
                if (this.field_70146_Z.nextDouble() < tierIncreaseChance) {
                    tier = (int)((double)tier + tierInc);
                    if (this.field_70146_Z.nextDouble() < tierIncreaseChance) {
                        tier = (int)((double)tier + tierInc);
                        if (this.field_70146_Z.nextDouble() < tierIncreaseChance * 0.6) {
                            tier = (int)((double)tier + tierInc);
                        }
                    }
                }
                tier = Math.min(tier, maxTier);
                finalTier = Math.min(AvatarUtils.getRandomNumberInRange(Math.max(tier - 1, 1), tier) + (int)tierIncreaseChance * AvatarUtils.getRandomNumberInRange(2, 4) + 1, maxTier);
                itemToSell = this.getRandomItemOfTier(finalTier);
                if (this.trades == null) continue;
                for (Object recipe : this.trades) {
                    if (!ItemStack.func_77989_b((ItemStack)((MerchantRecipe)recipe).func_77397_d(), (ItemStack)itemToSell)) continue;
                    itemAlreadySold = true;
                    return;
                }
            }
            if (itemToSell == ItemStack.field_190927_a) {
                return;
            }
            ItemStack firstPrice = this.getRandomPrice(finalTier);
            ItemStack secondPrice = this.getRandomPrice(finalTier);
            boolean bl = greaterTier = ConfigMobs.MOBS_CONFIG.getTradeItemTier(firstPrice.func_77973_b()) >= finalTier;
            if (greaterTier) {
                recipeList.add((Object)new MerchantRecipe(firstPrice, itemToSell));
                continue;
            }
            boolean bl2 = greaterTier = ConfigMobs.MOBS_CONFIG.getTradeItemTier(secondPrice.func_77973_b()) >= finalTier;
            if (greaterTier) {
                recipeList.add((Object)new MerchantRecipe(secondPrice, itemToSell));
                continue;
            }
            recipeList.add((Object)new MerchantRecipe(firstPrice, secondPrice, itemToSell));
        }
        Collections.shuffle(recipeList);
        if (this.trades == null) {
            this.trades = new WildCardTradeList();
        }
        this.trades.addAll((Collection)recipeList);
    }

    private ItemStack getRandomPrice(int tier) {
        int price;
        String element;
        Item item = ConfigMobs.MOBS_CONFIG.getTradeItems().get(AvatarUtils.getRandomNumberInRange(0, ConfigMobs.MOBS_CONFIG.getTradeItems().size() - 1));
        switch (element = this.getElement().getName()) {
            case "airbending": {
                while (ConfigMobs.MOBS_CONFIG.isFireTradeItem(item)) {
                    item = ConfigMobs.MOBS_CONFIG.getTradeItems().get(AvatarUtils.getRandomNumberInRange(0, ConfigMobs.MOBS_CONFIG.getTradeItems().size() - 1));
                }
                break;
            }
            case "firebending": {
                while (ConfigMobs.MOBS_CONFIG.isAirTradeItem(item)) {
                    item = ConfigMobs.MOBS_CONFIG.getTradeItems().get(AvatarUtils.getRandomNumberInRange(0, ConfigMobs.MOBS_CONFIG.getTradeItems().size() - 1));
                }
                break;
            }
        }
        if (item == null) {
            AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Invalid item in currency items");
            item = Items.field_151166_bC;
            price = 2;
        } else {
            price = ConfigMobs.MOBS_CONFIG.getTradeItemTier(item);
            price = tier < price ? 1 : (int)Math.pow(2.0, tier - price);
        }
        return new ItemStack(item, price);
    }

    private ItemStack getRandomItemOfTier(int tier) {
        boolean rand = this.field_70170_p.field_73012_v.nextBoolean();
        if (tier > 7) {
            --tier;
        }
        ItemStack toSell = rand ? new ItemStack((Item)Scrolls.ALL, 1, tier - 1) : new ItemStack((Item)Scrolls.getTypeFromElement(this.getElement().getName()), 1, tier - 1);
        return toSell;
    }

    private void generateRecipes() {
        if (this.trades == null) {
            this.trades = new WildCardTradeList();
            ItemStack universalScroll = new ItemStack((Item)Scrolls.ALL, 1, 1);
            ItemStack elementScroll = new ItemStack((Item)Scrolls.getTypeFromElement(this.getElement()), 1, 2);
            ItemStack staff = this.getElement() instanceof Airbending ? (new Random().nextInt(100) % 2 == 0 ? new ItemStack((Item)AvatarItems.gliderBasic, 1) : new ItemStack((Item)AvatarItems.gliderAdv, 1)) : new ItemStack((Item)Scrolls.ALL, 2, 1);
            this.trades.add((Object)new MerchantRecipe(universalScroll, elementScroll, staff));
            this.addRandomRecipes(3);
            this.addReverseRandomRecipes(3);
        }
    }

    public World func_190670_t_() {
        return this.field_70170_p;
    }

    public BlockPos func_190671_u_() {
        return new BlockPos((Entity)this);
    }

    public static class EntityAITradePlayer
    extends EntityAIBase {
        private final EntityHumanBender bender;

        public EntityAITradePlayer(EntityHumanBender bender) {
            this.bender = bender;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            if (!this.bender.func_70089_S()) {
                return false;
            }
            if (this.bender.func_70090_H()) {
                return false;
            }
            if (!this.bender.field_70122_E) {
                return false;
            }
            if (this.bender.field_70133_I) {
                return false;
            }
            EntityPlayer entityplayer = this.bender.func_70931_l_();
            if (entityplayer == null) {
                return false;
            }
            if (this.bender.func_70068_e((Entity)entityplayer) > 16.0) {
                return false;
            }
            return entityplayer.field_71070_bA != null;
        }

        public void func_75249_e() {
            this.bender.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.bender.func_70932_a_(null);
        }
    }

    public static class EntityAILookAtTradePlayer
    extends EntityAIWatchClosest {
        private final EntityHumanBender bender;

        public EntityAILookAtTradePlayer(EntityHumanBender bender) {
            super((EntityLiving)bender, EntityPlayer.class, 8.0f);
            this.bender = bender;
        }

        public boolean func_75250_a() {
            if (this.bender.func_70931_l_() != null) {
                this.field_75334_a = this.bender.func_70931_l_();
                return true;
            }
            return false;
        }
    }
}

