/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.mob;

import com.crowsofwar.avatar.client.gui.InventoryOstrichChest;
import com.crowsofwar.avatar.item.ItemOstrichEquipment;
import com.crowsofwar.avatar.registry.AvatarItems;
import com.crowsofwar.avatar.util.AvatarUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityOstrichHorse
extends EntityAnimal
implements IInventoryChangedListener {
    private static final DataParameter<Float> SYNC_RIDE_SPEED = EntityDataManager.func_187226_a(EntityOstrichHorse.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> SYNC_EQUIPMENT = EntityDataManager.func_187226_a(EntityOstrichHorse.class, (DataSerializer)DataSerializers.field_187192_b);
    private InventoryOstrichChest chest;

    public EntityOstrichHorse(World world) {
        super(world);
        this.func_70105_a(1.0f, 2.0f);
        this.setupChest();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_RIDE_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(SYNC_EQUIPMENT, (Object)-1);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return new EntityOstrichHorse(this.field_70170_p);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.3));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.1));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_151015_O, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 0.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        AvatarUtils.writeInventory((IInventory)this.chest, compound, "Inventory");
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        AvatarUtils.readInventory((IInventory)this.chest, compound, "Inventory");
        this.updateEquipment();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!super.func_184645_a(player, hand) && !this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            return this.processInteractOnce(player);
        }
        return false;
    }

    private boolean processInteractOnce(EntityPlayer player) {
        for (EnumHand hand : EnumHand.values()) {
            ItemStack heldStack = player.func_184586_b(hand);
            if (heldStack.func_77973_b() != AvatarItems.itemOstrichEquipment) continue;
            ItemOstrichEquipment.EquipmentTier proposed = ItemOstrichEquipment.EquipmentTier.getTier(heldStack.func_77960_j());
            if (this.getEquipment() == proposed) continue;
            if (this.getEquipment() != null) {
                this.dropEquipment(!player.func_184812_l_());
            }
            this.chest.func_70299_a(0, heldStack.func_77946_l());
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
            }
            return true;
        }
        if (player.func_70093_af() && this.getEquipment() != null) {
            this.dropEquipment(!player.func_184812_l_());
            return true;
        }
        player.func_184220_m((Entity)this);
        return true;
    }

    @Nullable
    public Entity func_184179_bs() {
        return !this.func_184188_bt().isEmpty() ? (Entity)this.func_184188_bt().get(0) : null;
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public void func_191986_a(float strafe, float jump, float forward) {
        EntityLivingBase driver = (EntityLivingBase)this.func_184179_bs();
        double moveSpeed = 0.2;
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = driver.field_70177_z;
            this.field_70125_A = driver.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                this.updateRideSpeed(driver.field_191988_bg);
                this.func_70659_e(this.getRideSpeed());
                super.func_191986_a(strafe, jump, forward);
                moveSpeed = 0.5;
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            this.setRideSpeed(0.0f);
            super.func_191986_a(strafe, jump, forward);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(moveSpeed);
    }

    private void setupChest() {
        this.chest = new InventoryOstrichChest();
        if (this.func_145818_k_()) {
            this.chest.func_110133_a(this.func_70005_c_());
        }
        this.chest.func_110134_a(this);
        this.updateEquipment();
    }

    public void func_76316_a(IInventory invBasic) {
        this.updateEquipment();
    }

    private void updateEquipment() {
        if (!this.field_70170_p.field_72995_K) {
            ItemOstrichEquipment.EquipmentTier tier = null;
            ItemStack equipmentStack = this.chest.func_70301_a(0);
            if (equipmentStack.func_77973_b() == AvatarItems.itemOstrichEquipment) {
                tier = ItemOstrichEquipment.EquipmentTier.getTier(equipmentStack.func_77960_j());
            }
            this.setEquipment(tier);
        }
    }

    private float getRideSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_RIDE_SPEED)).floatValue();
    }

    private void setRideSpeed(float rideSpeed) {
        this.field_70180_af.func_187227_b(SYNC_RIDE_SPEED, (Object)Float.valueOf(rideSpeed));
    }

    @Nullable
    public ItemOstrichEquipment.EquipmentTier getEquipment() {
        int index = (Integer)this.field_70180_af.func_187225_a(SYNC_EQUIPMENT);
        return ItemOstrichEquipment.EquipmentTier.getTier(index);
    }

    public void setEquipment(@Nullable ItemOstrichEquipment.EquipmentTier equipment) {
        int index = equipment == null ? -1 : equipment.ordinal();
        this.field_70180_af.func_187227_b(SYNC_EQUIPMENT, (Object)index);
    }

    private void dropEquipment(boolean dropItem) {
        if (this.getEquipment() != null) {
            this.chest.func_70299_a(0, ItemStack.field_190927_a);
            if (dropItem) {
                int index = this.getEquipment().ordinal();
                ItemStack stack = new ItemStack((Item)AvatarItems.itemOstrichEquipment, 1, index);
                this.func_70099_a(stack, this.func_70047_e());
            }
        }
    }

    private void updateRideSpeed(float instructions) {
        float moveSpeedAttr = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        float current = this.getRideSpeed();
        float target = moveSpeedAttr * 1.5f;
        float next = current;
        if (instructions > 0.0f) {
            if (current < target) {
                next += moveSpeedAttr * 0.02f;
            }
            if ((double)next < 0.1) {
                next = 0.1f;
            }
        }
        if (instructions < 0.0f && current > 0.0f) {
            next -= moveSpeedAttr * 0.03f;
        }
        if (instructions == 0.0f) {
            target = moveSpeedAttr * 0.5f;
        }
        if ((double)next < 0.1) {
            next = 0.0f;
        }
        if (next > target) {
            next += (target - next) * 0.05f;
        }
        this.setRideSpeed(next);
    }
}

