/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.mob;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.gui.InventoryBisonChest;
import com.crowsofwar.avatar.config.ConfigMobs;
import com.crowsofwar.avatar.entity.ai.EntityAiBisonBreeding;
import com.crowsofwar.avatar.entity.ai.EntityAiBisonDefendOwner;
import com.crowsofwar.avatar.entity.ai.EntityAiBisonEatGrass;
import com.crowsofwar.avatar.entity.ai.EntityAiBisonFollowAttacker;
import com.crowsofwar.avatar.entity.ai.EntityAiBisonFollowOwner;
import com.crowsofwar.avatar.entity.ai.EntityAiBisonHelpOwnerTarget;
import com.crowsofwar.avatar.entity.ai.EntityAiBisonLand;
import com.crowsofwar.avatar.entity.ai.EntityAiBisonSit;
import com.crowsofwar.avatar.entity.ai.EntityAiBisonTempt;
import com.crowsofwar.avatar.entity.ai.EntityAiBisonWander;
import com.crowsofwar.avatar.entity.data.AnimalCondition;
import com.crowsofwar.avatar.entity.data.BisonSpawnData;
import com.crowsofwar.avatar.entity.data.SyncedEntity;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.entity.mob.SkyBisonMoveHelper;
import com.crowsofwar.avatar.item.ItemBisonArmor;
import com.crowsofwar.avatar.item.ItemBisonSaddle;
import com.crowsofwar.avatar.item.ItemBisonWhistle;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.registry.AvatarItems;
import com.crowsofwar.avatar.util.AvatarDataSerializers;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.PlayerViewRegistry;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.analytics.AnalyticEvents;
import com.crowsofwar.avatar.util.analytics.AvatarAnalytics;
import com.crowsofwar.avatar.util.data.AvatarWorldData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BenderEntityComponent;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.AccountUUIDs;
import com.crowsofwar.gorecore.util.Vector;
import com.google.common.base.Optional;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntitySkyBison
extends EntityBender
implements IEntityOwnable,
IInventoryChangedListener {
    private static final DataParameter<Optional<UUID>> SYNC_OWNER = EntityDataManager.func_187226_a(EntitySkyBison.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> SYNC_SITTING = EntityDataManager.func_187226_a(EntitySkyBison.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> SYNC_FOOD = EntityDataManager.func_187226_a(EntitySkyBison.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> SYNC_DOMESTICATION = EntityDataManager.func_187226_a(EntitySkyBison.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SYNC_EAT_GRASS = EntityDataManager.func_187226_a(EntitySkyBison.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SYNC_AGE = EntityDataManager.func_187226_a(EntitySkyBison.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SYNC_LOVE_PARTICLES = EntityDataManager.func_187226_a(EntitySkyBison.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SYNC_ID = EntityDataManager.func_187226_a(EntitySkyBison.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemBisonSaddle.SaddleTier> SYNC_SADDLE = EntityDataManager.func_187226_a(EntitySkyBison.class, AvatarDataSerializers.SERIALIZER_SADDLE);
    private static final DataParameter<ItemBisonArmor.ArmorTier> SYNC_ARMOR = EntityDataManager.func_187226_a(EntitySkyBison.class, AvatarDataSerializers.SERIALIZER_ARMOR);
    private final SyncedEntity<EntityLivingBase> ownerAttr;
    private final AnimalCondition condition;
    private Vector originalPos;
    private boolean madeSitByPlayer = false;
    private EntityAiBisonEatGrass aiEatGrass;
    private int riderTicks;
    private ForgeChunkManager.Ticket ticket;
    private InventoryBisonChest chest;
    private boolean wasTouchingGround;

    public EntitySkyBison(World world) {
        super(world);
        this.field_70765_h = new SkyBisonMoveHelper(this);
        this.ownerAttr = new SyncedEntity((Entity)this, SYNC_OWNER);
        this.condition = new AnimalCondition(this, 30.0f, 20.0f, SYNC_FOOD, SYNC_DOMESTICATION, SYNC_AGE);
        this.func_70105_a(2.5f, 2.0f);
        this.field_70145_X = false;
        this.initChest();
    }

    public static EntitySkyBison findBison(World world, int id) {
        List list = world.func_175644_a(EntitySkyBison.class, bison -> bison.getId() == id);
        return list.isEmpty() ? null : (EntitySkyBison)((Object)list.get(0));
    }

    public static EntitySkyBison findBison(World world, UUID id) {
        List list = world.func_175644_a(EntitySkyBison.class, bison -> bison.func_110124_au().equals(id));
        return list.isEmpty() ? null : (EntitySkyBison)((Object)list.get(0));
    }

    @Override
    protected Bender initBender() {
        return new BisonBenderComponent();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        int domestication = ConfigMobs.MOBS_CONFIG.bisonSettings.bisonMinDomestication + this.field_70146_Z.nextInt(ConfigMobs.MOBS_CONFIG.bisonSettings.bisonMaxDomestication - ConfigMobs.MOBS_CONFIG.bisonSettings.bisonMinDomestication);
        this.field_70180_af.func_187214_a(SYNC_OWNER, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SYNC_SITTING, (Object)false);
        this.field_70180_af.func_187214_a(SYNC_FOOD, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_187214_a(SYNC_DOMESTICATION, (Object)domestication);
        this.field_70180_af.func_187214_a(SYNC_EAT_GRASS, (Object)-1);
        this.field_70180_af.func_187214_a(SYNC_AGE, (Object)0);
        this.field_70180_af.func_187214_a(SYNC_LOVE_PARTICLES, (Object)false);
        this.field_70180_af.func_187214_a(SYNC_ID, (Object)(this.field_70170_p.field_72995_K ? -1 : AvatarWorldData.getDataFromWorld(this.field_70170_p).nextEntityId()));
        this.field_70180_af.func_187214_a(SYNC_SADDLE, null);
        this.field_70180_af.func_187214_a(SYNC_ARMOR, null);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAiBisonDefendOwner(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAiBisonHelpOwnerTarget(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)Objects.requireNonNull(Abilities.get("air_bubble")).getAi((EntityLiving)this, this.getBender()));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)Objects.requireNonNull(Abilities.get("air_gust")).getAi((EntityLiving)this, this.getBender()));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)Objects.requireNonNull(Abilities.get("airblade")).getAi((EntityLiving)this, this.getBender()));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAiBisonFollowAttacker(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAiBisonSit(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAiBisonBreeding(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAiBisonTempt(this, 10.0));
        this.aiEatGrass = new EntityAiBisonEatGrass(this);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAiBisonLand(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAiBisonFollowOwner(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAiBisonWander(this));
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        this.getData().addBendingId(Airbending.ID);
        boolean sterile = false;
        if (ConfigMobs.MOBS_CONFIG.bisonSettings.airBisonCanBeSterile && livingData instanceof BisonSpawnData) {
            sterile = ((BisonSpawnData)livingData).isSterile();
        }
        this.condition.setSterile(sterile);
        this.condition.setBreedTimer((int)(ConfigMobs.MOBS_CONFIG.bisonSettings.bisonBreedMaxMinutes * 1200.0f));
        IBlockState walkingOn = this.field_70170_p.func_180495_p(Vector.getEntityPos((Entity)this).minusY(0.01).toBlockPos());
        this.wasTouchingGround = walkingOn.func_185904_a() != Material.field_151579_a;
        this.condition.setAge(this.field_70146_Z.nextInt(48000) + 40000);
        this.originalPos = Vector.getEntityPos((Entity)this);
        return super.func_180482_a(difficulty, livingData);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.originalPos = Vector.readFromNbt(nbt);
        this.ownerAttr.readFromNbt(nbt);
        this.setSitting(nbt.func_74767_n("Sitting"));
        this.condition.readFromNbt(nbt);
        this.setEatGrassTime(nbt.func_74762_e("EatGrass"));
        this.riderTicks = nbt.func_74762_e("RiderTicks");
        this.setLoveParticles(nbt.func_74767_n("InLove"));
        this.setId(nbt.func_74762_e("BisonId"));
        if (nbt.func_74762_e("BisonId") == 0) {
            this.setId(AvatarWorldData.getDataFromWorld(this.field_70170_p).nextEntityId());
        }
        this.initChest();
        AvatarUtils.readInventory((IInventory)this.chest, nbt, "Inventory");
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.ownerAttr.writeToNbt(nbt);
        nbt.func_74757_a("Sitting", this.isSitting());
        this.condition.writeToNbt(nbt);
        nbt.func_74768_a("EatGrass", this.getEatGrassTime());
        nbt.func_74768_a("RiderTicks", this.riderTicks);
        nbt.func_74757_a("InLove", this.isLoveParticles());
        nbt.func_74768_a("BisonId", this.getId());
        if (this.originalPos != null) {
            this.originalPos.writeToNbt(nbt);
        } else {
            Vector.getEntityPos((Entity)this).writeToNbt(nbt);
        }
        AvatarUtils.writeInventory((IInventory)this.chest, nbt, "Inventory");
    }

    public Vector getOriginalPos() {
        if (this.originalPos.equals(Vector.ZERO)) {
            this.originalPos = Vector.getEntityPos((Entity)this);
        }
        return this.originalPos;
    }

    public UUID func_184753_b() {
        return this.ownerAttr.getEntityId();
    }

    public void setOwnerId(@Nullable UUID id) {
        this.ownerAttr.setEntityId(id);
    }

    public boolean hasOwner() {
        return this.func_184753_b() != null;
    }

    @Nullable
    public EntityPlayer getOwner() {
        return (EntityPlayer)this.ownerAttr.getEntity();
    }

    public void setOwner(@Nullable EntityPlayer owner) {
        this.ownerAttr.setEntity((EntityLivingBase)owner);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_SITTING);
    }

    public void setSitting(boolean sitting) {
        this.field_70180_af.func_187227_b(SYNC_SITTING, (Object)sitting);
    }

    public float getSpeedMultiplier() {
        float armorSpeed = this.getArmor() == null ? 1.0f : this.getArmor().getSpeedMultiplier();
        float attackSpeed = this.func_70638_az() != null ? 1.25f : 1.0f;
        return this.condition.getSpeedMultiplier() * armorSpeed * attackSpeed;
    }

    public AnimalCondition getCondition() {
        return this.condition;
    }

    public boolean isFull() {
        return this.condition.getFoodPoints() > 25.0f;
    }

    public boolean wantsGrass() {
        return this.condition.getFoodPoints() < 15.0f && this.func_70638_az() == null;
    }

    public boolean isEatingGrass() {
        return this.getEatGrassTime() > -1;
    }

    public int getEatGrassTime() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_EAT_GRASS);
    }

    public void setEatGrassTime(int time) {
        this.field_70180_af.func_187227_b(SYNC_EAT_GRASS, (Object)time);
    }

    public int getRiderTicks() {
        return this.riderTicks;
    }

    public void setRiderTicks(int riderTicks) {
        this.riderTicks = riderTicks;
    }

    public boolean isLoveParticles() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_LOVE_PARTICLES);
    }

    public void setLoveParticles(boolean inLove) {
        this.field_70180_af.func_187227_b(SYNC_LOVE_PARTICLES, (Object)inLove);
    }

    public ItemBisonSaddle.SaddleTier getSaddle() {
        return (ItemBisonSaddle.SaddleTier)((Object)this.field_70180_af.func_187225_a(SYNC_SADDLE));
    }

    public void setSaddle(ItemBisonSaddle.SaddleTier saddle) {
        this.field_70180_af.func_187227_b(SYNC_SADDLE, (Object)saddle);
    }

    public ItemBisonArmor.ArmorTier getArmor() {
        return (ItemBisonArmor.ArmorTier)((Object)this.field_70180_af.func_187225_a(SYNC_ARMOR));
    }

    public void setArmor(ItemBisonArmor.ArmorTier armor) {
        this.field_70180_af.func_187227_b(SYNC_ARMOR, (Object)armor);
    }

    public int getId() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_ID);
    }

    public void setId(int id) {
        this.field_70180_af.func_187227_b(SYNC_ID, (Object)id);
    }

    public boolean isForceLoadingChunks() {
        return this.ticket != null;
    }

    public void beginForceLoadingChunks() {
        if (!this.isForceLoadingChunks()) {
            this.ticket = ForgeChunkManager.requestTicket((Object)AvatarMod.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
            this.ticket.bindEntity((Entity)this);
            this.ticket.getModData().func_186854_a("BisonId", this.func_110124_au());
        }
    }

    public void stopForceLoadingChunks() {
        if (this.isForceLoadingChunks()) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
            this.ticket = null;
        }
    }

    public void func_184232_k(Entity passenger) {
        double index = this.func_184188_bt().indexOf(passenger);
        ++this.riderTicks;
        if (index > -1.0) {
            float sizeOffset = this.condition.getAgeDays() < 7.0f ? this.condition.getAgeDays() / (float)this.condition.getAdultAge() / 2.0f : 1.0f;
            double offset = 0.75;
            double angle = (index + 0.5) * Math.PI - Math.toRadians(this.field_70177_z);
            double yOffset = passenger.func_70033_W() + 2.5 * ((double)sizeOffset + 0.35);
            if (passenger == this.func_184179_bs() && !this.isSitting()) {
                angle = -Math.toRadians(passenger.field_70177_z);
                offset = 1.0;
                yOffset = passenger.func_70033_W() + 2.5 * ((double)sizeOffset + 0.4);
            }
            if (passenger == this.func_184179_bs() && this.isSitting()) {
                angle = -Math.toRadians(passenger.field_70177_z);
                offset = 1.0;
                yOffset = passenger.func_70033_W() + 2.5 * ((double)sizeOffset + 0.35);
            }
            if (PlayerViewRegistry.getPlayerViewMode(passenger.func_110124_au()) >= 2 || PlayerViewRegistry.getPlayerViewMode(passenger.func_110124_au()) <= -1) {
                passenger.func_70107_b(this.field_70165_t + Math.sin(angle) * offset, this.field_70163_u + yOffset, this.field_70161_v + Math.cos(angle) * offset);
            } else {
                passenger.func_70107_b(this.field_70165_t + Math.sin(angle) * offset - Math.sin(angle), this.field_70163_u + yOffset, this.field_70161_v + Math.cos(angle) * offset - Math.cos(angle));
            }
            if (passenger != this.func_184179_bs() && (this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0)) {
                passenger.field_70177_z = this.field_70759_as;
                passenger.field_70125_A = this.field_70125_A;
            }
        }
    }

    protected boolean func_184219_q(Entity passenger) {
        int passengers = this.func_184188_bt().size();
        int saddleSize = this.getSaddle() == null ? 0 : this.getSaddle().getMaxPassengers();
        return passengers < this.condition.getMaxRiders() && passengers < saddleSize;
    }

    public Entity func_184179_bs() {
        if (this.func_184188_bt().contains(this.getOwner())) {
            return this.getOwner();
        }
        return null;
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() != null;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean willBeOwned;
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = willBeOwned = this.condition.canHaveOwner() && stack.func_77973_b() == Items.field_151034_e && !this.hasOwner();
        if (stack != ItemStack.field_190927_a) {
            Item item = stack.func_77973_b();
            int domesticationValue = ConfigMobs.MOBS_CONFIG.getDomesticationValue(item);
            if (domesticationValue > 0) {
                this.condition.addDomestication(domesticationValue);
                if (!this.condition.canHaveOwner() || item != Items.field_151034_e) {
                    this.playTameEffect(false);
                }
            }
            if (item instanceof ItemFood) {
                ItemFood food = (ItemFood)stack.func_77973_b();
                this.condition.addFood(food.func_150905_g(stack));
            }
            if (domesticationValue > 0 || item instanceof ItemFood) {
                this.condition.addAge(100);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if (!willBeOwned) {
                    return true;
                }
            }
        }
        if (willBeOwned) {
            this.playTameEffect(true);
            this.setOwnerId(AccountUUIDs.getId(player.func_70005_c_()));
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_193132_s.func_193158_a((EntityPlayerMP)player, new ItemStack((Item)AvatarItems.itemBisonWhistle), 0);
            }
            if (!this.field_70170_p.field_72995_K) {
                AvatarAnalytics.INSTANCE.pushEvent(AnalyticEvents.onBisonTamed());
            }
            return true;
        }
        if (stack.func_77973_b() == Items.field_151137_ax) {
            this.condition.setDomestication(0);
            this.playTameEffect(false);
            this.setOwnerId(null);
            return true;
        }
        if (stack.func_77973_b() == AvatarItems.itemBisonSaddle && ItemBisonSaddle.SaddleTier.isValidId(stack.func_77960_j())) {
            if (!this.field_70170_p.field_72995_K) {
                this.chest.func_70299_a(0, stack.func_77946_l());
                this.updateEquipment();
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (stack.func_77973_b() == AvatarItems.itemBisonArmor && ItemBisonArmor.ArmorTier.isValidId(stack.func_77960_j())) {
            if (!this.field_70170_p.field_72995_K) {
                this.chest.func_70299_a(1, stack.func_77946_l());
                this.updateEquipment();
            }
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K && stack.func_77973_b() == AvatarItems.itemBisonWhistle && player.func_70093_af()) {
            if (player == this.getOwner()) {
                ItemBisonWhistle.setBoundTo(stack, this.func_110124_au());
                ItemBisonWhistle.setBisonName(stack, this.func_70005_c_());
                AvatarChatMessages.MSG_BISON_WHISTLE_ASSIGN.send((ICommandSender)player, this.func_70005_c_());
            } else if (this.getOwner() != null) {
                AvatarChatMessages.MSG_BISON_WHISTLE_NOTOWNED.send((ICommandSender)player, new Object[0]);
            } else {
                AvatarChatMessages.MSG_BISON_WHISTLE_UNTAMED.send((ICommandSender)player, new Object[0]);
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K && stack.func_77973_b() == Items.field_151032_g) {
            int food = (int)(100.0 * (double)this.condition.getFoodPoints() / 30.0);
            int health = (int)(100.0 * (double)this.func_110143_aJ() / (double)this.func_110138_aP());
            AvatarChatMessages.MSG_SKY_BISON_STATS.send((ICommandSender)player, food, health, this.condition.getDomestication());
            return true;
        }
        if (!this.field_70170_p.field_72995_K && stack.func_77973_b() == Items.field_151103_aS) {
            try {
                Field field = EntityAITasks.class.getDeclaredField("executingTaskEntries");
                field.setAccessible(true);
                Set executingTasks = (Set)field.get(this.field_70714_bg);
                System.out.println("Currently executing tasks:");
                for (EntityAITasks.EntityAITaskEntry entry : executingTasks) {
                    System.out.println(" - " + entry.field_75733_a);
                }
                System.out.println(".");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (stack.func_77973_b() == Items.field_151057_cb) {
            this.func_174805_g(true);
            return false;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150329_H) && this.condition.getBreedTimer() == 0) {
            float min = ConfigMobs.MOBS_CONFIG.bisonSettings.bisonBreedMinMinutes;
            float max = ConfigMobs.MOBS_CONFIG.bisonSettings.bisonBreedMaxMinutes;
            float minutes = min + this.field_70146_Z.nextFloat() * (max - min);
            this.condition.setBreedTimer((int)(minutes * 1200.0f));
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return true;
        }
        if (this.getOwner() == player && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
            player.openGui((Object)AvatarMod.instance, 5, this.field_70170_p, this.getId(), 0, 0);
            return true;
        }
        if (player.func_70093_af() && this.getOwner() == player) {
            Bender b;
            if (!this.isSitting() && (b = Bender.get((EntityLivingBase)this.getOwner())) != null && !this.field_70170_p.field_72995_K) {
                b.sendMessage("avatar.bisonSitting");
            }
            this.setSitting(!this.isSitting());
            this.madeSitByPlayer = true;
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean onLeftClick(EntityPlayer player) {
        if (this.hasOwner()) {
            if (player.func_70093_af()) {
                player.openGui((Object)AvatarMod.instance, 5, this.field_70170_p, this.getId(), 0, 0);
            } else if (!this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.condition.getDomestication() >= ConfigMobs.MOBS_CONFIG.bisonSettings.bisonRiderTameness && super.func_184652_a(player);
    }

    private void onLiftoff() {
        if (!this.isEatingGrass()) {
            this.getBender().executeAbility(Abilities.get("air_jump"), false);
            StatusControlController.AIR_JUMP.execute(new BendingContext(this.getData(), (EntityLivingBase)this, this.getBender(), new Raytrace.Result()));
            this.getData().removeStatusControl(StatusControlController.AIR_JUMP);
        }
    }

    private void onLand() {
        Bender b;
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), Blocks.field_150348_b.func_185467_w().func_185845_c(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        if (this.condition.getFoodPoints() == 0.0f && this.getOwner() != null && (b = Bender.get((EntityLivingBase)this.getOwner())) != null && !this.field_70170_p.field_72995_K) {
            b.sendMessage("avatar.bisonNoFood");
        }
    }

    public void func_70615_aA() {
        this.condition.addFood(ConfigMobs.MOBS_CONFIG.bisonSettings.bisonGrassFoodBonus);
    }

    private void initChest() {
        InventoryBisonChest old = this.chest;
        this.chest = new InventoryBisonChest(this.getChestSlots());
        if (this.func_145818_k_()) {
            this.chest.func_110133_a(this.func_70005_c_());
        }
        if (old != null) {
            old.func_110132_b(this);
            int slots = Math.min(old.func_70302_i_(), this.chest.func_70302_i_());
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = old.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.chest.func_70299_a(i, stack.func_77946_l());
            }
        }
        this.chest.func_110134_a(this);
        this.updateEquipment();
    }

    private void setFullInventorySize() {
    }

    public void func_76316_a(IInventory invBasic) {
        this.updateEquipment();
    }

    private void updateEquipment() {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack saddleStack = this.chest.func_70301_a(0);
            int saddleId = saddleStack.func_77960_j();
            if (saddleStack.func_77973_b() == AvatarItems.itemBisonSaddle && ItemBisonSaddle.SaddleTier.isValidId(saddleId)) {
                this.setSaddle(ItemBisonSaddle.SaddleTier.get(saddleId));
            } else {
                this.setSaddle(null);
            }
            ItemStack armorStack = this.chest.func_70301_a(1);
            int armorId = armorStack.func_77960_j();
            if (armorStack.func_77973_b() == AvatarItems.itemBisonArmor && ItemBisonArmor.ArmorTier.isValidId(armorId)) {
                this.setArmor(ItemBisonArmor.ArmorTier.get(armorId));
            } else {
                this.setArmor(null);
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a((double)this.getArmorPoints());
    }

    public InventoryBisonChest getInventory() {
        return this.chest;
    }

    public boolean canPlayerViewInventory(EntityPlayer player) {
        return this.getOwner() == player && this.condition.getDomestication() >= ConfigMobs.MOBS_CONFIG.bisonSettings.bisonChestTameness;
    }

    public int getChestSlots() {
        if (this.condition.getDomestication() >= ConfigMobs.MOBS_CONFIG.bisonSettings.bisonChestTameness && this.condition.getAgeDays() > 1.0f) {
            int age = (int)(this.condition.getAgeDays() - 1.0f);
            if (age >= 5) {
                return 27;
            }
            if (age >= 3) {
                return 18;
            }
            return 9;
        }
        return 0;
    }

    public float getArmorPoints() {
        float saddle = this.getSaddle() == null ? 0.0f : this.getSaddle().getArmorPoints();
        float armor = this.getArmor() == null ? 0.0f : this.getArmor().getArmorPoints();
        return saddle + armor;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.chest.func_70302_i_(); ++i) {
                ItemStack stack = this.chest.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.func_70099_a(stack, 0.0f);
            }
            if (cause.func_76346_g() instanceof EntityPlayer) {
                AvatarLog.info("Bison " + this.func_70005_c_() + " (owned by " + this.getOwner() + ") was just killed by " + cause.func_76346_g().func_70005_c_());
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.setLevel((int)Math.min(this.condition.getAgeDays(), 7.0f));
        this.applyAbilityLevels(this.getLevel());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(20.0f + Math.min(80.0f * this.condition.getAgeDays() / (float)this.condition.getAdultAge(), 80.0f)));
        if (this.isSitting() && this.hasOwner() && this.field_70170_p.func_180495_p(Vector.getEntityPos((Entity)this).toBlockPos()).func_177230_c() != Blocks.field_150350_a) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        if (this.field_70170_p.field_72995_K && this.chest.func_70302_i_() - 2 != this.getChestSlots()) {
            this.initChest();
        }
        if (!this.field_70170_p.field_72995_K && !this.condition.canHaveOwner() && this.hasOwner()) {
            this.setOwner(null);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setEatGrassTime(this.aiEatGrass.getEatGrassTime());
            this.setLoveParticles(this.condition.isReadyToBreed());
        }
        if (this.field_70170_p.field_72995_K && this.isLoveParticles() && this.field_70173_aa % 10 == 0) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
        float sizeMult = this.condition.getSizeMultiplier();
        this.func_70105_a(3.67f * sizeMult, 3.34f * sizeMult);
        this.condition.onUpdate();
        if (!this.madeSitByPlayer && this.isSitting() && this.condition.getFoodPoints() > 0.0f) {
            this.setSitting(false);
        }
        if (this.condition.getFoodPoints() == 0.0f && this.getOwner() != null) {
            this.setSitting(true);
            this.madeSitByPlayer = false;
        } else if (!this.hasOwner()) {
            this.setSitting(false);
        }
        if (!AvatarMod.cubicChunks) {
            if (!this.isForceLoadingChunks() && this.hasOwner()) {
                this.beginForceLoadingChunks();
            }
            if (this.isForceLoadingChunks()) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)new ChunkPos(this.func_180425_c()));
                if (!this.hasOwner() || this.func_110143_aJ() <= 0.0f) {
                    this.stopForceLoadingChunks();
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean touchingGround;
            IBlockState walkingOn = this.field_70170_p.func_180495_p(Vector.getEntityPos((Entity)this).withY(0.01).toBlockPos());
            boolean bl = touchingGround = walkingOn.func_185904_a() != Material.field_151579_a;
            if (!touchingGround && this.wasTouchingGround) {
                this.onLiftoff();
            }
            if (touchingGround && !this.wasTouchingGround) {
                this.onLand();
            }
            this.wasTouchingGround = touchingGround;
        }
        if (this.func_184188_bt().isEmpty()) {
            this.riderTicks = 0;
        }
        if (!this.condition.canHaveOwner() && this.riderTicks > 0 && this.riderTicks % 60 == 0) {
            this.condition.addDomestication(ConfigMobs.MOBS_CONFIG.bisonSettings.bisonRideOneSecondTameness * 3);
            this.playTameEffect(false);
        }
    }

    @Override
    public void applyAbilityLevels(int level) {
    }

    @Override
    public void applyModifiers(int level) {
    }

    public void func_191986_a(float strafe, float jump, float forward) {
        IBlockState walkingOn;
        boolean touchingGround;
        if (this.isEatingGrass()) {
            this.field_70181_x -= 0.08;
        }
        boolean bl = touchingGround = (walkingOn = this.field_70170_p.func_180495_p(Vector.getEntityPos((Entity)this).withY(0.01).toBlockPos())).func_185904_a() != Material.field_151579_a;
        if (this.func_184207_aI() && this.func_82171_bF()) {
            float turnLeft;
            float pitch;
            this.field_70765_h.field_188491_h = EntityMoveHelper.Action.WAIT;
            EntityLivingBase driver = (EntityLivingBase)this.func_184179_bs();
            float f = pitch = Math.abs(driver.field_70125_A) < 20.0f ? 0.0f : driver.field_70125_A;
            if (touchingGround && Math.abs(pitch) < 45.0f) {
                pitch = 0.0f;
            }
            Vector look = Vector.toRectangular(Math.toRadians(driver.field_70177_z), Math.toRadians(pitch));
            forward = (float)look.withY(0.0).magnitude();
            float speedMult = this.getSpeedMultiplier() * driver.field_191988_bg * 1.25f;
            float current = AvatarUtils.normalizeAngle(this.field_70177_z);
            float target = AvatarUtils.normalizeAngle(driver.field_70177_z);
            float delta = target - current;
            float turnRight = Math.abs(AvatarUtils.normalizeAngle(target - current));
            this.field_70177_z = turnRight < (turnLeft = Math.abs(AvatarUtils.normalizeAngle(current - target))) ? (float)((double)this.field_70177_z + (double)turnRight * 0.3) : (float)((double)this.field_70177_z - (double)turnLeft * 0.3);
            this.field_70177_z = AvatarUtils.normalizeAngle(this.field_70177_z);
            this.field_70759_as = driver.field_70177_z;
            this.field_70126_B = this.field_70177_z;
            this.field_70125_A = driver.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            strafe = driver.field_70702_br * 0.5f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                float moveAttribute = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                this.func_70659_e(moveAttribute * this.condition.getSpeedMultiplier());
                this.travelFlying(strafe, jump * speedMult, forward);
                this.field_70181_x += look.y() * 0.02 * (double)speedMult;
            } else if (driver instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double moveX = this.field_70165_t - this.field_70169_q;
            double moveZ = this.field_70161_v - this.field_70166_s;
            float moveSinceLastTick = MathHelper.func_76133_a((double)(moveX * moveX + moveZ * moveZ)) * 4.0f;
            if (moveSinceLastTick > 1.0f) {
                moveSinceLastTick = 1.0f;
            }
            this.field_70721_aZ += (moveSinceLastTick - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            this.travelFlying(strafe, jump, forward);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    private void travelFlying(float strafe, float jump, float forward) {
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, jump, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, jump, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_191958_b(strafe, jump, forward, this.field_70122_E ? 0.1f * f1 : 0.06f);
            f = 0.91f;
            if (this.field_70122_E) {
                f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected void playTameEffect(boolean success) {
        EnumParticleTypes particle = success ? EnumParticleTypes.HEART : (this.condition.canHaveOwner() ? EnumParticleTypes.CLOUD : EnumParticleTypes.SMOKE_NORMAL);
        for (int i = 0; i < 7; ++i) {
            double mx = this.field_70146_Z.nextGaussian() * 0.02;
            double my = this.field_70146_Z.nextGaussian() * 0.02;
            double mz = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, mx, my, mz, new int[0]);
        }
    }

    private class BisonBenderComponent
    extends BenderEntityComponent {
        private BisonBenderComponent() {
            super(EntitySkyBison.this);
        }

        @Override
        public boolean isFlying() {
            return true;
        }
    }
}

