/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.item;

import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.item.scroll.Scrolls;
import com.crowsofwar.avatar.registry.AvatarItems;
import com.crowsofwar.avatar.util.AvatarUtils;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="avatarmod")
public class AvatarDungeonLoot {
    @SubscribeEvent
    public static void onLootLoad(LootTableLoadEvent e) {
        if (!ConfigStats.STATS_CONFIG.addDungeonLoot) {
            return;
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_186426_h, LootTableList.field_186428_j, LootTableList.field_186427_i)) {
            AvatarDungeonLoot.addLoot(e, 150, new LootItem(Scrolls.ALL, 40 - AvatarUtils.getRandomNumberInRange(4, 6) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(4, 6)), new LootItem(Scrolls.EARTH, 40 - AvatarUtils.getRandomNumberInRange(4, 6) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(4, 6)), new LootItem(Scrolls.WATER, 35 - AvatarUtils.getRandomNumberInRange(4, 6) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(4, 6)), new LootItem(Scrolls.AIR, 35 - AvatarUtils.getRandomNumberInRange(4, 6) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(4, 6)), new LootItem(Scrolls.FIRE, 35 - AvatarUtils.getRandomNumberInRange(4, 6) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(4, 6)), new LootItem(Scrolls.LIGHTNING, 20 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.COMBUSTION, 20 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.ICE, 20 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.SAND, 20 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)));
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_186425_g)) {
            AvatarDungeonLoot.addLoot(e, 150, new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(0), new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(1), new LootItem(AvatarItems.itemOstrichEquipment, 20).withMetadata(0), new LootItem(AvatarItems.itemBisonArmor, 20).withMetadata(1), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(0), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(2), new LootItem(AvatarItems.itemBisonArmor, 5).withMetadata(3), new LootItem(AvatarItems.itemBisonWhistle, 25));
            AvatarDungeonLoot.addLoot(e, 120, new LootItem(Scrolls.FIRE, 60 - AvatarUtils.getRandomNumberInRange(4, 6) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(4, 6)), new LootItem(Scrolls.COMBUSTION, 40 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)));
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_186423_e)) {
            AvatarDungeonLoot.addLoot(e, 150, new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(0), new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(1), new LootItem(AvatarItems.itemOstrichEquipment, 20).withMetadata(2), new LootItem(AvatarItems.itemBisonArmor, 20).withMetadata(1), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(0), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(2), new LootItem(AvatarItems.itemBisonArmor, 5).withMetadata(3), new LootItem(AvatarItems.itemBisonWhistle, 20));
            AvatarDungeonLoot.addLoot(e, 120, new LootItem(Scrolls.FIRE, 40 - AvatarUtils.getRandomNumberInRange(1, 4) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 4)), new LootItem(Scrolls.AIR, 30 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.EARTH, 30 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.ALL, 30 - -AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)));
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_186421_c)) {
            AvatarDungeonLoot.addLoot(e, 150, new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(0), new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(1), new LootItem(AvatarItems.itemOstrichEquipment, 30).withMetadata(2), new LootItem(AvatarItems.itemBisonArmor, 20).withMetadata(1), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(0), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(2), new LootItem(AvatarItems.itemBisonArmor, 35).withMetadata(3));
            AvatarDungeonLoot.addLoot(e, 175, new LootItem(Scrolls.ALL, 50 - AvatarUtils.getRandomNumberInRange(4, 6) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(4, 6)), new LootItem(Scrolls.EARTH, 50 - AvatarUtils.getRandomNumberInRange(4, 6) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(4, 6)), new LootItem(Scrolls.WATER, 45 - AvatarUtils.getRandomNumberInRange(4, 6) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(4, 6)), new LootItem(Scrolls.AIR, 45 - AvatarUtils.getRandomNumberInRange(4, 6) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(4, 6)), new LootItem(Scrolls.FIRE, 45 - AvatarUtils.getRandomNumberInRange(4, 6) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(4, 6)), new LootItem(Scrolls.LIGHTNING, 30 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.COMBUSTION, 30 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.ICE, 30 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.SAND, 30 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)));
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_191192_o, LootTableList.field_186430_l)) {
            AvatarDungeonLoot.addLoot(e, 100, new LootItem(Scrolls.EARTH, 60 - AvatarUtils.getRandomNumberInRange(3, 5) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(3, 5)), new LootItem(Scrolls.ALL, 40 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)));
            AvatarDungeonLoot.addLoot(e, 110, new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(0), new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(1), new LootItem(AvatarItems.itemOstrichEquipment, 20).withMetadata(0), new LootItem(AvatarItems.itemBisonArmor, 20).withMetadata(1), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(0), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(2), new LootItem(AvatarItems.itemBisonArmor, 5).withMetadata(3), new LootItem(AvatarItems.itemBisonWhistle, 25));
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_186422_d, LootTableList.field_186424_f)) {
            AvatarDungeonLoot.addLoot(e, 120, new LootItem(Scrolls.ALL, 40 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.EARTH, 40 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.WATER, 35 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.AIR, 35 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)), new LootItem(Scrolls.FIRE, 35 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)));
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_186429_k)) {
            AvatarDungeonLoot.addLoot(e, 120, new LootItem(Scrolls.EARTH, 40 - AvatarUtils.getRandomNumberInRange(2, 4) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(2, 4)), new LootItem(Scrolls.SAND, 50 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)));
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_186431_m)) {
            AvatarDungeonLoot.addLoot(e, 120, new LootItem(Scrolls.WATER, 60 - AvatarUtils.getRandomNumberInRange(2, 4) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(2, 4)), new LootItem(Scrolls.ICE, 60 - AvatarUtils.getRandomNumberInRange(1, 3) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 3)));
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_186420_b)) {
            AvatarDungeonLoot.addLoot(e, 200, new LootItem(Scrolls.ALL, 40 - AvatarUtils.getRandomNumberInRange(1, 2) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 2)), new LootItem(Scrolls.EARTH, 40 - AvatarUtils.getRandomNumberInRange(1, 2) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 2)), new LootItem(Scrolls.WATER, 40 - AvatarUtils.getRandomNumberInRange(1, 2) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 2)), new LootItem(Scrolls.AIR, 40 - AvatarUtils.getRandomNumberInRange(1, 2) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 2)), new LootItem(Scrolls.FIRE, 40 - AvatarUtils.getRandomNumberInRange(1, 2) * 5).withMetadata(AvatarUtils.getRandomNumberInRange(1, 2)));
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_186425_g, LootTableList.field_186421_c, LootTableList.field_186428_j)) {
            AvatarDungeonLoot.addLoot(e, 95, new LootItem(AvatarItems.itemBisonWhistle, 20), new LootItem(AvatarItems.itemBisonSaddle, 20).withMetadata(1), new LootItem(AvatarItems.itemBisonSaddle, 10).withMetadata(0), new LootItem(AvatarItems.itemBisonSaddle, 10).withMetadata(2), new LootItem(AvatarItems.itemBisonSaddle, 5).withMetadata(3), new LootItem(AvatarItems.itemWaterPouch, 30));
            AvatarDungeonLoot.addLoot(e, 65, new LootItem(AvatarItems.itemOstrichEquipment, 10).withMetadata(0), new LootItem(AvatarItems.itemOstrichEquipment, 10).withMetadata(1), new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(0));
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_186426_h, LootTableList.field_186424_f, LootTableList.field_186422_d)) {
            AvatarDungeonLoot.addLoot(e, 80, new LootItem(AvatarItems.itemBisonArmor, 20).withMetadata(1), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(0), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(2), new LootItem(AvatarItems.itemBisonArmor, 5).withMetadata(3), new LootItem(AvatarItems.itemWaterPouch, 30));
            AvatarDungeonLoot.addLoot(e, 90, new LootItem(AvatarItems.itemOstrichEquipment, 10).withMetadata(0), new LootItem(AvatarItems.itemOstrichEquipment, 10).withMetadata(1), new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(0));
        }
        if (AvatarDungeonLoot.isLootTable(e, LootTableList.field_186431_m, LootTableList.field_186429_k, LootTableList.field_186430_l)) {
            AvatarDungeonLoot.addLoot(e, 60, new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(0), new LootItem(AvatarItems.itemOstrichEquipment, 15).withMetadata(1), new LootItem(AvatarItems.itemOstrichEquipment, 20).withMetadata(0), new LootItem(AvatarItems.itemBisonArmor, 20).withMetadata(1), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(0), new LootItem(AvatarItems.itemBisonArmor, 10).withMetadata(2), new LootItem(AvatarItems.itemBisonArmor, 5).withMetadata(3));
        }
    }

    private static boolean isLootTable(LootTableLoadEvent e, ResourceLocation ... names) {
        for (ResourceLocation name : names) {
            if (!e.getName().equals((Object)name)) continue;
            return true;
        }
        return false;
    }

    private static void addLoot(LootTableLoadEvent e, int emptyWeight, LootItem ... items) {
        String lootPoolName = "custom_avatar_loot_pools";
        int j = 2;
        while (e.getTable().getPool(lootPoolName) != null) {
            lootPoolName = "custom_avatar_loot_pools_" + j;
            ++j;
        }
        LootPool pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(1.0f, 1.0f), lootPoolName);
        pool.addEntry((LootEntry)new LootEntryEmpty(emptyWeight, 1, new LootCondition[0], "empty"));
        for (int i = 0; i < items.length; ++i) {
            LootItem item = items[i];
            LootCondition[] conditions = new LootCondition[]{};
            SetCount stackSize = new SetCount(conditions, new RandomValueRange((float)item.minStack, (float)item.maxStack));
            SetMetadata metadata = new SetMetadata(conditions, new RandomValueRange((float)item.metadata));
            SetNBT nbt = new SetNBT(conditions, item.nbt);
            pool.addEntry((LootEntry)new LootEntryItem(item.item, item.weight, 1, new LootFunction[]{stackSize, metadata, nbt}, conditions, "custom_" + i));
        }
        e.getTable().addPool(pool);
    }

    private static class LootItem {
        private final Item item;
        private final int weight;
        private int minStack;
        private int maxStack;
        private int metadata;
        private NBTTagCompound nbt;

        public LootItem(Item item, int weight) {
            this.item = item;
            this.weight = weight;
            this.metadata = 0;
            this.minStack = 1;
            this.maxStack = 1;
            this.nbt = new NBTTagCompound();
        }

        private LootItem withMetadata(int metadata) {
            this.metadata = metadata;
            return this;
        }

        private LootItem withStackSize(int min, int max) {
            this.minStack = min;
            this.maxStack = max;
            return this;
        }

        private LootItem withNbt(NBTTagCompound nbt) {
            this.nbt = nbt;
            return this;
        }
    }
}

