/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.item;

import com.crowsofwar.avatar.entity.mob.EntitySkyBison;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.registry.AvatarItem;
import com.crowsofwar.avatar.registry.AvatarItems;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.TransferConfirmHandler;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.AccountUUIDs;
import com.crowsofwar.gorecore.util.GoreCoreNBTUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemBisonWhistle
extends Item
implements AvatarItem {
    private static ItemBisonWhistle instance = null;

    public static ItemBisonWhistle getInstance() {
        if (instance == null) {
            instance = new ItemBisonWhistle();
            AvatarItems.addItem(instance);
        }
        return instance;
    }

    public ItemBisonWhistle() {
        this.func_77637_a(AvatarItems.tabItems);
        this.func_77625_d(1);
        this.func_77655_b("bison_whistle");
    }

    @Nullable
    public static UUID getBoundTo(ItemStack stack) {
        NBTTagCompound nbt = GoreCoreNBTUtil.stackCompound(stack);
        return nbt.func_74764_b("SkyBisonMost") ? nbt.func_186857_a("SkyBison") : null;
    }

    public static void setBoundTo(ItemStack stack, @Nullable UUID id) {
        NBTTagCompound nbt = GoreCoreNBTUtil.stackCompound(stack);
        if (id != null) {
            nbt.func_186854_a("SkyBison", id);
        } else {
            nbt.func_82580_o("SkyBison");
        }
    }

    @Nullable
    public static String getBisonName(ItemStack stack) {
        String name = GoreCoreNBTUtil.stackCompound(stack).func_74779_i("BisonName");
        return name.isEmpty() ? null : name;
    }

    public static void setBisonName(ItemStack stack, @Nullable String name) {
        if (name == null) {
            GoreCoreNBTUtil.stackCompound(stack).func_82580_o("BisonName");
        } else {
            GoreCoreNBTUtil.stackCompound(stack).func_74778_a("BisonName", name);
        }
    }

    public static boolean isBound(ItemStack stack) {
        return ItemBisonWhistle.getBisonName(stack) != null && ItemBisonWhistle.getBoundTo(stack) != null;
    }

    public static boolean doesPlayerOwn(ItemStack stack, EntityPlayer player) {
        World world;
        EntitySkyBison bison;
        if (ItemBisonWhistle.isBound(stack) && (bison = EntitySkyBison.findBison(world = player.field_70170_p, ItemBisonWhistle.getBoundTo(stack))) != null) {
            return bison.getOwner() == player;
        }
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (!world.field_72995_K) {
            if (timeLeft >= 55) {
                BendingData data = BendingData.get(entity);
                data.getMiscData().setBisonFollowMode(!data.getMiscData().getBisonFollowMode());
                if (data.getMiscData().getBisonFollowMode()) {
                    AvatarChatMessages.MSG_BISON_WHISTLE_FOLLOW_ON.send((ICommandSender)entity, new Object[0]);
                } else {
                    AvatarChatMessages.MSG_BISON_WHISTLE_FOLLOW_OFF.send((ICommandSender)entity, new Object[0]);
                }
            } else {
                EntitySkyBison bison = EntitySkyBison.findBison(world, ItemBisonWhistle.getBoundTo(stack));
                if (bison != null) {
                    double dist = entity.func_70032_d((Entity)bison);
                    if (dist >= 20.0) {
                        double seconds = dist / 20.0;
                        BendingData data = BendingData.get(entity);
                        data.getMiscData().setPetSummonCooldown((int)(seconds * 20.0));
                        data.addTickHandler(TickHandlerController.BISON_SUMMONER, new BendingContext(data, entity, new Raytrace.Result()));
                        AvatarChatMessages.MSG_BISON_WHISTLE_SUMMON.send((ICommandSender)entity, (int)seconds);
                    } else {
                        AvatarChatMessages.MSG_BISON_WHISTLE_NEARBY.send((ICommandSender)entity, new Object[0]);
                    }
                } else {
                    AvatarChatMessages.MSG_BISON_WHISTLE_NOT_FOUND.send((ICommandSender)entity, ItemBisonWhistle.getBisonName(stack));
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemBisonWhistle.isBound(stack)) {
            if (ItemBisonWhistle.doesPlayerOwn(stack, player)) {
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            EntitySkyBison bison = EntitySkyBison.findBison(world, ItemBisonWhistle.getBoundTo(stack));
            if (bison != null && !bison.field_70170_p.field_72995_K) {
                EntityPlayer oldOwner = bison.getOwner();
                if (oldOwner != null) {
                    TransferConfirmHandler.startTransfer(oldOwner, player, bison);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                UUID id = bison.func_184753_b();
                String username = AccountUUIDs.getUsername(id);
                AvatarChatMessages.MSG_BISON_TRANSFER_OFFLINE.send((ICommandSender)player, username == null ? "{error}" : username);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            AvatarChatMessages.MSG_BISON_WHISTLE_NOSUMMON.send((ICommandSender)player, new Object[0]);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 60;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ItemBisonWhistle.isBound(stack)) {
            tooltip.add(I18n.func_135052_a((String)"avatar.bisonWhistle.tooltipBound", (Object[])new Object[]{ItemBisonWhistle.getBisonName(stack)}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"avatar.bisonWhistle.tooltipUnbound", (Object[])new Object[0]));
        }
    }

    @Override
    public Item item() {
        return this;
    }

    @Override
    public String getModelName(int meta) {
        return "bison_whistle";
    }
}

