/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.item;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.AbilityModifier;
import com.crowsofwar.avatar.bending.bending.AbilityModifiers;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.item.IGlider;
import com.crowsofwar.avatar.network.packets.glider.PacketCUpdateClientTarget;
import com.crowsofwar.avatar.registry.AvatarItem;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.Chi;
import com.crowsofwar.avatar.util.event.AbilityUseEvent;
import com.crowsofwar.avatar.util.helper.GliderHelper;
import com.crowsofwar.avatar.util.helper.GliderPlayerHelper;
import com.crowsofwar.gorecore.util.Vector;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="avatarmod")
public class ItemGliderBase
extends ItemSword
implements IGlider,
AvatarItem {
    public static final ResourceLocation MODEL_GLIDER_BASIC_TEXTURE_RL = new ResourceLocation("avatarmod", "textures/models/glider_basic.png");
    public static final ResourceLocation MODEL_GLIDER_ADVANCED_TEXTURE_RL = new ResourceLocation("avatarmod", "textures/models/glider_advanced.png");
    public static final ResourceLocation MODEL_GLIDER_RL = new ResourceLocation("avatarmod", "models/glider/glider.obj");
    private float minSpeed;
    private float maxSpeed;
    private float pitchOffset;
    private float yBoost;
    private float fallReduction;
    private double windMultiplier;
    private double airResistance;
    private int totalDurability;
    private ResourceLocation modelRL;

    public ItemGliderBase(float minSpeed, float maxSpeed, float pitchOffset, float yBoost, float fallReduction, double windMultiplier, double airResistance, int totalDurability, ResourceLocation modelRL) {
        super(Item.ToolMaterial.WOOD);
        this.windMultiplier = windMultiplier;
        this.airResistance = airResistance;
        this.totalDurability = totalDurability;
        this.modelRL = modelRL;
        this.minSpeed = minSpeed;
        this.maxSpeed = maxSpeed;
        this.pitchOffset = pitchOffset;
        this.yBoost = yBoost;
        this.fallReduction = fallReduction;
        this.func_77656_e(totalDurability);
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("status"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return this.isGlidingGlider(entityIn, stack) ? 1.0f : (ItemGliderBase.this.isBroken(stack) ? 2.0f : 0.0f);
            }

            private boolean isGlidingGlider(EntityLivingBase entityIn, ItemStack stack) {
                return entityIn != null && entityIn instanceof EntityPlayer && GliderHelper.getIsGliderDeployed((EntityPlayer)entityIn) && GliderPlayerHelper.getGlider((EntityPlayer)entityIn) == stack;
            }
        });
    }

    public float func_150931_i() {
        return 1.0f;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        boolean isCreative;
        boolean bl = isCreative = attacker instanceof EntityPlayer && ((EntityPlayer)attacker).func_184812_l_();
        if (!isCreative) {
            stack.func_77972_a(1, attacker);
        }
        Vector velocity = Vector.getLookRectangular((Entity)attacker).times(1.1);
        target.field_70159_w += velocity.x();
        target.field_70181_x = target.field_70181_x + (velocity.y() > 0.0 ? velocity.y() + 0.2 : 0.3);
        target.field_70179_y += velocity.z();
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        BendingData data;
        if (isSelected && entityIn instanceof EntityLivingBase) {
            if (!worldIn.field_72995_K && worldIn instanceof WorldServer && entityIn.field_70173_aa % 40 == 0) {
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76424_c, 40, 0, false, false));
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76430_j, 40, 0, false, false));
            }
        } else if (entityIn.field_70173_aa % 100 == 0 && entityIn instanceof EntityLivingBase && (data = BendingData.getFromEntity((EntityLivingBase)entityIn)) != null) {
            data.removeModifiersFromAbilities(Abilities.all().stream().filter(ability -> ability.getBendingId().equals(Airbending.ID)).collect(Collectors.toList()), this.getAbilityModifier());
        }
        if (entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_184592_cb().func_77973_b() == this && !worldIn.field_72995_K && worldIn instanceof WorldServer && entityIn.field_70173_aa % 40 == 0) {
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76424_c, 40, 0, false, false));
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76430_j, 40, 0, false, false));
        }
        if (entityIn instanceof EntityLivingBase && (data = BendingData.getFromEntity((EntityLivingBase)entityIn)) != null) {
            float availableChi;
            Chi chi = data.chi();
            if (entityIn.field_70173_aa % 80 == 0 && chi != null && data.hasBendingId(Airbending.ID) && new Random().nextInt(2) + 1 >= 2 && stack.func_77951_h() && (availableChi = chi.getAvailableChi()) > 1.0f) {
                if (!(entityIn instanceof EntityPlayer) || !((EntityPlayer)entityIn).func_184812_l_()) {
                    chi.setTotalChi(chi.getTotalChi() - 2.0f);
                }
                stack.func_77972_a(-1, (EntityLivingBase)entityIn);
            }
        }
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.func_150931_i(), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 0.0, 0));
        }
        return multimap;
    }

    @SubscribeEvent
    public static void onAbilityEvent(AbilityUseEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        BendingData data = BendingData.getFromEntity(entity);
        if (data != null) {
            if (entity.func_184614_ca().func_77973_b() instanceof ItemGliderBase) {
                ItemGliderBase base = (ItemGliderBase)entity.func_184614_ca().func_77973_b();
                List<Ability> abilities = Abilities.all().stream().filter(ability -> ability.getBendingId().equals(Airbending.ID)).collect(Collectors.toList());
                if (abilities.contains(event.getAbility())) {
                    data.applyModifiersToAbilities(abilities, base.getAbilityModifier());
                }
            } else if (entity.func_184592_cb().func_77973_b() instanceof ItemGliderBase) {
                ItemGliderBase base = (ItemGliderBase)entity.func_184592_cb().func_77973_b();
                List<Ability> abilities = Abilities.all().stream().filter(ability -> ability.getBendingId().equals(Airbending.ID)).collect(Collectors.toList());
                if (abilities.contains(event.getAbility())) {
                    data.applyModifiersToAbilities(abilities, base.getAbilityModifier());
                }
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack chestItem = player.func_184582_a(EntityEquipmentSlot.CHEST);
        ItemStack itemStack = player.func_184586_b(hand);
        if (chestItem == null || chestItem.func_190926_b() || !(chestItem.func_77973_b() instanceof ItemElytra)) {
            if (this.isBroken(itemStack)) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
            }
            if (!hand.equals((Object)EnumHand.MAIN_HAND)) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
            }
            boolean isDeployed = GliderHelper.getIsGliderDeployed(player);
            GliderHelper.setIsGliderDeployed(player, !isDeployed);
            if (!world.field_72995_K) {
                AvatarMod.network.sendToAllTracking((IMessage)new PacketCUpdateClientTarget(player, GliderHelper.getIsGliderDeployed(player)), (Entity)player);
            }
        } else if (world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("avatar.gliderElytra", new Object[0]));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
    }

    @Override
    public boolean isBroken(ItemStack stack) {
        return stack.func_77951_h() && stack.func_77952_i() >= stack.func_77958_k() - 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ArrayList<ItemStack> upgrades = com.crowsofwar.avatar.util.GliderHelper.getUpgradesFromNBT(stack);
        for (ItemStack upgrade : upgrades) {
            tooltip.add(upgrade.func_82833_r() + " " + I18n.func_135052_a((String)"glider.tooltip.upgrade", (Object[])new Object[0]));
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    @Override
    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    @Override
    public void setMaxSpeed(float speed) {
        this.maxSpeed = speed;
    }

    @Override
    public float getMinSpeed() {
        return this.minSpeed;
    }

    @Override
    public void setMinSpeed(float speed) {
        this.minSpeed = speed;
    }

    @Override
    public float getYBoost() {
        return this.yBoost;
    }

    @Override
    public void setYBoost(float boost) {
        this.yBoost = boost;
    }

    @Override
    public float getFallReduction() {
        return this.fallReduction;
    }

    @Override
    public void setFallReduction(float reduction) {
        this.fallReduction = reduction;
    }

    @Override
    public float getPitchOffset() {
        return this.pitchOffset;
    }

    @Override
    public void setPitchOffset(float offset) {
        this.pitchOffset = offset;
    }

    @Override
    public double getWindMultiplier() {
        return this.windMultiplier;
    }

    @Override
    public void setWindMultiplier(double windMultiplierToSetTo) {
        this.windMultiplier = windMultiplierToSetTo;
    }

    @Override
    public double getAirResistance() {
        return this.airResistance;
    }

    @Override
    public void setAirResistance(double airResistanceToSetTo) {
        this.airResistance = airResistanceToSetTo;
    }

    @Override
    public int getTotalDurability() {
        return this.totalDurability;
    }

    @Override
    public void setTotalDurability(int durability) {
        this.totalDurability = durability;
    }

    @Override
    public int getCurrentDurability(ItemStack stack) {
        return stack.func_77952_i();
    }

    @Override
    public void setCurrentDurability(ItemStack stack, int durability) {
        this.setDamage(stack, durability);
        if (stack.func_77952_i() < 1) {
            stack.func_77964_b(1);
        }
    }

    @Override
    public ArrayList<ItemStack> getUpgrades(ItemStack glider) {
        return com.crowsofwar.avatar.util.GliderHelper.getUpgradesFromNBT(glider);
    }

    @Override
    public void removeUpgrade(ItemStack glider, ItemStack upgrade) {
    }

    @Override
    public void addUpgrade(ItemStack glider, ItemStack upgrade) {
    }

    @Override
    public ResourceLocation getModelTexture(ItemStack glider) {
        return this.modelRL;
    }

    @Override
    public void setModelTexture(ResourceLocation resourceLocation) {
        this.modelRL = resourceLocation;
    }

    public NBTTagCompound serializeNBT() {
        return null;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    @Override
    public Item item() {
        return this;
    }

    @Override
    public String getModelName(int meta) {
        return "airbender_staff";
    }

    public AbilityModifier getAbilityModifier() {
        return AbilityModifiers.STAFF_BASE_MODIFIER;
    }
}

