/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.item;

import com.crowsofwar.avatar.registry.AvatarItem;
import com.crowsofwar.avatar.registry.AvatarItems;
import java.util.List;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWaterPouch
extends Item
implements AvatarItem {
    private static ItemWaterPouch instance = null;

    public static ItemWaterPouch getInstance() {
        if (instance == null) {
            instance = new ItemWaterPouch();
            AvatarItems.addItem(instance);
        }
        return instance;
    }

    public ItemWaterPouch() {
        this.func_77637_a(AvatarItems.tabItems);
        this.func_77655_b("water_pouch");
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(false);
    }

    @Override
    public Item item() {
        return this;
    }

    @Override
    public String getModelName(int meta) {
        return "water_pouch";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltips, ITooltipFlag advanced) {
        int meta = stack.func_77960_j();
        tooltips.add(I18n.func_135052_a((String)("avatar.tooltip.water_pouch" + (meta == 0 ? ".empty" : "")), (Object[])new Object[]{meta}));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int meta = 0; meta <= 5; ++meta) {
                subItems.add((Object)new ItemStack((Item)this, 1, meta));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        boolean isFull;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = isFull = itemstack.func_77960_j() == 5;
        if (isFull) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(world, player, true);
        if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        BlockPos blockpos = raytraceresult.func_178782_a();
        if (!world.func_175660_a(player, blockpos) || !player.func_175151_a(blockpos.func_177972_a(raytraceresult.field_178784_b), raytraceresult.field_178784_b, itemstack)) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        IBlockState state = world.func_180495_p(blockpos);
        Material material = state.func_185904_a();
        if (state.func_177230_c() instanceof BlockCauldron) {
            int canBeFilled = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
            int toBeFilled = 5 - itemstack.func_77952_i();
            int willBeFilled = Math.min(canBeFilled, toBeFilled);
            ((BlockCauldron)state.func_177230_c()).func_176590_a(world, blockpos, state, canBeFilled - willBeFilled);
            player.func_71029_a(StatList.field_188078_L);
            player.func_71029_a(StatList.func_188057_b((Item)this));
            player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)this.fillPouch(itemstack, player, willBeFilled));
        }
        if (material == Material.field_151586_h) {
            int toBeFilled;
            int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            int canBeFilled = 8 - level;
            int willBeFilled = Math.min(canBeFilled, toBeFilled = 5 - itemstack.func_77952_i());
            IBlockState newState = willBeFilled > 0 ? state.func_177230_c().func_176203_a(level + willBeFilled) : Blocks.field_150350_a.func_176223_P();
            world.func_180501_a(blockpos, newState, 11);
            player.func_71029_a(StatList.func_188057_b((Item)this));
            player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)this.fillPouch(itemstack, player, willBeFilled));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    private ItemStack fillPouch(ItemStack emptyPouches, EntityPlayer player, int levels) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyPouches;
        }
        int newLevel = Math.max(5, emptyPouches.func_77952_i() + levels);
        ItemStack filledPouch = new ItemStack(emptyPouches.func_77973_b(), 1, newLevel);
        emptyPouches.func_190918_g(1);
        if (emptyPouches.func_190926_b()) {
            return filledPouch;
        }
        if (!player.field_71071_by.func_70441_a(filledPouch)) {
            player.func_71019_a(filledPouch, false);
        } else if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
        }
        return emptyPouches;
    }
}

