/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.item.scroll;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.client.gui.AvatarGuiHandler;
import com.crowsofwar.avatar.item.scroll.Scrolls;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.registry.AvatarItem;
import com.crowsofwar.avatar.registry.AvatarItems;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.gorecore.format.FormattedMessageProcessor;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemScroll
extends Item
implements AvatarItem {
    private final Scrolls.ScrollType type;

    public ItemScroll(Scrolls.ScrollType type) {
        this.type = type;
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77637_a(AvatarItems.tabItems);
        this.func_77627_a(true);
        this.func_77655_b("scroll_" + type.displayName());
    }

    public Scrolls.ScrollType getScrollType() {
        return this.type;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: 
            case 1: {
                return EnumRarity.COMMON;
            }
            case 2: {
                return EnumRarity.UNCOMMON;
            }
            case 3: 
            case 4: {
                return EnumRarity.RARE;
            }
            case 5: 
            case 6: {
                return EnumRarity.EPIC;
            }
        }
        return EnumRarity.RARE;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int meta = 0; meta < 7; ++meta) {
            items.add((Object)new ItemStack((Item)this, 1, meta));
        }
    }

    @Override
    public Item item() {
        return this;
    }

    @Override
    public String getModelName(int meta) {
        return "scroll_" + this.type.displayName();
    }

    public String func_77667_c(ItemStack stack) {
        return "item.avatarmod:scroll." + this.type.displayName() + "." + (stack.func_77960_j() + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltips, ITooltipFlag advanced) {
        String tooltip = I18n.func_135052_a((String)("avatar." + Scrolls.getTypeForStack(stack).getBendingName()), (Object[])new Object[0]);
        tooltips.add(tooltip);
        if (Scrolls.getTypeForStack(stack).isSpecialtyType()) {
            String translated = I18n.func_135052_a((String)"avatar.specialtyScroll.tooltip", (Object[])new Object[0]);
            String bendingName = Scrolls.getTypeForStack(stack).getBendingName();
            String formatted = FormattedMessageProcessor.formatText(AvatarChatMessages.MSG_SPECIALTY_SCROLL_TOOLTIP, translated, bendingName);
            tooltips.add(formatted);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        Scrolls.ScrollType type = Scrolls.getTypeForStack(player.func_184586_b(hand));
        assert (type != null);
        if (type.isSpecialtyType()) {
            this.handleSpecialtyScrollUse(world, player, player.func_184586_b(hand));
        } else {
            this.handleMainScrollUse(world, player);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private void handleMainScrollUse(World world, EntityPlayer player) {
        BendingData data = BendingData.get((EntityLivingBase)player);
        if (data.getAllBending().isEmpty()) {
            player.openGui((Object)AvatarMod.instance, 6, world, 0, 0, 0);
        } else {
            BendingStyle controller = data.getAllBending().get(0);
            int guiId = AvatarGuiHandler.getGuiId(controller.getId());
            player.openGui((Object)AvatarMod.instance, guiId, world, 0, 0, 0);
        }
    }

    private void handleSpecialtyScrollUse(World world, EntityPlayer player, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        Scrolls.ScrollType type = Scrolls.getTypeForStack(stack);
        if (Bender.isBenderSupported((EntityLivingBase)player)) {
            BendingData data = BendingData.get((EntityLivingBase)player);
            assert (type != null);
            BendingStyle specialtyStyle = BendingStyles.get(type.getBendingId());
            assert (specialtyStyle != null);
            if (data.hasBending(specialtyStyle)) {
                String specialtyName = specialtyStyle.getName();
                AvatarChatMessages.MSG_SPECIALTY_SCROLL_ALREADY_HAVE.send((ICommandSender)player, specialtyName);
                return;
            }
            UUID requiredMainBending = specialtyStyle.getParentBendingId();
            if (data.hasBendingId(requiredMainBending)) {
                data.addBending(specialtyStyle);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                String specialtyName = specialtyStyle.getName();
                AvatarChatMessages.MSG_SPECIALTY_SCROLL_SUCCESS.send((ICommandSender)player, specialtyName);
            } else {
                String specialtyName = specialtyStyle.getName();
                String mainName = BendingStyles.getName(requiredMainBending);
                AvatarChatMessages.MSG_SPECIALTY_SCROLL_FAIL.send((ICommandSender)player, specialtyName, mainName);
            }
        }
    }
}

