/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.item.scroll;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.bending.bending.combustion.Combustionbending;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.bending.bending.ice.Icebending;
import com.crowsofwar.avatar.bending.bending.lightning.Lightningbending;
import com.crowsofwar.avatar.bending.bending.sand.Sandbending;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.item.scroll.ItemScroll;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class Scrolls {
    public static ItemScroll WATER;
    public static ItemScroll EARTH;
    public static ItemScroll FIRE;
    public static ItemScroll AIR;
    public static ItemScroll COMBUSTION;
    public static ItemScroll SAND;
    public static ItemScroll ICE;
    public static ItemScroll LIGHTNING;
    public static ItemScroll ALL;

    public static ItemScroll getItemForType(ScrollType type) {
        switch (type) {
            case ALL: {
                return ALL;
            }
            case EARTH: {
                return EARTH;
            }
            case FIRE: {
                return FIRE;
            }
            case AIR: {
                return AIR;
            }
            case COMBUSTION: {
                return COMBUSTION;
            }
            case SAND: {
                return SAND;
            }
            case ICE: {
                return ICE;
            }
            case LIGHTNING: {
                return LIGHTNING;
            }
            case WATER: {
                return WATER;
            }
        }
        return null;
    }

    public static ScrollType getTypeForStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemScroll) {
            return ((ItemScroll)stack.func_77973_b()).getScrollType();
        }
        return null;
    }

    public static int getTierForStack(ItemStack stack) {
        return stack.func_77960_j() + 1;
    }

    @Nullable
    public static ItemScroll getTypeFromElement(BendingStyle style) {
        if (style instanceof Airbending) {
            return AIR;
        }
        if (style instanceof Firebending) {
            return FIRE;
        }
        if (style instanceof Waterbending) {
            return WATER;
        }
        if (style instanceof Earthbending) {
            return EARTH;
        }
        if (style instanceof Combustionbending) {
            return COMBUSTION;
        }
        if (style instanceof Icebending) {
            return ICE;
        }
        if (style instanceof Sandbending) {
            return SAND;
        }
        if (style instanceof Lightningbending) {
            return LIGHTNING;
        }
        return ALL;
    }

    public static ItemScroll getTypeFromElement(String element) {
        switch (element) {
            case "airbending": {
                return AIR;
            }
            case "firebending": {
                return FIRE;
            }
            case "waterbending": {
                return WATER;
            }
            case "earthbending": {
                return EARTH;
            }
            case "combustionbending": {
                return COMBUSTION;
            }
            case "icebending": {
                return ICE;
            }
            case "sandbending": {
                return SAND;
            }
            case "lightningbending": {
                return LIGHTNING;
            }
        }
        return ALL;
    }

    public static enum ScrollType {
        ALL(null),
        EARTH(Earthbending.ID),
        FIRE(Firebending.ID),
        WATER(Waterbending.ID),
        AIR(Airbending.ID),
        LIGHTNING(Lightningbending.ID),
        ICE(Icebending.ID),
        SAND(Sandbending.ID),
        COMBUSTION(Combustionbending.ID);

        private final UUID bendingId;

        private ScrollType(UUID bendingId) {
            this.bendingId = bendingId;
        }

        @Nullable
        public static ScrollType get(int id) {
            if (id < 0 || id >= ScrollType.values().length) {
                return null;
            }
            return ScrollType.values()[id];
        }

        public boolean equals(ScrollType type) {
            return type.getBendingName().equalsIgnoreCase(this.getBendingName());
        }

        public static int amount() {
            return ScrollType.values().length;
        }

        public boolean isCompatibleWith(ScrollType other) {
            return other == this || this == ALL || other == ALL;
        }

        public String displayName() {
            return this.name().toLowerCase();
        }

        public boolean accepts(UUID bendingId) {
            if (this.bendingId == null) {
                return true;
            }
            if (this.bendingId == bendingId) {
                return true;
            }
            return BendingStyles.get(bendingId).getParentBendingId() == this.bendingId;
        }

        public String getBendingName() {
            return BendingStyles.get(this.bendingId) == null ? "all" : BendingStyles.get(this.bendingId).getName();
        }

        @Nullable
        public UUID getBendingId() {
            return this.bendingId;
        }

        public boolean isSpecialtyType() {
            BendingStyle style = BendingStyles.get(this.bendingId);
            if (style == null) {
                return false;
            }
            return style.isSpecialtyBending();
        }

        public static ScrollType getTypeFromString(String name) {
            switch (name) {
                case "airbending": {
                    return AIR;
                }
                case "firebending": {
                    return FIRE;
                }
                case "waterbending": {
                    return WATER;
                }
                case "earthbending": {
                    return EARTH;
                }
                case "combustionbending": {
                    return COMBUSTION;
                }
                case "icebending": {
                    return ICE;
                }
                case "sandbending": {
                    return SAND;
                }
                case "lightningbending": {
                    return LIGHTNING;
                }
            }
            return ALL;
        }
    }
}

