/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import net.minecraft.command.ICommandSender;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="avatarmod")
public class AvatarAnnouncements {
    public static final String ANNOUNCEMENT_URL = "https://raw.githubusercontent.com/CrowsOfWar/AvatarMod-Announcements/master/announcements.txt";
    private static List<Announcement> announcements;

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent e) {
        for (Announcement announcement : announcements) {
            long hoursTotal = announcement.getHoursAgo();
            if (hoursTotal > 24L) {
                long days = hoursTotal / 24L;
                if (days == 1L) {
                    AvatarChatMessages.MSG_ANNOUNCEMENT_YESTERDAY.send((ICommandSender)e.player, announcement.contents, days);
                    continue;
                }
                AvatarChatMessages.MSG_ANNOUNCEMENT_DAYS.send((ICommandSender)e.player, announcement.contents, days);
                continue;
            }
            AvatarChatMessages.MSG_ANNOUNCEMENT_TODAY.send((ICommandSender)e.player, announcement.contents);
        }
    }

    private static void cleanupAnnouncements() {
        announcements.sort(Comparator.comparingLong(Announcement::getHoursAgo));
        announcements.removeIf(announcement -> announcement.getHoursAgo() > 72L);
    }

    public static void fetchAnnouncements() {
        AvatarLog.info("Fetching latest AvatarMod2 announcements...");
        announcements = new ArrayList<Announcement>();
        try {
            String inputLine;
            URL u = new URL(ANNOUNCEMENT_URL);
            URLConnection conn = u.openConnection();
            conn.setConnectTimeout(3000);
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                try {
                    announcements.add(new Announcement(inputLine));
                }
                catch (IllegalArgumentException ex) {
                    AvatarLog.error("Developers sent an incorrectly formatted announcement", ex);
                }
            }
            in.close();
            AvatarAnnouncements.cleanupAnnouncements();
        }
        catch (Exception ex) {
            AvatarLog.error("Your game will be fine, but there was a problem getting Av2 announcements", ex);
            return;
        }
        AvatarLog.info("Finished loading announcements");
    }

    private static TimeZone getSystemTimeZone() {
        String timezone = System.getProperty("user.timezone");
        if (timezone != null) {
            return TimeZone.getTimeZone(timezone);
        }
        return TimeZone.getTimeZone("UTC");
    }

    private static class Announcement {
        private final String contents;
        private final Date timestamp;

        public Announcement(String code) {
            if (!code.matches("\\d{4}-\\d{2}-\\d{2} .+")) {
                throw new IllegalArgumentException("Announcement code in incorrect format: " + code);
            }
            String[] timeStrings = code.split(" ")[0].split("-");
            int year = Integer.parseInt(timeStrings[0]);
            int month = Integer.parseInt(timeStrings[1]) - 1;
            int day = Integer.parseInt(timeStrings[2]);
            GregorianCalendar cal = new GregorianCalendar(year, month, day);
            ((Calendar)cal).setTimeZone(AvatarAnnouncements.getSystemTimeZone());
            this.timestamp = cal.getTime();
            this.contents = code.substring(code.indexOf(" ") + 1);
        }

        public Announcement(String contents, Date timestamp) {
            this.contents = contents;
            this.timestamp = timestamp;
        }

        public String toString() {
            return "[" + this.timestamp + "] " + this.contents;
        }

        public long getHoursAgo() {
            long msDiff = System.currentTimeMillis() - this.timestamp.getTime();
            return msDiff / 1000L / 60L / 60L;
        }
    }
}

