/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.bending.bending.BattlePerformanceScore;
import com.crowsofwar.avatar.network.DataTransmitter;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.Chi;
import com.crowsofwar.avatar.util.data.DataCategory;
import com.crowsofwar.avatar.util.data.MiscData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandler;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.Vision;
import com.crowsofwar.gorecore.util.GoreCoreByteBufUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DataTransmitters {
    public static final DataTransmitter<List<UUID>> BENDING_LIST = new DataTransmitter<List<UUID>>(){

        @Override
        public void write(ByteBuf buf, List<UUID> t) {
            buf.writeInt(t.size());
            for (UUID bendingId : t) {
                GoreCoreByteBufUtil.writeUUID(buf, bendingId);
            }
        }

        @Override
        public List<UUID> read(ByteBuf buf, BendingData data) {
            int size = buf.readInt();
            ArrayList<UUID> out = new ArrayList<UUID>(size);
            for (int i = 0; i < size; ++i) {
                out.add(GoreCoreByteBufUtil.readUUID(buf));
            }
            return out;
        }
    };
    public static final DataTransmitter<Map<String, AbilityData>> ABILITY_DATA = new DataTransmitter<Map<String, AbilityData>>(){

        @Override
        public void write(ByteBuf buf, Map<String, AbilityData> t) {
            Set<Map.Entry<String, AbilityData>> entries = t.entrySet();
            buf.writeInt(entries.size());
            for (Map.Entry<String, AbilityData> entry : entries) {
                entry.getValue().toBytes(buf);
            }
        }

        @Override
        public Map<String, AbilityData> read(ByteBuf buf, BendingData data) {
            HashMap<String, AbilityData> out = new HashMap<String, AbilityData>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                AbilityData abilityData = AbilityData.createFromBytes(buf, data);
                if (abilityData == null) {
                    AvatarLog.warn(AvatarLog.WarningType.WEIRD_PACKET, "Invalid ability ID sent for ability data");
                    continue;
                }
                out.put(abilityData.getAbilityName(), abilityData);
            }
            return out;
        }
    };
    public static final DataTransmitter<List<StatusControl>> STATUS_CONTROLS = new DataTransmitter<List<StatusControl>>(){

        @Override
        public void write(ByteBuf buf, List<StatusControl> t) {
            buf.writeInt(t.size());
            for (StatusControl sc : t) {
                buf.writeInt(sc.id());
            }
        }

        @Override
        public List<StatusControl> read(ByteBuf buf, BendingData data) {
            int size = buf.readInt();
            ArrayList<StatusControl> out = new ArrayList<StatusControl>();
            for (int i = 0; i < size; ++i) {
                StatusControl sc = StatusControlController.lookup(buf.readInt());
                if (sc == null) {
                    AvatarLog.warn(AvatarLog.WarningType.WEIRD_PACKET, "Invalid status control id");
                    continue;
                }
                out.add(sc);
            }
            return out;
        }
    };
    public static final DataTransmitter<Boolean> BOOLEAN = new DataTransmitter<Boolean>(){

        @Override
        public void write(ByteBuf buf, Boolean t) {
            buf.writeBoolean(t.booleanValue());
        }

        @Override
        public Boolean read(ByteBuf buf, BendingData data) {
            return buf.readBoolean();
        }
    };
    public static final DataTransmitter<Chi> CHI = new DataTransmitter<Chi>(){

        @Override
        public void write(ByteBuf buf, Chi t) {
            t.toBytes(buf);
        }

        @Override
        public Chi read(ByteBuf buf, BendingData data) {
            Chi chi = new Chi(data);
            chi.fromBytes(buf);
            return chi;
        }
    };
    public static final DataTransmitter<List<TickHandler>> TICK_HANDLERS = new DataTransmitter<List<TickHandler>>(){

        @Override
        public void write(ByteBuf buf, List<TickHandler> list) {
            buf.writeInt(list.size());
            for (TickHandler handler : list) {
                if (handler == null) continue;
                buf.writeInt(handler.id());
            }
        }

        @Override
        public List<TickHandler> read(ByteBuf buf, BendingData data) {
            int size = buf.readInt();
            ArrayList<TickHandler> out = new ArrayList<TickHandler>();
            for (int i = 0; i < size && buf.isReadable(4); ++i) {
                TickHandler list = TickHandlerController.fromId(buf.readInt());
                if (list == null) {
                    AvatarLog.warn(AvatarLog.WarningType.WEIRD_PACKET, "Invalid tick handler id");
                    continue;
                }
                out.add(list);
            }
            return out;
        }
    };
    public static final DataTransmitter<MiscData> MISC_DATA = new DataTransmitter<MiscData>(){

        @Override
        public void write(ByteBuf buf, MiscData t) {
            t.toBytes(buf);
        }

        @Override
        public MiscData read(ByteBuf buf, BendingData data) {
            MiscData misc = new MiscData(() -> data.save(DataCategory.MISC_DATA));
            misc.fromBytes(buf);
            return misc;
        }
    };
    public static final DataTransmitter<UUID> ACTIVE_BENDING = new DataTransmitter<UUID>(){

        @Override
        public void write(ByteBuf buf, UUID t) {
            GoreCoreByteBufUtil.writeUUID(buf, t == null ? new UUID(0L, 0L) : t);
        }

        @Override
        public UUID read(ByteBuf buf, BendingData data) {
            UUID id = GoreCoreByteBufUtil.readUUID(buf);
            if (id.equals(new UUID(0L, 0L))) {
                return null;
            }
            return id;
        }
    };
    public static final DataTransmitter<Vision> VISION = new DataTransmitter<Vision>(){

        @Override
        public void write(ByteBuf buf, Vision vision) {
            buf.writeInt(vision == null ? -1 : vision.ordinal());
        }

        @Override
        public Vision read(ByteBuf buf, BendingData data) {
            int id = buf.readInt();
            return id == -1 ? null : Vision.values()[id];
        }
    };
    public static final DataTransmitter<BattlePerformanceScore> PERFORMANCE = new DataTransmitter<BattlePerformanceScore>(){

        @Override
        public BattlePerformanceScore read(ByteBuf buf, BendingData data) {
            return new BattlePerformanceScore(data, buf.readDouble());
        }

        @Override
        public void write(ByteBuf buf, BattlePerformanceScore o) {
            buf.writeDouble(o.getScore());
        }
    };
}

