/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.client.gui.AvatarGuiHandler;
import com.crowsofwar.avatar.client.gui.ContainerGetBending;
import com.crowsofwar.avatar.client.gui.ContainerSkillsGui;
import com.crowsofwar.avatar.entity.mob.EntitySkyBison;
import com.crowsofwar.avatar.item.scroll.ItemScroll;
import com.crowsofwar.avatar.item.scroll.Scrolls;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.network.IPacketHandler;
import com.crowsofwar.avatar.network.packets.PacketCOpenSkillCard;
import com.crowsofwar.avatar.network.packets.PacketSBisonInventory;
import com.crowsofwar.avatar.network.packets.PacketSConfirmTransfer;
import com.crowsofwar.avatar.network.packets.PacketSCycleBending;
import com.crowsofwar.avatar.network.packets.PacketSOpenUnlockGui;
import com.crowsofwar.avatar.network.packets.PacketSParticleCollideEvent;
import com.crowsofwar.avatar.network.packets.PacketSRequestData;
import com.crowsofwar.avatar.network.packets.PacketSSendViewStatus;
import com.crowsofwar.avatar.network.packets.PacketSSkillsMenu;
import com.crowsofwar.avatar.network.packets.PacketSUnlockBending;
import com.crowsofwar.avatar.network.packets.PacketSUseAbility;
import com.crowsofwar.avatar.network.packets.PacketSUseScroll;
import com.crowsofwar.avatar.network.packets.PacketSUseStatusControl;
import com.crowsofwar.avatar.network.packets.PacketSWallJump;
import com.crowsofwar.avatar.network.packets.glider.PacketSServerGliding;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.PlayerViewRegistry;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.TransferConfirmHandler;
import com.crowsofwar.avatar.util.analytics.AnalyticEvent;
import com.crowsofwar.avatar.util.analytics.AnalyticEvents;
import com.crowsofwar.avatar.util.analytics.AvatarAnalytics;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.WallJumpManager;
import com.crowsofwar.avatar.util.data.ctx.AbilityContext;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.avatar.util.event.AbilityLevelEvent;
import com.crowsofwar.avatar.util.event.AbilityUnlockEvent;
import com.crowsofwar.avatar.util.event.ElementUnlockEvent;
import com.crowsofwar.avatar.util.event.ParticleCollideEvent;
import com.crowsofwar.avatar.util.helper.GliderHelper;
import com.crowsofwar.gorecore.util.AccountUUIDs;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandlerServer
implements IPacketHandler {
    public static final IPacketHandler instance = new PacketHandlerServer();

    private PacketHandlerServer() {
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @Override
    public IMessage onPacketReceived(IMessage packet, MessageContext ctx) {
        AvatarLog.debug("Server: Received a packet");
        if (packet instanceof PacketSUseAbility) {
            return this.handleKeypress((PacketSUseAbility)packet, ctx);
        }
        if (packet instanceof PacketSRequestData) {
            return this.handleRequestData((PacketSRequestData)packet, ctx);
        }
        if (packet instanceof PacketSUseStatusControl) {
            return this.handleUseStatusControl((PacketSUseStatusControl)packet, ctx);
        }
        if (packet instanceof PacketSWallJump) {
            return this.handleWallJump((PacketSWallJump)packet, ctx);
        }
        if (packet instanceof PacketSSkillsMenu) {
            return this.handleSkillsMenu((PacketSSkillsMenu)packet, ctx);
        }
        if (packet instanceof PacketSUseScroll) {
            return this.handleUseScroll((PacketSUseScroll)packet, ctx);
        }
        if (packet instanceof PacketSBisonInventory) {
            return this.handleInventory((PacketSBisonInventory)packet, ctx);
        }
        if (packet instanceof PacketSOpenUnlockGui) {
            return this.handleGetBending((PacketSOpenUnlockGui)packet, ctx);
        }
        if (packet instanceof PacketSUnlockBending) {
            return this.handleUnlockBending((PacketSUnlockBending)packet, ctx);
        }
        if (packet instanceof PacketSConfirmTransfer) {
            return this.handleConfirmTransfer((PacketSConfirmTransfer)packet, ctx);
        }
        if (packet instanceof PacketSCycleBending) {
            return this.handleCycleBending((PacketSCycleBending)packet, ctx);
        }
        if (packet instanceof PacketSSendViewStatus) {
            return this.handleViewUpdate((PacketSSendViewStatus)packet, ctx);
        }
        if (packet instanceof PacketSServerGliding) {
            return this.handleServerGliding((PacketSServerGliding)packet, ctx);
        }
        if (packet instanceof PacketSParticleCollideEvent) {
            MinecraftForge.EVENT_BUS.post((Event)new ParticleCollideEvent(((PacketSParticleCollideEvent)packet).getEntity(), ((PacketSParticleCollideEvent)packet).getSpawnerEntity(), ((PacketSParticleCollideEvent)packet).getAbility(), ((PacketSParticleCollideEvent)packet).getVelocity()));
            return null;
        }
        AvatarLog.warn("Unknown packet recieved: " + packet.getClass().getName());
        return null;
    }

    @Override
    public Side getSide() {
        return Side.SERVER;
    }

    private IMessage handleViewUpdate(PacketSSendViewStatus packet, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player != null) {
            PlayerViewRegistry.setPlayerViewInRegistry(player.func_110124_au(), packet.getMode());
        }
        return null;
    }

    private IMessage handleKeypress(PacketSUseAbility packet, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        Bender bender = Bender.get((EntityLivingBase)player);
        if (bender != null) {
            boolean notLevel4;
            bender.executeAbility(packet.getAbility(), packet.getRaytrace(), packet.getSwitchpath());
            String abilityName = packet.getAbility().getName();
            String level = AbilityData.get((EntityLivingBase)player, abilityName).getLevelDesc();
            AvatarAnalytics.INSTANCE.pushEvent(AnalyticEvents.getAbilityExecutionEvent(abilityName, level));
            AbilityData abilityData = AbilityData.get((EntityLivingBase)player, abilityName);
            boolean bl = notLevel4 = abilityData.getLevel() < 3;
            if (abilityData.getXp() == 100.0f && abilityData.getLastXp() < 100.0f && notLevel4) {
                UUID bendingId = packet.getAbility().getBendingId();
                AvatarChatMessages.MSG_CAN_UPGRADE_ABILITY.send((ICommandSender)player, abilityName, abilityData.getLevel() + 2);
                AvatarChatMessages.MSG_CAN_UPGRADE_ABILITY_2.send((ICommandSender)player, new Object[0]);
                AvatarChatMessages.MSG_CAN_UPGRADE_ABILITY_3.send((ICommandSender)player, BendingStyles.getName(bendingId));
                abilityData.resetLastXp();
            }
        }
        return null;
    }

    private IMessage handleRequestData(PacketSRequestData packet, MessageContext ctx) {
        UUID id = packet.getAskedPlayer();
        EntityPlayer player = AccountUUIDs.findEntityFromUUID(ctx.getServerHandler().field_147369_b.field_70170_p, id);
        if (player == null && (player = AvatarEntityUtils.getPlayerFromStringID(id.toString())) == null) {
            AvatarLog.warnHacking(ctx.getServerHandler().field_147369_b.func_70005_c_(), "Sent request data for a player with account '" + id + "', but that player is not in the world.");
            return null;
        }
        BendingData data = null;
        if (Bender.isBenderSupported((EntityLivingBase)player)) {
            data = BendingData.get((EntityLivingBase)player);
        }
        if (data != null) {
            data.saveAll();
        }
        return null;
    }

    private IMessage handleUseStatusControl(PacketSUseStatusControl packet, MessageContext ctx) {
        StatusControl sc;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        BendingData data = null;
        if (Bender.isBenderSupported((EntityLivingBase)player)) {
            data = BendingData.get((EntityLivingBase)player);
        }
        if (data != null && data.hasStatusControl(sc = packet.getStatusControl()) && sc.execute(new BendingContext(data, (EntityLivingBase)player, packet.getRaytrace()))) {
            data.removeStatusControl(packet.getStatusControl());
        }
        return null;
    }

    private IMessage handleWallJump(PacketSWallJump packet, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        Bender bender = Bender.get((EntityLivingBase)player);
        WallJumpManager jumpManager = bender.getWallJumpManager();
        if (jumpManager.knowsWallJump() && jumpManager.getWallJumpParticleType() != null && jumpManager.canWallJump()) {
            jumpManager.doWallJump(jumpManager.getWallJumpParticleType());
        }
        return null;
    }

    private IMessage handleSkillsMenu(PacketSSkillsMenu packet, MessageContext ctx) {
        UUID element;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        BendingData data = null;
        if (Bender.isBenderSupported((EntityLivingBase)player)) {
            data = BendingData.get((EntityLivingBase)player);
        }
        if (BendingStyles.has(element = packet.getElement()) && data != null && data.hasBendingId(element)) {
            int guiId = AvatarGuiHandler.getGuiId(element);
            player.openGui((Object)AvatarMod.instance, guiId, player.field_70170_p, 0, 0, 0);
            if (packet.getAbility() != null) {
                return new PacketCOpenSkillCard(packet.getAbility());
            }
        }
        return null;
    }

    private IMessage handleUseScroll(PacketSUseScroll packet, MessageContext ctx) {
        Container container;
        AbilityData abilityData;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        BendingData data = null;
        if (Bender.isBenderSupported((EntityLivingBase)player)) {
            data = BendingData.get((EntityLivingBase)player);
        }
        if (data != null && !(abilityData = data.getAbilityData(packet.getAbility())).isMaxLevel() && (abilityData.getXp() == 100.0f || abilityData.isLocked()) && (container = player.field_71070_bA) instanceof ContainerSkillsGui) {
            ItemStack stack;
            ContainerSkillsGui skills = (ContainerSkillsGui)container;
            Slot slot1 = skills.func_75139_a(0);
            Slot slot2 = skills.func_75139_a(1);
            Slot activeSlot = null;
            if (slot1.func_75216_d()) {
                activeSlot = slot1;
                abilityData.setPath(AbilityData.AbilityTreePath.FIRST);
            } else if (slot2.func_75216_d()) {
                activeSlot = slot2;
                abilityData.setPath(AbilityData.AbilityTreePath.SECOND);
            }
            if (activeSlot != null && (stack = activeSlot.func_75211_c()).func_77973_b() instanceof ItemScroll) {
                Scrolls.ScrollType type = Scrolls.getTypeForStack(stack);
                assert (type != null);
                AbilityContext aCtx = new AbilityContext(data, (EntityLivingBase)player, Bender.get((EntityLivingBase)player), new Raytrace.Result(), packet.getAbility(), Bender.get((EntityLivingBase)player).calcPowerRating(packet.getAbility().getBendingId()), false);
                if (type.accepts(packet.getAbility().getBendingId()) && packet.getAbility().isCompatibleScroll(stack, aCtx) && (abilityData.getLevel() < 0 && !MinecraftForge.EVENT_BUS.post((Event)new AbilityUnlockEvent((EntityLivingBase)player, abilityData.getAbility())) || !MinecraftForge.EVENT_BUS.post((Event)new AbilityLevelEvent((EntityLivingBase)player, abilityData.getAbility(), abilityData.getLevel() + 1, abilityData.getLevel() + 2)))) {
                    activeSlot.func_75215_d(ItemStack.field_190927_a);
                    abilityData.addLevel();
                    abilityData.setXp(0.0f);
                    String name = abilityData.getAbilityName();
                    String desc = abilityData.getLevelDesc();
                    AnalyticEvent e = AnalyticEvents.getAbilityUpgradeEvent(name, desc);
                    AvatarAnalytics.INSTANCE.pushEvent(e);
                }
            }
        }
        return null;
    }

    private IMessage handleInventory(PacketSBisonInventory packet, MessageContext ctx) {
        EntitySkyBison bison;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        if (player.func_184187_bx() instanceof EntitySkyBison && (bison = (EntitySkyBison)player.func_184187_bx()).canPlayerViewInventory((EntityPlayer)player)) {
            player.openGui((Object)AvatarMod.instance, 5, player.field_70170_p, bison.getId(), 0, 0);
        }
        return null;
    }

    private IMessage handleGetBending(PacketSOpenUnlockGui packet, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        BendingData data = null;
        if (Bender.isBenderSupported((EntityLivingBase)player)) {
            data = BendingData.get((EntityLivingBase)player);
        }
        if (data != null && data.getAllBending().isEmpty()) {
            player.openGui((Object)AvatarMod.instance, 6, player.field_70170_p, 0, 0, 0);
        }
        return null;
    }

    private IMessage handleUnlockBending(PacketSUnlockBending packet, MessageContext ctx) {
        UUID bending;
        List<UUID> eligible;
        Container container;
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        BendingData data = null;
        if (Bender.isBenderSupported((EntityLivingBase)player)) {
            data = BendingData.get((EntityLivingBase)player);
        }
        if ((container = player.field_71070_bA) instanceof ContainerGetBending && (eligible = ((ContainerGetBending)container).getEligibleBending()).contains(bending = packet.getUnlockType()) && data != null && data.getAllBending().isEmpty() && !MinecraftForge.EVENT_BUS.post((Event)new ElementUnlockEvent((EntityLivingBase)player, BendingStyles.get(bending)))) {
            data.addBendingId(bending);
            Ability ability = Objects.requireNonNull(BendingStyles.get(bending)).getAllAbilities().get(0);
            if (!MinecraftForge.EVENT_BUS.post((Event)new AbilityUnlockEvent((EntityLivingBase)player, ability))) {
                data.getAbilityData(ability).unlockAbility();
            }
            for (int i = 0; i < ((ContainerGetBending)container).getSize(); ++i) {
                container.func_75139_a(i).func_75215_d(ItemStack.field_190927_a);
            }
            int guiId = AvatarGuiHandler.getGuiId(bending);
            player.openGui((Object)AvatarMod.instance, guiId, player.field_70170_p, 0, 0, 0);
        }
        return null;
    }

    private IMessage handleConfirmTransfer(PacketSConfirmTransfer packet, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        TransferConfirmHandler.confirmTransfer((EntityPlayer)player);
        return null;
    }

    private IMessage handleCycleBending(PacketSCycleBending packet, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        BendingData data = null;
        if (Bender.isBenderSupported((EntityLivingBase)player)) {
            data = BendingData.get((EntityLivingBase)player);
        }
        if (data != null) {
            List<BendingStyle> controllers = data.getAllBending();
            controllers.sort(Comparator.comparing(BendingStyle::getName));
            if (controllers.size() > 1) {
                int index = controllers.indexOf(data.getActiveBending());
                if ((index += packet.cycleRight() ? 1 : -1) == -1) {
                    index = controllers.size() - 1;
                }
                if (index == controllers.size()) {
                    index = 0;
                }
                data.setActiveBending(controllers.get(index));
            }
        }
        return null;
    }

    private IMessage handleServerGliding(PacketSServerGliding packet, MessageContext ctx) {
        GliderHelper.setIsGliderDeployed((EntityPlayer)ctx.getServerHandler().field_147369_b, packet.isGliding == 0);
        return null;
    }
}

