/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network.packets;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.AvatarMod;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class AvatarPacket<MSG extends IMessage>
implements IMessage,
IMessageHandler<MSG, IMessage> {
    public final IMessage onMessage(MSG message, MessageContext ctx) {
        Handler handler = this.getPacketHandler();
        IThreadListener mainThread = this.getReceivedSide().isServer() ? ctx.getServerHandler().field_147369_b.func_71121_q() : AvatarMod.proxy.getClientThreadListener();
        mainThread.func_152344_a(() -> {
            IMessage followup = handler.onMessageRecieved(message, ctx);
            if (followup != null) {
                if (ctx.side.isClient()) {
                    AvatarMod.network.sendToServer(followup);
                } else {
                    AvatarMod.network.sendTo(followup, ctx.getServerHandler().field_147369_b);
                }
            }
        });
        return null;
    }

    public final void fromBytes(ByteBuf buf) {
        try {
            this.avatarFromBytes(buf);
        }
        catch (RuntimeException ex) {
            AvatarLog.warn(AvatarLog.WarningType.BAD_CLIENT_PACKET, "Error processing packet " + this.getClass().getSimpleName(), ex);
        }
    }

    public final void toBytes(ByteBuf buf) {
        try {
            this.avatarToBytes(buf);
        }
        catch (RuntimeException ex) {
            AvatarLog.warn(AvatarLog.WarningType.BAD_CLIENT_PACKET, "Error processing packet " + this.getClass().getSimpleName(), ex);
        }
    }

    protected abstract void avatarFromBytes(ByteBuf var1);

    protected abstract void avatarToBytes(ByteBuf var1);

    protected abstract Side getReceivedSide();

    protected abstract Handler<MSG> getPacketHandler();

    @FunctionalInterface
    public static interface Handler<MSG extends IMessage> {
        public IMessage onMessageRecieved(MSG var1, MessageContext var2);
    }
}

