/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network.packets;

import com.crowsofwar.avatar.network.PacketRedirector;
import com.crowsofwar.avatar.network.packets.AvatarPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.relauncher.Side;

public class PacketCParticles
extends AvatarPacket<PacketCParticles> {
    private EnumParticleTypes particle;
    private int minimum;
    private int maximum;
    private double x;
    private double y;
    private double z;
    private double maxVelocityX;
    private double maxVelocityY;
    private double maxVelocityZ;
    private boolean velIsMagnitude;

    public PacketCParticles() {
    }

    public PacketCParticles(EnumParticleTypes particle, int minimum, int maximum, double x, double y, double z, double maxVelocityX, double maxVelocityY, double maxVelocityZ, boolean velIsMagnitude) {
        this.particle = particle;
        this.minimum = minimum;
        this.maximum = maximum;
        this.x = x;
        this.y = y;
        this.z = z;
        this.maxVelocityX = maxVelocityX;
        this.maxVelocityY = maxVelocityY;
        this.maxVelocityZ = maxVelocityZ;
        this.velIsMagnitude = velIsMagnitude;
    }

    @Override
    public void avatarFromBytes(ByteBuf buf) {
        this.particle = EnumParticleTypes.values()[buf.readInt()];
        this.minimum = buf.readInt();
        this.maximum = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.maxVelocityX = buf.readDouble();
        this.maxVelocityY = buf.readDouble();
        this.maxVelocityZ = buf.readDouble();
        this.velIsMagnitude = buf.readBoolean();
    }

    @Override
    public void avatarToBytes(ByteBuf buf) {
        buf.writeInt(this.particle.ordinal());
        buf.writeInt(this.minimum);
        buf.writeInt(this.maximum);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.maxVelocityX);
        buf.writeDouble(this.maxVelocityY);
        buf.writeDouble(this.maxVelocityZ);
        buf.writeBoolean(this.velIsMagnitude);
    }

    @Override
    protected Side getReceivedSide() {
        return Side.CLIENT;
    }

    @Override
    protected AvatarPacket.Handler<PacketCParticles> getPacketHandler() {
        return PacketRedirector::redirectMessage;
    }

    public EnumParticleTypes getParticle() {
        return this.particle;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getMaxVelocityX() {
        return this.maxVelocityX;
    }

    public double getMaxVelocityY() {
        return this.maxVelocityY;
    }

    public double getMaxVelocityZ() {
        return this.maxVelocityZ;
    }

    public boolean getVelIsMagnitude() {
        return this.velIsMagnitude;
    }
}

