/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network.packets;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.network.packets.AvatarPacket;
import com.crowsofwar.avatar.util.data.AvatarPlayerData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.DataCategory;
import com.crowsofwar.gorecore.GoreCore;
import com.crowsofwar.gorecore.util.GoreCoreByteBufUtil;
import io.netty.buffer.ByteBuf;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;

public class PacketCPlayerData
extends AvatarPacket<PacketCPlayerData> {
    private BendingData data;
    private UUID playerId;
    private SortedSet<DataCategory> changed;

    public PacketCPlayerData() {
    }

    public PacketCPlayerData(BendingData data, UUID player, SortedSet<DataCategory> changed) {
        this.data = data;
        this.playerId = player;
        this.changed = changed;
    }

    @Override
    public void avatarFromBytes(ByteBuf buf) {
        this.playerId = GoreCoreByteBufUtil.readUUID(buf);
        EntityPlayerSP clientP = FMLClientHandler.instance().getClientPlayerEntity();
        EntityPlayerSP entityPlayerSP = clientP = clientP == null ? Minecraft.func_71410_x().field_71439_g : clientP;
        if (GoreCore.proxy.getClientSidePlayer() != null || clientP != null) {
            BendingData data;
            AvatarPlayerData playerData = AvatarPlayerData.fetcher().fetch(GoreCore.proxy.getClientSidePlayer() == null ? clientP.field_70170_p : GoreCore.proxy.getClientSidePlayer().field_70170_p, this.playerId);
            if (playerData != null && (data = playerData.getData()) != null) {
                this.changed = new TreeSet<DataCategory>();
                int size = buf.readInt();
                for (int i = 0; i < size; ++i) {
                    this.changed.add(DataCategory.values()[buf.readInt()]);
                }
                ByteBuf copyBuf = buf.copy();
                AvatarMod.proxy.getClientThreadListener().func_152344_a(() -> {
                    for (DataCategory category : this.changed) {
                        category.read(copyBuf, data);
                    }
                });
            }
        } else {
            AvatarLog.warn(AvatarLog.WarningType.WEIRD_PACKET, "Server sent a packet about data for player " + this.playerId + " but data couldn't be found for them");
            BendingData trashData = new BendingData(dataCategory -> {}, () -> {});
            this.changed = new TreeSet<DataCategory>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.changed.add(DataCategory.values()[buf.readInt()]);
            }
            for (DataCategory category : this.changed) {
                category.read(buf, trashData);
            }
        }
    }

    @Override
    public void avatarToBytes(ByteBuf buf) {
        GoreCoreByteBufUtil.writeUUID(buf, this.playerId);
        buf.writeInt(this.changed.size());
        for (DataCategory category : this.changed) {
            buf.writeInt(category.ordinal());
        }
        for (DataCategory category : this.changed) {
            category.write(buf, this.data);
        }
    }

    @Override
    protected Side getReceivedSide() {
        return Side.CLIENT;
    }

    @Override
    protected AvatarPacket.Handler<PacketCPlayerData> getPacketHandler() {
        return (msg, ctx) -> null;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }
}

