/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network.packets;

import com.crowsofwar.avatar.network.PacketRedirector;
import com.crowsofwar.avatar.network.packets.AvatarPacket;
import com.crowsofwar.gorecore.util.GoreCoreByteBufUtil;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraftforge.fml.relauncher.Side;

public class PacketCPowerRating
extends AvatarPacket<PacketCPowerRating> {
    private Map<UUID, Double> powerRatings;

    public PacketCPowerRating() {
    }

    public PacketCPowerRating(Map<UUID, Double> powerRatings) {
        this.powerRatings = powerRatings;
    }

    @Override
    protected void avatarFromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.powerRatings = new HashMap<UUID, Double>();
        for (int i = 0; i < size; ++i) {
            UUID bendingType = GoreCoreByteBufUtil.readUUID(buf);
            double powerRating = buf.readDouble();
            this.powerRatings.put(bendingType, powerRating);
        }
    }

    @Override
    protected void avatarToBytes(ByteBuf buf) {
        buf.writeInt(this.powerRatings.size());
        Set<Map.Entry<UUID, Double>> entries = this.powerRatings.entrySet();
        for (Map.Entry<UUID, Double> entry : entries) {
            GoreCoreByteBufUtil.writeUUID(buf, entry.getKey());
            buf.writeDouble(entry.getValue().doubleValue());
        }
    }

    @Override
    protected Side getReceivedSide() {
        return Side.CLIENT;
    }

    @Override
    protected AvatarPacket.Handler<PacketCPowerRating> getPacketHandler() {
        return PacketRedirector::redirectMessage;
    }

    public Map<UUID, Double> getPowerRatings() {
        return this.powerRatings;
    }
}

