/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network.packets;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.config.AbilityProperties;
import com.crowsofwar.avatar.network.PacketRedirector;
import com.crowsofwar.avatar.network.packets.AvatarPacket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraftforge.fml.relauncher.Side;

public class PacketCSyncAbilityProperties
extends AvatarPacket<PacketCSyncAbilityProperties> {
    public AbilityProperties[] properties;

    public PacketCSyncAbilityProperties() {
    }

    public PacketCSyncAbilityProperties(AbilityProperties ... properties) {
        this.properties = properties;
    }

    @Override
    protected void avatarFromBytes(ByteBuf buf) {
        ArrayList propertiesList = new ArrayList();
        int i = 0;
        while (buf.isReadable() && i < Abilities.all().size()) {
            propertiesList.add(Abilities.all().stream().map(a -> a.properties).collect(Collectors.toList()).get(i++));
        }
        this.properties = propertiesList.toArray(new AbilityProperties[0]);
    }

    @Override
    protected void avatarToBytes(ByteBuf buf) {
        for (AbilityProperties properties : this.properties) {
            if (properties != null) {
                properties.write(buf);
                continue;
            }
            AvatarLog.warn(AvatarLog.WarningType.CONFIGURATION, "Properties file is null! Whack!");
        }
    }

    @Override
    protected Side getReceivedSide() {
        return Side.CLIENT;
    }

    @Override
    protected AvatarPacket.Handler<PacketCSyncAbilityProperties> getPacketHandler() {
        return PacketRedirector::redirectMessage;
    }
}

