/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network.packets;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.network.PacketRedirector;
import com.crowsofwar.avatar.network.packets.AvatarPacket;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSParticleCollideEvent
extends AvatarPacket<PacketSParticleCollideEvent> {
    private Entity entity;
    private UUID bendingID;
    private Entity spawner;
    private Ability ability;
    private Vec3d velocity;

    public PacketSParticleCollideEvent(Entity entity, Vec3d velocity, Entity spawner, UUID bendingID) {
        this.entity = entity;
        this.bendingID = bendingID;
        this.spawner = spawner;
        this.velocity = velocity;
    }

    public PacketSParticleCollideEvent(Entity entity, Vec3d velocity, Entity spawner, Ability ability) {
        this.entity = entity;
        this.ability = ability;
        this.bendingID = ability.getBendingId() == null || ability == null ? Airbending.ID : ability.getBendingId();
        this.spawner = spawner;
        this.velocity = velocity;
    }

    public PacketSParticleCollideEvent() {
    }

    @Override
    protected void avatarFromBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        this.entity = AvatarEntityUtils.getEntityFromStringID(buffer.func_179253_g().toString());
        this.spawner = AvatarEntityUtils.getEntityFromStringID(buffer.func_179253_g().toString());
        this.bendingID = buffer.func_179253_g();
        this.ability = Abilities.get(buffer.func_150789_c(buffer.func_150792_a()));
        this.velocity = new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    @Override
    protected void avatarToBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.func_179252_a(this.entity.func_110124_au());
        buffer.func_179252_a(this.spawner.func_110124_au());
        buffer.func_179252_a(this.bendingID);
        buffer.func_150787_b(this.ability.getName().length());
        buffer.func_180714_a(this.ability.getName());
        buffer.writeDouble(this.velocity.field_72450_a);
        buffer.writeDouble(this.velocity.field_72448_b);
        buffer.writeDouble(this.velocity.field_72449_c);
    }

    @Override
    protected Side getReceivedSide() {
        return Side.SERVER;
    }

    @Override
    protected AvatarPacket.Handler<PacketSParticleCollideEvent> getPacketHandler() {
        return PacketRedirector::redirectMessage;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Entity getSpawnerEntity() {
        return this.spawner;
    }

    public UUID getBendingID() {
        return this.bendingID;
    }

    public Ability getAbility() {
        return this.ability;
    }

    public Vec3d getVelocity() {
        return this.velocity;
    }
}

