/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network.packets;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.network.PacketRedirector;
import com.crowsofwar.avatar.network.packets.AvatarPacket;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSSkillsMenu
extends AvatarPacket<PacketSSkillsMenu> {
    private byte element;
    private int abilityId;

    public PacketSSkillsMenu() {
    }

    public PacketSSkillsMenu(UUID element) {
        this(element, null);
    }

    public PacketSSkillsMenu(UUID element, @Nullable Ability ability) {
        this.element = BendingStyles.getNetworkId(element);
        this.abilityId = ability == null ? -1 : Abilities.all().indexOf(ability);
    }

    @Override
    public void avatarFromBytes(ByteBuf buf) {
        this.element = buf.readByte();
        this.abilityId = buf.readInt();
    }

    @Override
    public void avatarToBytes(ByteBuf buf) {
        buf.writeByte((int)this.element);
        buf.writeInt(this.abilityId);
    }

    @Override
    protected Side getReceivedSide() {
        return Side.SERVER;
    }

    @Override
    protected AvatarPacket.Handler<PacketSSkillsMenu> getPacketHandler() {
        return PacketRedirector::redirectMessage;
    }

    public UUID getElement() {
        return BendingStyles.get(this.element).getId();
    }

    @Nullable
    public Ability getAbility() {
        if (this.abilityId == -1) {
            return null;
        }
        return Abilities.all().get(this.abilityId);
    }
}

