/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network.packets;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.network.PacketRedirector;
import com.crowsofwar.avatar.network.packets.AvatarPacket;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.gorecore.util.GoreCoreByteBufUtil;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSUseAbility
extends AvatarPacket<PacketSUseAbility> {
    private Ability ability;
    private Raytrace.Result raytrace;
    private boolean switchPath;

    public PacketSUseAbility() {
    }

    public PacketSUseAbility(Ability ability, Raytrace.Result raytrace, boolean switchPath) {
        this.ability = ability;
        this.raytrace = raytrace;
        this.switchPath = switchPath;
    }

    @Override
    public void avatarFromBytes(ByteBuf buf) {
        this.ability = Abilities.get(GoreCoreByteBufUtil.readString(buf));
        if (this.ability == null) {
            throw new NullPointerException("Server sent invalid ability over network: ID " + this.ability);
        }
        this.raytrace = Raytrace.Result.fromBytes(buf);
        this.switchPath = buf.readBoolean();
    }

    @Override
    public void avatarToBytes(ByteBuf buf) {
        GoreCoreByteBufUtil.writeString(buf, this.ability.getName());
        this.raytrace.toBytes(buf);
        buf.writeBoolean(this.switchPath);
    }

    @Override
    public Side getReceivedSide() {
        return Side.SERVER;
    }

    public Ability getAbility() {
        return this.ability;
    }

    public boolean getSwitchpath() {
        return this.switchPath;
    }

    public Raytrace.Result getRaytrace() {
        return this.raytrace;
    }

    @Override
    protected AvatarPacket.Handler<PacketSUseAbility> getPacketHandler() {
        return PacketRedirector::redirectMessage;
    }
}

