/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.network.packets;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.network.PacketRedirector;
import com.crowsofwar.avatar.network.packets.AvatarPacket;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.StatusControl;
import com.crowsofwar.avatar.util.data.StatusControlController;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSUseStatusControl
extends AvatarPacket<PacketSUseStatusControl> {
    private StatusControl statusControl;
    private Raytrace.Result raytrace;

    public PacketSUseStatusControl() {
    }

    public PacketSUseStatusControl(StatusControl control, Raytrace.Result raytrace) {
        this.statusControl = control;
        this.raytrace = raytrace;
    }

    @Override
    public void avatarFromBytes(ByteBuf buf) {
        int id = buf.readInt();
        this.statusControl = StatusControlController.lookup(id);
        if (this.statusControl == null) {
            AvatarLog.warn(AvatarLog.WarningType.BAD_CLIENT_PACKET, "Player trying to crash the server?? While sending UseStatusControl packet, sent invalid id " + id);
            return;
        }
        this.raytrace = Raytrace.Result.fromBytes(buf);
    }

    @Override
    public void avatarToBytes(ByteBuf buf) {
        buf.writeInt(this.statusControl.id());
        this.raytrace.toBytes(buf);
    }

    @Override
    protected Side getReceivedSide() {
        return Side.SERVER;
    }

    @Override
    protected AvatarPacket.Handler<PacketSUseStatusControl> getPacketHandler() {
        return PacketRedirector::redirectMessage;
    }

    public StatusControl getStatusControl() {
        return this.statusControl;
    }

    public Raytrace.Result getRaytrace() {
        return this.raytrace;
    }
}

