/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import com.crowsofwar.avatar.item.ItemBisonArmor;
import com.crowsofwar.avatar.item.ItemBisonSaddle;
import com.crowsofwar.avatar.util.data.BenderInfo;
import com.crowsofwar.gorecore.util.Vector;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;

public class AvatarDataSerializers {
    public static final DataSerializer<Block> SERIALIZER_BLOCK = new AvatarSerializer<Block>(){

        public void write(PacketBuffer buf, Block value) {
            buf.writeInt(Block.func_149682_b((Block)value));
        }

        public Block read(PacketBuffer buf) throws IOException {
            return Block.func_149729_e((int)buf.readInt());
        }

        public DataParameter<Block> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Block copyValue(Block block) {
            return block;
        }
    };
    public static final DataSerializer<Vector> SERIALIZER_VECTOR = new AvatarSerializer<Vector>(){

        public void write(PacketBuffer buf, Vector value) {
            buf.writeDouble(value.x());
            buf.writeDouble(value.y());
            buf.writeDouble(value.z());
        }

        public Vector read(PacketBuffer buf) throws IOException {
            return new Vector(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public DataParameter<Vector> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Vector copyValue(Vector vec) {
            return vec;
        }
    };
    public static final DataSerializer<BenderInfo> SERIALIZER_BENDER = new AvatarSerializer<BenderInfo>(){

        public void write(PacketBuffer buf, BenderInfo info) {
            info.writeToBytes((ByteBuf)buf);
        }

        public BenderInfo read(PacketBuffer buf) throws IOException {
            return BenderInfo.readFromBytes((ByteBuf)buf);
        }

        public DataParameter<BenderInfo> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public BenderInfo copyValue(BenderInfo benderInfo) {
            return benderInfo;
        }
    };
    public static final DataSerializer<ItemBisonSaddle.SaddleTier> SERIALIZER_SADDLE = new AvatarSerializer<ItemBisonSaddle.SaddleTier>(){

        public void write(PacketBuffer buf, ItemBisonSaddle.SaddleTier value) {
            buf.writeInt(value == null ? -1 : value.id());
        }

        public ItemBisonSaddle.SaddleTier read(PacketBuffer buf) throws IOException {
            int id = buf.readInt();
            return id == -1 ? null : ItemBisonSaddle.SaddleTier.get(id);
        }

        public DataParameter<ItemBisonSaddle.SaddleTier> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public ItemBisonSaddle.SaddleTier copyValue(ItemBisonSaddle.SaddleTier tier) {
            return tier;
        }
    };
    public static final DataSerializer<ItemBisonArmor.ArmorTier> SERIALIZER_ARMOR = new AvatarSerializer<ItemBisonArmor.ArmorTier>(){

        public void write(PacketBuffer buf, ItemBisonArmor.ArmorTier value) {
            buf.writeInt(value == null ? -1 : value.id());
        }

        public ItemBisonArmor.ArmorTier read(PacketBuffer buf) throws IOException {
            int id = buf.readInt();
            return id == -1 ? null : ItemBisonArmor.ArmorTier.get(id);
        }

        public DataParameter<ItemBisonArmor.ArmorTier> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public ItemBisonArmor.ArmorTier copyValue(ItemBisonArmor.ArmorTier tier) {
            return tier;
        }
    };

    public static void register() {
        DataSerializers.func_187189_a(SERIALIZER_BLOCK);
        DataSerializers.func_187189_a(SERIALIZER_VECTOR);
        DataSerializers.func_187189_a(SERIALIZER_BENDER);
        DataSerializers.func_187189_a(SERIALIZER_SADDLE);
        DataSerializers.func_187189_a(SERIALIZER_ARMOR);
    }

    private static abstract class AvatarSerializer<T>
    implements DataSerializer<T> {
        protected AvatarSerializer() {
        }
    }
}

