/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AvatarEntityUtils {
    public static void applyMotionToEntityInDirection(Entity entity, EnumFacing cardinal, double velocity) {
        switch (cardinal) {
            case NORTH: {
                entity.field_70179_y = -velocity;
                break;
            }
            case EAST: {
                entity.field_70159_w = velocity;
                break;
            }
            case SOUTH: {
                entity.field_70179_y = velocity;
                break;
            }
            case WEST: {
                entity.field_70159_w = -velocity;
                break;
            }
        }
    }

    public static void smeltItemEntity(EntityItem entity) {
        ItemStack stack = entity.func_92059_d();
        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        EntityItem item = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + 0.75, entity.field_70161_v, smelted);
        item.func_174869_p();
        item.func_92059_d().func_190920_e(stack.func_190916_E());
        item.func_184224_h(true);
        if (!entity.field_70170_p.field_72995_K) {
            entity.field_70170_p.func_72838_d((Entity)item);
        }
        entity.func_70106_y();
    }

    public static void smeltItemEntity(EntityItem entity, int smeltLevel) {
        ItemStack stack = entity.func_92059_d();
        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        float exp = FurnaceRecipes.func_77602_a().func_151398_b(stack);
        boolean canSmelt = false;
        switch (smeltLevel) {
            default: {
                canSmelt = true;
                break;
            }
            case 4: {
                canSmelt = stack.func_77973_b() instanceof ItemArmor || stack.func_77973_b() instanceof ItemSword;
            }
            case 3: {
                canSmelt |= stack.func_77973_b() instanceof ItemTool;
            }
            case 2: {
                canSmelt |= stack.func_77973_b() instanceof ItemFood;
            }
            case 1: {
                canSmelt |= stack.func_77973_b() instanceof ItemBlock;
            }
        }
        if ((float)smeltLevel / 4.0f > exp && canSmelt) {
            boolean rarity;
            smeltLevel = Math.max(0, Math.min(smeltLevel, 4) - 1);
            boolean bl = rarity = smelted.func_77953_t().ordinal() <= smeltLevel;
            if (rarity) {
                EntityItem item = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u + 0.75, entity.field_70161_v, smelted);
                item.func_92059_d().func_190920_e(stack.func_190916_E());
                item.func_174869_p();
                item.func_184224_h(true);
                if (!entity.field_70170_p.field_72995_K) {
                    entity.field_70170_p.func_72838_d((Entity)item);
                }
                entity.func_70106_y();
            }
        }
    }

    public static void setRotationFromPosition(Entity toChange, Entity lookingAt) {
        float rYaw;
        double dx = toChange.field_70165_t - lookingAt.field_70165_t;
        double dz = toChange.field_70161_v - lookingAt.field_70161_v;
        double angle = Math.atan2(dz, dx) * 180.0 / Math.PI;
        double pitch = Math.atan2(toChange.field_70163_u + (double)toChange.func_70047_e() - (lookingAt.field_70163_u + (double)(lookingAt.field_70131_O / 2.0f)), Math.sqrt(dx * dx + dz * dz)) * 180.0 / Math.PI;
        double distance = toChange.func_70032_d(lookingAt);
        for (rYaw = (float)(angle - (double)toChange.field_70177_z); rYaw > 180.0f; rYaw -= 360.0f) {
        }
        while (rYaw < -180.0f) {
            rYaw += 360.0f;
        }
        float rPitch = (float)pitch - (float)(10.0 / Math.sqrt(distance)) + (float)(distance * Math.PI / 90.0);
        toChange.func_70082_c(rYaw += 90.0f, -(rPitch - toChange.field_70125_A));
    }

    public static void setRotationFromPosition(Entity toChange, Vec3d lookingAt) {
        float rYaw;
        double dx = toChange.field_70165_t - lookingAt.field_72450_a;
        double dz = toChange.field_70161_v - lookingAt.field_72449_c;
        double angle = Math.atan2(dz, dx) * 180.0 / Math.PI;
        double pitch = Math.atan2(toChange.field_70163_u + (double)toChange.func_70047_e() - lookingAt.field_72448_b, Math.sqrt(dx * dx + dz * dz)) * 180.0 / Math.PI;
        double distance = toChange.func_70011_f(lookingAt.field_72450_a, lookingAt.field_72448_b, lookingAt.field_72449_c);
        for (rYaw = (float)(angle - (double)toChange.field_70177_z); rYaw > 180.0f; rYaw -= 360.0f) {
        }
        while (rYaw < -180.0f) {
            rYaw += 360.0f;
        }
        float rPitch = (float)pitch - (float)(10.0 / Math.sqrt(distance)) + (float)(distance * Math.PI / 90.0);
        AvatarEntityUtils.turnEntity(toChange, rYaw += 90.0f, -(rPitch - toChange.field_70125_A), 1.25f);
    }

    public static Entity getEntityFromStringID(String UUID2) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(UUID.fromString(UUID2));
    }

    public static EntityPlayer getPlayerFromStringID(String UUID2) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(UUID.fromString(UUID2));
    }

    public static EntityPlayer getPlayerFromUsername(String username) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(username);
    }

    @SideOnly(value=Side.CLIENT)
    public static void turnEntity(Entity entity, float yaw, float pitch, float turnSpeed) {
        float f = entity.field_70125_A;
        float f1 = entity.field_70177_z;
        entity.field_70177_z = (float)((double)entity.field_70177_z + (double)yaw * 0.15);
        entity.field_70125_A = (float)((double)entity.field_70125_A - (double)pitch * 0.15);
        entity.field_70125_A = MathHelper.func_76131_a((float)entity.field_70125_A, (float)-90.0f, (float)90.0f);
        entity.field_70127_C += entity.field_70125_A * turnSpeed - f;
        entity.field_70126_B += entity.field_70177_z * turnSpeed - f1;
        if (entity.func_184187_bx() != null) {
            entity.func_184187_bx().func_184190_l(entity);
        }
    }

    public static List<EntityLivingBase> getLivingEntitiesWithinRadius(double radius, double x, double y, double z, World world) {
        return AvatarEntityUtils.getEntitiesWithinRadius(radius, x, y, z, world, EntityLivingBase.class);
    }

    public static List<Entity> getEntitiesWithinRadius(double radius, double x, double y, double z, World world) {
        return AvatarEntityUtils.getEntitiesWithinRadius(radius, x, y, z, world, Entity.class);
    }

    public static <T extends Entity> List<T> getEntitiesWithinRadius(double radius, double x, double y, double z, World world, Class<T> entityType) {
        AxisAlignedBB aabb = new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List entityList = world.func_72872_a(entityType, aabb);
        for (int i = 0; i < entityList.size(); ++i) {
            if (!(((Entity)entityList.get(i)).func_70011_f(x, y, z) > radius)) continue;
            entityList.remove(i);
            break;
        }
        return entityList;
    }

    public static Vec3d getMiddleOfEntity(Entity entity) {
        double x = entity.func_174813_aQ().field_72336_d - entity.func_174813_aQ().field_72340_a;
        double y = entity.func_174813_aQ().field_72337_e - entity.func_174813_aQ().field_72338_b;
        double z = entity.func_174813_aQ().field_72334_f - entity.func_174813_aQ().field_72339_c;
        return new Vec3d(entity.func_174813_aQ().field_72340_a + x / 2.0, entity.func_174813_aQ().field_72338_b + y / 2.0, entity.func_174813_aQ().field_72339_c + z / 2.0);
    }

    @Nullable
    public static Vec3d getMiddleOfBlock(IBlockState block, World world, BlockPos pos) {
        AxisAlignedBB box = block.func_185890_d((IBlockAccess)world, pos);
        if (box != null) {
            double x = box.field_72336_d - box.field_72340_a;
            double y = box.field_72337_e - box.field_72338_b;
            double z = box.field_72334_f - box.field_72339_c;
            return new Vec3d(box.field_72340_a + x / 2.0, box.field_72338_b + y / 2.0, box.field_72339_c + z / 2.0);
        }
        return null;
    }

    public static Vec3d getMiddleOfAABB(AxisAlignedBB box) {
        double x = box.field_72336_d - box.field_72340_a;
        double y = box.field_72337_e - box.field_72338_b;
        double z = box.field_72334_f - box.field_72339_c;
        return new Vec3d(box.field_72340_a + x / 2.0, box.field_72338_b + y / 2.0, box.field_72339_c + z / 2.0);
    }

    public static Vec3d getBottomMiddleOfEntity(Entity entity) {
        double x = entity.func_174813_aQ().field_72336_d - entity.func_174813_aQ().field_72340_a;
        double z = entity.func_174813_aQ().field_72334_f - entity.func_174813_aQ().field_72339_c;
        return new Vec3d(entity.func_174813_aQ().field_72340_a + x / 2.0, entity.func_174813_aQ().field_72338_b, entity.func_174813_aQ().field_72339_c + z / 2.0);
    }

    public static void attackDragon(EntityDragon hurt, DamageSource source, float damage) {
        hurt.func_70965_a(hurt.field_70987_i, source, damage);
    }

    public static Vec3d[] getVertices(AxisAlignedBB box) {
        return new Vec3d[]{new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72334_f)};
    }
}

