/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AvatarParticleUtils {
    public static Vec3d rotateAroundAxisX(Vec3d v, double angle) {
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double y = v.field_72448_b * cos - v.field_72449_c * sin;
        double z = v.field_72448_b * sin + v.field_72449_c * cos;
        return new Vec3d(v.field_72450_a, y, z);
    }

    public static Vec3d rotateAroundAxisY(Vec3d v, double angle) {
        angle = -angle;
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.field_72450_a * cos + v.field_72449_c * sin;
        double z = v.field_72450_a * -sin + v.field_72449_c * cos;
        return new Vec3d(x, v.field_72448_b, z);
    }

    public static Vec3d rotateAroundAxisZ(Vec3d v, double angle) {
        angle = Math.toRadians(angle);
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = v.field_72450_a * cos - v.field_72448_b * sin;
        double y = v.field_72450_a * sin + v.field_72448_b * cos;
        return new Vec3d(x, y, v.field_72449_c);
    }

    public static void spawnDirectionalVortex(World world, EntityLivingBase entity, Vec3d direction, int particleAmount, double vortexLength, double minRadius, double radiusScale, EnumParticleTypes particle, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        for (int angle = 0; angle < particleAmount; ++angle) {
            double radius = minRadius + (double)angle / radiusScale;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)particleAmount / vortexLength);
            double z = radius * Math.sin(angle);
            Vec3d pos = new Vec3d(x, y, z);
            if (entity != null && direction != null) {
                pos = AvatarParticleUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
                pos = AvatarParticleUtils.rotateAroundAxisY(pos, entity.field_70177_z);
                world.func_175682_a(particle, true, pos.field_72450_a + posX + direction.field_72450_a, pos.field_72448_b + posY + direction.field_72448_b, pos.field_72449_c + posZ + direction.field_72449_c, velX, velY, velZ, new int[0]);
                continue;
            }
            world.func_175682_a(particle, false, x + posX, y + posY, z + posZ, velX, velY, velZ, new int[0]);
        }
    }

    public static void spawnSpinningDirectionalVortex(World world, EntityLivingBase entity, Vec3d direction, int maxAngle, double vortexLength, double minRadius, double radiusScale, EnumParticleTypes particle, Vec3d position, Vec3d particleSpeed, Vec3d entitySpeed) {
        for (int angle = 0; angle < maxAngle; ++angle) {
            double angle2 = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double radius = minRadius + (double)angle / radiusScale;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            double speed = world.field_73012_v.nextDouble() * 2.0 + 1.0;
            double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
            angle2 += omega;
            Vec3d pos = new Vec3d(x, y, z);
            if (entity == null || direction == null) continue;
            Vec3d pVel = new Vec3d(particleSpeed.field_72450_a * radius * omega * Math.cos(angle2), particleSpeed.field_72448_b, particleSpeed.field_72449_c * radius * omega * Math.sin(angle2));
            pVel = AvatarParticleUtils.rotateAroundAxisX(pVel, entity.field_70125_A - 90.0f);
            pVel = AvatarParticleUtils.rotateAroundAxisY(pVel, entity.field_70177_z);
            pos = AvatarParticleUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
            pos = AvatarParticleUtils.rotateAroundAxisY(pos, entity.field_70177_z);
            world.func_175682_a(particle, true, pos.field_72450_a + position.field_72450_a + direction.field_72450_a, pos.field_72448_b + position.field_72448_b + direction.field_72448_b, pos.field_72449_c + position.field_72449_c + direction.field_72449_c, pVel.field_72450_a + entitySpeed.field_72450_a, pVel.field_72448_b + entitySpeed.field_72448_b, pVel.field_72449_c + entitySpeed.field_72449_c, new int[0]);
        }
    }

    public static void spawnSpinningVortex(World world, int maxAngle, double vortexHeight, double minRadius, double radiusScale, EnumParticleTypes particle, Vec3d position, Vec3d particleSpeed, Vec3d entitySpeed) {
        for (int angle = 0; angle < maxAngle; ++angle) {
            double angle2 = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double radius = minRadius + (double)angle / radiusScale;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexHeight);
            double z = radius * Math.sin(angle);
            double speed = world.field_73012_v.nextDouble() * 2.0 + 1.0;
            double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
            world.func_175682_a(particle, false, x + position.field_72450_a, y + position.field_72448_b, z + position.field_72449_c, particleSpeed.field_72450_a * radius * omega * Math.cos(angle2 += omega) + entitySpeed.field_72450_a, particleSpeed.field_72448_b + entitySpeed.field_72448_b, particleSpeed.field_72449_c * radius * omega * Math.sin(angle2) + entitySpeed.field_72449_c, new int[0]);
        }
    }

    public static void spawnDirectionalHelix(World world, Entity entity, Vec3d direction, int maxAngle, double vortexLength, double radius, EnumParticleTypes particle, Vec3d position, Vec3d particleSpeed) {
        for (int angle = 0; angle < maxAngle; ++angle) {
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            Vec3d pos = new Vec3d(x, y, z);
            if (entity != null && direction != null) {
                pos = AvatarParticleUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
                pos = AvatarParticleUtils.rotateAroundAxisY(pos, entity.field_70177_z);
                world.func_175682_a(particle, true, pos.field_72450_a + position.field_72450_a + direction.field_72450_a, pos.field_72448_b + position.field_72449_c + direction.field_72448_b, pos.field_72449_c + position.field_72449_c + direction.field_72449_c, particleSpeed.field_72449_c, particleSpeed.field_72448_b, particleSpeed.field_72449_c, new int[0]);
                continue;
            }
            world.func_175682_a(particle, false, x + position.field_72450_a, y + position.field_72448_b, z + position.field_72449_c, particleSpeed.field_72449_c, particleSpeed.field_72448_b, particleSpeed.field_72449_c, new int[0]);
        }
    }

    public static void spawnSpinningDirectionalHelix(World world, Entity entity, Vec3d direction, Vec3d entitySpeed, int maxAngle, double vortexLength, double radius, EnumParticleTypes particle, Vec3d position, Vec3d particleSpeed, int maxAge, float r, float g, float b) {
        for (int angle = 0; angle < maxAngle; ++angle) {
            double actAngle = Math.toRadians(angle);
            double angle2 = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double x = radius * Math.cos(actAngle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(actAngle);
            double speed = world.field_73012_v.nextDouble() * 2.0 + 1.0;
            double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
            angle2 += omega;
            Vec3d pos = new Vec3d(x, y, z);
            if (entity == null || direction == null) continue;
            Vec3d pVel = new Vec3d(particleSpeed.field_72450_a * radius * omega * Math.cos(angle2), particleSpeed.field_72448_b, particleSpeed.field_72449_c * radius * omega * Math.sin(angle2));
            pVel = AvatarParticleUtils.rotateAroundAxisX(pVel, entity.field_70125_A - 90.0f);
            pos = AvatarParticleUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
            pos = AvatarParticleUtils.rotateAroundAxisY(pos, entity.field_70177_z);
            world.func_175682_a(particle, true, pos.field_72450_a + position.field_72450_a + direction.field_72450_a, pos.field_72448_b + position.field_72448_b + direction.field_72448_b, pos.field_72449_c + position.field_72449_c + direction.field_72449_c, pVel.field_72450_a + entitySpeed.field_72450_a, pVel.field_72448_b + entitySpeed.field_72448_b, pVel.field_72449_c + entitySpeed.field_72449_c, new int[0]);
        }
    }

    public static void spawnSpinningHelix(World world, int maxAngle, double vortexLength, double radius, EnumParticleTypes particle, Vec3d position, Vec3d particleSpeed, Vec3d entitySpeed) {
        for (int angle = 0; angle < maxAngle; ++angle) {
            double angle2 = world.field_73012_v.nextDouble() * Math.PI * 2.0;
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            double speed = world.field_73012_v.nextDouble() * 2.0 + 1.0;
            double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
            world.func_175688_a(particle, x + position.field_72450_a, y + position.field_72448_b, z + position.field_72449_c, particleSpeed.field_72450_a * radius * omega * Math.cos(angle2 += omega) + entitySpeed.field_72450_a, particleSpeed.field_72448_b + entitySpeed.field_72448_b, particleSpeed.field_72449_c * radius * omega * Math.sin(angle2) + entitySpeed.field_72449_c, new int[0]);
        }
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static Vec3d getDirectionalVortexEndPos(EntityLivingBase entity, Vec3d direction, int maxAngle, double vortexLength, double radiusScale, double posX, double posY, double posZ) {
        double radius = (double)maxAngle / radiusScale;
        double x = radius * Math.cos(maxAngle);
        double z = radius * Math.sin(maxAngle);
        Vec3d pos = new Vec3d(x, vortexLength, z);
        if (entity != null && direction != null) {
            pos = AvatarParticleUtils.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
            pos = AvatarParticleUtils.rotateAroundAxisY(pos, entity.field_70177_z);
            return new Vec3d(pos.field_72450_a + posX + direction.field_72450_a, pos.field_72448_b + posY + direction.field_72448_b, pos.field_72449_c + posZ + direction.field_72449_c);
        }
        return new Vec3d(x + posX, vortexLength + posY, z + posZ);
    }
}

