/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.analytics.AnalyticEvents;
import com.crowsofwar.avatar.util.analytics.AvatarAnalytics;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.avatar.util.data.Bender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="avatarmod")
public class AvatarPlayerDeath {
    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent e) {
        EntityLivingBase died = e.getEntityLiving();
        if (died instanceof EntityPlayer) {
            Bender bender = Bender.get(died);
            bender.onDeath();
            AvatarPlayerDeath.sendDeathAnalytic(e);
        }
    }

    private static void sendDeathAnalytic(LivingDeathEvent e) {
        if (!e.getEntity().field_70170_p.field_72995_K) {
            DamageSource source = e.getSource();
            Entity causeEntity = source.func_76346_g();
            if (causeEntity instanceof EntityPlayer && AvatarDamageSource.isAvatarDamageSource(source)) {
                String dsName = source.func_76355_l().substring("avatar_".length());
                AvatarAnalytics.INSTANCE.pushEvent(AnalyticEvents.onPvpKillWithAbility(dsName));
            }
            if (causeEntity instanceof EntityBender) {
                String mobName = EntityList.func_75621_b((Entity)causeEntity);
                AvatarAnalytics.INSTANCE.pushEvent(AnalyticEvents.onPlayerDeathWithMob(mobName));
            }
        }
    }
}

