/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.event.AbilityUnlockEvent;
import com.crowsofwar.avatar.util.event.AbilityUseEvent;
import com.crowsofwar.avatar.util.event.ElementUnlockEvent;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="avatarmod")
public class AvatarPlayerTick {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        Bender bender;
        if (Bender.isBenderSupported((EntityLivingBase)e.player) && (bender = Bender.get((EntityLivingBase)e.player)) != null) {
            BendingData data = bender.getData();
            EntityPlayer player = e.player;
            if (player.field_70173_aa % 20 == 0) {
                data.saveAll();
            }
            if (e.phase == TickEvent.Phase.START) {
                bender.onUpdate();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (Bender.isBenderSupported((EntityLivingBase)event.player)) {
            Ability.syncProperties(event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && Bender.isBenderSupported(event.getEntityLiving())) {
            Ability.syncProperties((EntityPlayer)event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void worldJoinEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityLivingBase && Bender.isBenderSupported((EntityLivingBase)event.getEntity())) {
            EntityLivingBase bender;
            List initialisedAbilities = Abilities.all().stream().filter(ability -> !ability.arePropertiesInitialised()).collect(Collectors.toList());
            if (!initialisedAbilities.isEmpty()) {
                Ability.syncEntityProperties();
            }
            if (event.getEntity() instanceof EntityPlayer) {
                Ability.syncProperties((EntityPlayer)event.getEntity());
            }
            if (ConfigSkills.SKILLS_CONFIG.startWithRandomBending && !event.getWorld().field_72995_K && Bender.isBenderSupported(bender = (EntityLivingBase)event.getEntity())) {
                int elementID;
                List elements;
                BendingStyle style;
                BendingData data = BendingData.getFromEntity(bender);
                Bender.adjustConfigModifier(bender);
                if (data != null && !data.hasElements() && !MinecraftForge.EVENT_BUS.post((Event)new ElementUnlockEvent(bender, style = BendingStyles.get(((BendingStyle)(elements = BendingStyles.all().stream().filter(bendingStyle -> bendingStyle.isParentBending() && bendingStyle.canEntityUse()).collect(Collectors.toList())).get((elementID = AvatarUtils.getRandomNumberInRange(1, elements.size())) - 1)).getName())))) {
                    data.addBending(style == null ? new Airbending() : style);
                    assert (style != null);
                    Ability ability2 = Objects.requireNonNull(style.getAllAbilities().get(0));
                    if (!MinecraftForge.EVENT_BUS.post((Event)new AbilityUnlockEvent(bender, ability2))) {
                        data.getAbilityData(ability2).unlockAbility();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBendingUseEvent(AbilityUseEvent event) {
        BendingData data;
        if (event.getEntityLiving() != null && (data = BendingData.getFromEntity(event.getEntityLiving())) != null && !data.hasBendingId(event.getAbility().getBendingId())) {
            event.setCanceled(true);
        }
    }
}

