/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="avatarmod")
public class AvatarSupporterEffects {
    public static List<String> supporters = new ArrayList<String>();

    @SubscribeEvent
    public static void onUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity;
        BendingData data;
        if (event.getEntityLiving() != null && (data = BendingData.getFromEntity(entity = event.getEntityLiving())) != null && Bender.get(entity) != null) {
            BendingStyle style;
            Bender bender = Bender.get(entity);
            int totalLevel = 0;
            if (entity instanceof EntityPlayer && supporters.contains(((EntityPlayer)entity).getDisplayNameString()) && (style = data.getActiveBending()) != null) {
                List<Ability> abilities = style.getAllAbilities();
                abilities = abilities.stream().filter(ability -> Objects.requireNonNull(AbilityData.get(entity, ability.getName())).getLevel() > -1).collect(Collectors.toList());
                for (Ability ability2 : abilities) {
                    AbilityData aD = AbilityData.get(entity, ability2.getName());
                    if (aD == null || aD.getLevel() <= -1) continue;
                    totalLevel += aD.getLevel() + 1;
                }
                int maxLevel = abilities.size() * 4;
                int level = Math.min(3, (int)((float)totalLevel / (float)maxLevel * 4.0f));
                float f = 0.5f + 0.125f * ((float)level + 1.0f);
            }
        }
    }

    static {
        supporters.add("MirroredPanda");
        supporters.add("VroFredo");
        supporters.add("Josephinitis");
        supporters.add("_Frozti_");
        supporters.add("starwarsfreak219");
        supporters.add("MultiPS3Gamer");
        supporters.add("WaferNafer");
        supporters.add("MadMiningMaster");
        supporters.add("Gyroplex_14");
    }
}

