/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.client.particles.newparticles.ParticleAvatar;
import com.crowsofwar.avatar.client.particles.newparticles.renderlayers.ParticleBatchRenderer;
import com.crowsofwar.avatar.client.particles.newparticles.renderlayers.RenderLayer;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.gorecore.util.Vector;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="avatarmod")
public class AvatarUtils {
    private static final DataParameter<Boolean> POWERED;
    private static Queue<ParticleAvatar> aliveParticlesCache;
    private static Map<Entity, Queue<ParticleAvatar>> particlesByOwnerEntity;

    public static <T extends Entity> Comparator<T> getSortByDistanceComparator(Function<T, Float> distanceSupplier) {
        return (e1, e2) -> {
            float d2;
            float d1 = ((Float)distanceSupplier.apply(e1)).floatValue();
            if (d1 < (d2 = ((Float)distanceSupplier.apply(e2)).floatValue())) {
                return -1;
            }
            return d1 > d2 ? 1 : 0;
        };
    }

    public static ItemStack copyWithMeta(ItemStack toCopy, int newMetadata) {
        ItemStack copy = new ItemStack(toCopy.func_77973_b(), toCopy.func_190916_E(), newMetadata);
        NBTTagCompound compound = toCopy.func_77978_p();
        if (compound != null) {
            copy.func_77982_d(compound.func_74737_b());
        }
        return copy;
    }

    public static List<Queue<ParticleAvatar>> getEnemyParticles(ParticleAvatar p) {
        ArrayList<Queue<ParticleAvatar>> enemyParticles = new ArrayList<Queue<ParticleAvatar>>();
        for (Map.Entry<Entity, Queue<ParticleAvatar>> e : particlesByOwnerEntity.entrySet()) {
            if (e.getKey() == p.getEntity()) continue;
            enemyParticles.add(e.getValue());
        }
        return enemyParticles;
    }

    public static Queue<ParticleAvatar> getAliveParticles() {
        if (aliveParticlesCache != null) {
            return aliveParticlesCache;
        }
        ArrayDeque[][] vanillaParticles = (ArrayDeque[][])ReflectionHelper.getPrivateValue(ParticleManager.class, (Object)Minecraft.func_71410_x().field_71452_i, (String)"fxLayers", (String)"field_78876_b");
        Set<RenderLayer> customParticles = ParticleBatchRenderer.layers;
        LinkedList<ParticleAvatar> all_particles = new LinkedList<ParticleAvatar>();
        ArrayDeque[][] arrayDequeArray = vanillaParticles;
        int n = arrayDequeArray.length;
        for (int i = 0; i < n; ++i) {
            ArrayDeque[] layer;
            for (ArrayDeque depthLayer : layer = arrayDequeArray[i]) {
                for (Particle p : depthLayer) {
                    if (!(p instanceof ParticleAvatar)) continue;
                    all_particles.add((ParticleAvatar)p);
                }
            }
        }
        for (RenderLayer layer : customParticles) {
            all_particles.addAll(layer.getParticles());
        }
        aliveParticlesCache = all_particles;
        particlesByOwnerEntity = new HashMap<Entity, Queue<ParticleAvatar>>();
        for (ParticleAvatar p : aliveParticlesCache) {
            if (!particlesByOwnerEntity.containsKey(p.getEntity())) {
                particlesByOwnerEntity.put(p.getEntity(), new LinkedList());
            }
            particlesByOwnerEntity.get(p.getEntity()).add(p);
        }
        return aliveParticlesCache;
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            aliveParticlesCache = null;
        }
    }

    public static ParticleAvatar getParticleFromUUID(UUID id) {
        if (!AvatarUtils.getAliveParticles().isEmpty() && AvatarUtils.getAliveParticles().peek() != null) {
            for (Particle particle : AvatarUtils.getAliveParticles()) {
                if (!(particle instanceof ParticleAvatar) || !((ParticleAvatar)particle).getUUID().equals(id)) continue;
                return (ParticleAvatar)particle;
            }
        }
        return null;
    }

    public static Vec3d bezierCurve(double t, Vec3d ... controls) {
        if (controls == null) {
            throw new IllegalArgumentException("Control point array cannot be null");
        }
        if (controls.length == 0) {
            throw new IllegalArgumentException("Control point array cannot be empty");
        }
        if (Arrays.asList(controls).contains(null)) {
            throw new IllegalArgumentException("A control point cannot be null");
        }
        if (t < 0.0 || t > 1.0) {
            throw new IllegalArgumentException("Parameter t must be within the range [0, 1]");
        }
        int order = controls.length;
        Vec3d point = Vec3d.field_186680_a;
        for (int i = 0; i < order; ++i) {
            double coefficient = (double)AvatarUtils.factorial(order) / (double)(AvatarUtils.factorial(i) * AvatarUtils.factorial(order - i));
            double basis = coefficient * Math.pow(t, i) * Math.pow(1.0 - t, order - i);
            point.func_178787_e(controls[i].func_186678_a(basis));
        }
        return point;
    }

    public static int factorial(int n) {
        int product = 1;
        for (int i = 1; i < n; ++i) {
            product *= i;
        }
        return product;
    }

    public static void chargeCreeper(EntityCreeper creeper) {
        creeper.func_184212_Q().func_187227_b(POWERED, (Object)true);
    }

    public static void igniteCreeper(EntityCreeper creeper) {
        creeper.func_146079_cb();
    }

    public static boolean pushButton(World world, boolean pushStone, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (pushStone) {
            if (state.func_177230_c() instanceof BlockButton) {
                BlockButton button = (BlockButton)state.func_177230_c();
                return button.func_180639_a(world, pos, state, null, null, null, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
            }
        } else if (state.func_177230_c() == Blocks.field_150471_bO) {
            BlockButton button = (BlockButton)state.func_177230_c();
            return button.func_180639_a(world, pos, state, null, null, null, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        }
        return false;
    }

    public static boolean pushLever(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150442_at) {
            BlockLever lever = (BlockLever)state.func_177230_c();
            return lever.func_180639_a(world, pos, state, null, null, null, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        }
        return false;
    }

    public static boolean pushTrapDoor(World world, boolean pushIron, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150415_aT) {
            BlockTrapDoor trap = (BlockTrapDoor)state.func_177230_c();
            return trap.func_180639_a(world, pos, state, null, null, null, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        }
        if (pushIron && (state.func_177230_c() == Blocks.field_150415_aT || state.func_177230_c() == Blocks.field_180400_cw)) {
            BlockTrapDoor trap = (BlockTrapDoor)state.func_177230_c();
            state = state.func_177231_a((IProperty)BlockTrapDoor.field_176283_b);
            world.func_180501_a(pos, state, 2);
            world.func_175704_b(pos, pos.func_177982_a(0, 1, 0));
            world.func_175684_a(pos, (Block)trap, trap.func_149738_a(world));
            return true;
        }
        return false;
    }

    public static boolean pushDoor(Entity entity, boolean pushIron, BlockPos pos) {
        IBlockState state = entity.field_70170_p.func_180495_p(pos);
        EntityPlayer player = null;
        if (entity instanceof AvatarEntity && ((AvatarEntity)entity).getOwner() != null && ((AvatarEntity)entity).getOwner() instanceof EntityPlayer) {
            player = (EntityPlayer)((AvatarEntity)entity).getOwner();
        }
        if (state.func_177230_c() instanceof BlockDoor && state.func_177230_c() != Blocks.field_150454_av) {
            BlockDoor door = (BlockDoor)state.func_177230_c();
            return door.func_180639_a(entity.field_70170_p, pos, state, player, null, null, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        }
        if (pushIron && state.func_177230_c() instanceof BlockDoor) {
            BlockDoor door = (BlockDoor)state.func_177230_c();
            BlockPos blockpos = state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
            IBlockState iblockstate = pos.equals((Object)blockpos) ? state : entity.field_70170_p.func_180495_p(blockpos);
            state = iblockstate.func_177231_a((IProperty)BlockDoor.field_176519_b);
            int open = door == Blocks.field_150454_av ? 1005 : 1006;
            int closed = door == Blocks.field_150454_av ? 1011 : 1012;
            entity.field_70170_p.func_180501_a(blockpos, state, 10);
            entity.field_70170_p.func_175704_b(blockpos, pos);
            entity.field_70170_p.func_180498_a(player, (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b) != false ? open : closed, pos, 0);
            return true;
        }
        return false;
    }

    public static boolean pushGate(Entity entity, BlockPos pos) {
        IBlockState state = entity.field_70170_p.func_180495_p(pos);
        EntityPlayer player = null;
        if (state.func_177230_c() instanceof BlockFenceGate) {
            if (entity instanceof AvatarEntity && ((AvatarEntity)entity).getOwner() != null && ((AvatarEntity)entity).getOwner() instanceof EntityPlayer) {
                player = (EntityPlayer)((AvatarEntity)entity).getOwner();
            }
            if (((Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a)).booleanValue()) {
                state = state.func_177226_a((IProperty)BlockFenceGate.field_176466_a, (Comparable)Boolean.valueOf(false));
                entity.field_70170_p.func_180501_a(pos, state, 10);
            } else {
                state = state.func_177226_a((IProperty)BlockFenceGate.field_176466_a, (Comparable)Boolean.valueOf(true));
                entity.field_70170_p.func_180501_a(pos, state, 10);
            }
            entity.field_70170_p.func_180498_a(player, (Boolean)state.func_177229_b((IProperty)BlockFenceGate.field_176466_a) != false ? 1008 : 1014, pos, 0);
            return true;
        }
        return false;
    }

    public static void spawnDirectionalHelix(World world, EntityLivingBase entity, Vector direction, int maxAngle, double vortexLength, double radius, EnumParticleTypes particle, Vector position, double particleSpeed) {
        for (int angle = 0; angle < maxAngle; ++angle) {
            double x = radius * Math.cos(angle);
            double y = (double)angle / ((double)maxAngle / vortexLength);
            double z = radius * Math.sin(angle);
            Vector pos = new Vector(x, y, z);
            if (entity == null) continue;
            pos = Vector.rotateAroundAxisX(pos, entity.field_70125_A + 90.0f);
            pos = Vector.rotateAroundAxisY(pos, entity.field_70177_z);
            world.func_175688_a(particle, pos.x() + position.x() + direction.x(), pos.y() + position.y() + direction.y(), pos.z() + position.z() + direction.z(), particleSpeed, particleSpeed, particleSpeed, new int[0]);
        }
    }

    public static void afterVelocityAdded(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport(entity));
            ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(entity));
        }
    }

    public static void setVelocity(Entity entity, Vec3d vel) {
        entity.field_70159_w *= 0.0;
        entity.field_70181_x *= 0.0;
        entity.field_70179_y *= 0.0;
        entity.field_70159_w = vel.field_72450_a;
        entity.field_70181_x = vel.field_72448_b;
        entity.field_70179_y = vel.field_72449_c;
        entity.field_70160_al = true;
        AvatarUtils.afterVelocityAdded(entity);
    }

    public static Vec3d getMiddleVec3d(AxisAlignedBB box) {
        double x = box.field_72336_d - box.field_72340_a;
        double y = box.field_72337_e - box.field_72338_b;
        double z = box.field_72334_f - box.field_72339_c;
        return new Vec3d(box.field_72340_a + x / 2.0, box.field_72338_b + y / 2.0, box.field_72339_c + z / 2.0);
    }

    public static float normalizeAngle(float angle) {
        while (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle %= 360.0f;
    }

    public static <T> void readList(Collection<T> list, Function<NBTTagCompound, T> itemProvider, NBTTagCompound nbt, String listName) {
        list.clear();
        NBTTagList listTag = nbt.func_150295_c(listName, 10);
        for (int i = 0; i < listTag.func_74745_c(); ++i) {
            NBTTagCompound item = listTag.func_150305_b(i);
            T read = itemProvider.apply(item);
            if (read != null) {
                list.add(read);
                continue;
            }
            AvatarLog.warn(AvatarLog.WarningType.INVALID_SAVE, "Invalid list " + listName + ", contains unknown value: " + item);
        }
    }

    public static <T> void writeList(Collection<T> list, BiConsumer<NBTTagCompound, T> writer, NBTTagCompound nbt, String listName) {
        NBTTagList listTag = new NBTTagList();
        for (T item : list) {
            NBTTagCompound nbtItem = new NBTTagCompound();
            writer.accept(nbtItem, (NBTTagCompound)item);
            listTag.func_74742_a((NBTBase)nbtItem);
        }
        nbt.func_74782_a(listName, (NBTBase)listTag);
    }

    public static <K, V> void readMap(Map<K, V> map, Function<NBTTagCompound, K> keyProvider, Function<NBTTagCompound, V> valueProvider, NBTTagCompound nbt, String mapName) {
        map.clear();
        NBTTagList listTag = nbt.func_150295_c(mapName, 10);
        for (int i = 0; i < listTag.func_74745_c(); ++i) {
            NBTTagCompound item = listTag.func_150305_b(i);
            K key = keyProvider.apply(item.func_74775_l("Key"));
            V value = valueProvider.apply(item.func_74775_l("Value"));
            if (key == null) {
                AvatarLog.error("MapError: Issue reading map " + mapName + "'s key for item " + i);
                AvatarLog.error("MapError: Item compound- " + item);
                AvatarLog.error("MapError: Key compound- " + item.func_74775_l("Key"));
                throw new DiskException("readMap- Cannot have null key for map (see log for details)");
            }
            if (value == null) {
                AvatarLog.error("MapError: Issue reading map " + mapName + "'s value for item" + i);
                AvatarLog.error("MapError: Item compound- " + item);
                AvatarLog.error("MapError: Value compound- " + item.func_74775_l("Value"));
                throw new DiskException("readMap- Cannot have null value for map (see log for details)");
            }
            map.put(key, value);
        }
    }

    public static <K, V> void writeMap(Map<K, V> map, BiConsumer<NBTTagCompound, K> keyWriter, BiConsumer<NBTTagCompound, V> valueWriter, NBTTagCompound nbt, String mapName) {
        NBTTagList listTag = new NBTTagList();
        Set<Map.Entry<K, V>> entries = map.entrySet();
        for (Map.Entry<K, V> entry : entries) {
            if (entry.getKey() == null) {
                throw new DiskException("writeMap- does not permit null keys in map " + map);
            }
            if (entry.getValue() == null) {
                throw new DiskException("writeMap- does not permit null values in map " + map);
            }
            NBTTagCompound item = new NBTTagCompound();
            NBTTagCompound keyNbt = new NBTTagCompound();
            NBTTagCompound valNbt = new NBTTagCompound();
            keyWriter.accept(keyNbt, entry.getKey());
            valueWriter.accept(valNbt, entry.getValue());
            item.func_74782_a("Key", (NBTBase)keyNbt);
            item.func_74782_a("Value", (NBTBase)valNbt);
            listTag.func_74742_a((NBTBase)item);
        }
        nbt.func_74782_a(mapName, (NBTBase)listTag);
    }

    public static void readInventory(IInventory inventory, NBTTagCompound nbt, String listName) {
        NBTTagList list = nbt.func_150295_c(listName, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound slotNbt = list.func_150305_b(i);
            int slot = slotNbt.func_74762_e("Slot");
            if (slotNbt.func_74767_n("Empty")) {
                inventory.func_70299_a(slot, ItemStack.field_190927_a);
                continue;
            }
            inventory.func_70299_a(slot, new ItemStack(slotNbt));
        }
    }

    public static void writeInventory(IInventory inventory, NBTTagCompound nbt, String listName) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            NBTTagCompound slotNbt = new NBTTagCompound();
            slotNbt.func_74757_a("Empty", stack.func_190926_b());
            slotNbt.func_74768_a("Slot", i);
            if (!stack.func_190926_b()) {
                stack.func_77955_b(slotNbt);
            }
            list.func_74742_a((NBTBase)slotNbt);
        }
        nbt.func_74782_a(listName, (NBTBase)list);
    }

    @Nullable
    public static RayTraceResult standardEntityRayTrace(World world, Entity entity, Entity abilityEntity, Vec3d startPos, Vec3d endPos, float borderSize, boolean transparentBlocks, HashSet<Entity> excluded) {
        excluded.add(entity);
        if (abilityEntity != null) {
            excluded.add(abilityEntity);
        }
        return AvatarUtils.tracePath(world, (float)startPos.field_72450_a, (float)startPos.field_72448_b, (float)startPos.field_72449_c, (float)endPos.field_72450_a, (float)endPos.field_72448_b, (float)endPos.field_72449_c, borderSize, excluded, false, transparentBlocks);
    }

    public static void handlePiercingBeamCollision(World world, EntityLivingBase caster, Vec3d startPos, Vec3d endPos, float borderSize, @Nullable AvatarEntity spellEntity, @Nullable Ability ability, @Nullable BendingStyle element, float damage, Vec3d knockBack, int fireTime, float radius) {
        HashSet<Entity> excluded = new HashSet<Entity>();
        RayTraceResult result = AvatarUtils.standardEntityRayTrace(world, (Entity)caster, spellEntity, startPos, endPos, borderSize, false, excluded);
        if (result != null && result.field_72308_g instanceof EntityLivingBase) {
            String abilityName;
            BendingStyle style;
            EntityLivingBase hit = (EntityLivingBase)result.field_72308_g;
            if (spellEntity != null) {
                style = spellEntity.getElement();
                abilityName = spellEntity.getAbility().getName();
            } else {
                assert (ability != null);
                assert (element != null);
                style = element;
                abilityName = ability.getName();
            }
            String elementName = style.getName();
            String damageName = AvatarDamageSource.getNameFromBendingStyle(elementName);
            EntityDamageSourceIndirect damageSource = new EntityDamageSourceIndirect("avatar_" + damageName + "_" + abilityName, (Entity)hit, (Entity)caster);
            hit.func_70015_d(fireTime);
            hit.func_70097_a((DamageSource)damageSource, damage);
            hit.field_70159_w += knockBack.field_72450_a;
            hit.field_70181_x += knockBack.field_72448_b;
            hit.field_70179_y += knockBack.field_72449_c;
            AvatarUtils.afterVelocityAdded((Entity)hit);
            Vec3d pos = result.field_72307_f;
            AxisAlignedBB hitBox = new AxisAlignedBB(pos.field_72450_a + (double)radius, pos.field_72448_b + (double)radius, pos.field_72449_c + (double)radius, pos.field_72450_a - (double)radius, pos.field_72448_b - (double)radius, pos.field_72449_c - (double)radius);
            List nearby = world.func_72872_a(EntityLivingBase.class, hitBox);
            excluded.add((Entity)hit);
            nearby.remove(hit);
            if (!nearby.isEmpty()) {
                for (Entity e : nearby) {
                    if (e == caster || e == hit || excluded.contains(e) || e.func_96124_cp() == caster.func_96124_cp()) continue;
                    e.func_70015_d(fireTime);
                    e.func_70097_a((DamageSource)damageSource, damage);
                    e.field_70159_w += knockBack.field_72450_a;
                    e.field_70181_x += knockBack.field_72448_b;
                    e.field_70179_y += knockBack.field_72449_c;
                    AvatarUtils.afterVelocityAdded(e);
                    excluded.add(e);
                }
            } else {
                AvatarUtils.handlePiercingBeamCollision(world, caster, pos, endPos, borderSize, spellEntity, ability, element, damage, knockBack, fireTime, radius);
            }
        }
    }

    @Nullable
    public static RayTraceResult tracePath(World world, float x, float y, float z, float tx, float ty, float tz, float borderSize, HashSet<Entity> excluded, boolean collideablesOnly, boolean raytraceNonSolidBlocks) {
        Vec3d startVec = new Vec3d((double)x, (double)y, (double)z);
        Vec3d endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        float minX = Math.min(x, tx);
        float minY = Math.min(y, ty);
        float minZ = Math.min(z, tz);
        float maxX = Math.max(x, tx);
        float maxY = Math.max(y, ty);
        float maxZ = Math.max(z, tz);
        AxisAlignedBB bb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        List allEntities = world.func_72839_b(null, bb);
        RayTraceResult blockHit = world.func_72933_a(startVec, endVec);
        if (blockHit != null && !world.func_180495_p(blockHit.func_178782_a()).func_185913_b() && !raytraceNonSolidBlocks) {
            blockHit = null;
        }
        startVec = new Vec3d((double)x, (double)y, (double)z);
        endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        float maxDistance = (float)endVec.func_72438_d(startVec);
        if (blockHit != null) {
            maxDistance = (float)blockHit.field_72307_f.func_72438_d(startVec);
        }
        Entity closestHitEntity = null;
        float closestHit = maxDistance;
        for (Entity ent : allEntities) {
            float currentHit;
            RayTraceResult intercept;
            if (!ent.func_70067_L() && collideablesOnly || excluded != null && excluded.contains(ent)) continue;
            float entBorder = ent.func_70111_Y();
            AxisAlignedBB entityBb = ent.func_174813_aQ();
            entityBb = entityBb.func_72314_b((double)entBorder, (double)entBorder, (double)entBorder);
            if (borderSize != 0.0f) {
                entityBb = entityBb.func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            }
            if ((intercept = entityBb.func_72327_a(startVec, endVec)) == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            closestHitEntity = ent;
        }
        if (closestHitEntity != null) {
            blockHit = new RayTraceResult(closestHitEntity);
        }
        return blockHit;
    }

    public static int getRandomNumberInRange(int min, int max) {
        Random r = new Random();
        if (max < 0 || min < 0) {
            return 0;
        }
        return r.nextInt(max - min + 1) + min;
    }

    public static double getMagnitude(Vec3d vel) {
        return Math.sqrt(AvatarUtils.getSqrMagnitude(vel));
    }

    public static double getSqrMagnitude(Vec3d vel) {
        return vel.field_72450_a * vel.field_72450_a + vel.field_72448_b * vel.field_72448_b + vel.field_72449_c * vel.field_72449_c;
    }

    static {
        aliveParticlesCache = null;
        particlesByOwnerEntity = null;
        POWERED = (DataParameter)ReflectionHelper.getPrivateValue(EntityCreeper.class, null, (String)"POWERED", (String)"field_184714_b");
    }

    public static class DiskException
    extends RuntimeException {
        private DiskException(String message) {
            super(message);
        }
    }
}

