/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import com.crowsofwar.avatar.config.ConfigMobs;
import com.crowsofwar.avatar.entity.mob.EntityAirbender;
import com.crowsofwar.avatar.entity.mob.EntityFirebender;
import com.crowsofwar.avatar.entity.mob.EntityHumanBender;
import com.crowsofwar.avatar.util.AvatarUtils;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="avatarmod")
public class HumanBenderSpawner {
    public static void register() {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new HumanBenderSpawner());
    }

    @SubscribeEvent
    public void modifyVillageSpawner(InitMapGenEvent e) {
        if (e.getType() == InitMapGenEvent.EventType.VILLAGE) {
            e.setNewGen((MapGenBase)new MapGenVillageWithHumanbenders());
        }
    }

    private static class MapGenVillageWithHumanbenders
    extends MapGenVillage {
        public MapGenVillageWithHumanbenders() {
        }

        public MapGenVillageWithHumanbenders(Map<String, String> map) {
            super(map);
        }

        public synchronized boolean func_175794_a(World worldIn, Random randomIn, ChunkPos chunkCoord) {
            List villagers;
            boolean result = super.func_175794_a(worldIn, randomIn, chunkCoord);
            if (result && !(villagers = worldIn.func_175644_a(EntityVillager.class, villager -> {
                assert (villager != null);
                return new ChunkPos(villager.func_180425_c()).equals((Object)chunkCoord);
            })).isEmpty()) {
                AxisAlignedBB aabb = new AxisAlignedBB(((EntityVillager)villagers.get((int)0)).field_70165_t + 100.0, ((EntityVillager)villagers.get((int)0)).field_70163_u + 100.0, ((EntityVillager)villagers.get((int)0)).field_70161_v + 100.0, ((EntityVillager)villagers.get((int)0)).field_70165_t - 100.0, ((EntityVillager)villagers.get((int)0)).field_70163_u - 100.0, ((EntityVillager)villagers.get((int)0)).field_70161_v - 100.0);
                List nearbyBenders = worldIn.func_72872_a(EntityHumanBender.class, aabb);
                Random rand = new Random();
                boolean firebender = nearbyBenders.isEmpty() ? rand.nextBoolean() : !(nearbyBenders.get(0) instanceof EntityFirebender);
                for (Entity e : villagers) {
                    int i = AvatarUtils.getRandomNumberInRange(1, 2);
                    if (i != 2) continue;
                    EntityHumanBender bender = firebender ? new EntityFirebender(worldIn) : new EntityAirbender(worldIn);
                    bender.func_82149_j(e);
                    bender.setLevel(AvatarUtils.getRandomNumberInRange(1, ConfigMobs.MOBS_CONFIG.benderSettings.maxLevel));
                    bender.func_175449_a(e.func_180425_c(), 20);
                    bender.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)bender)), null);
                    if (worldIn.field_72995_K) continue;
                    worldIn.func_72838_d((Entity)bender);
                }
            }
            return true;
        }
    }
}

