/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import com.crowsofwar.avatar.entity.EntityIcePrison;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import java.util.Objects;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="avatarmod")
public class IceActionCanceller {
    private static boolean isTrapped(EntityLivingBase entity) {
        if (EntityIcePrison.isImprisoned(entity)) {
            return true;
        }
        if (Bender.isBenderSupported(entity) && BendingData.getFromEntity(entity) != null) {
            return Objects.requireNonNull(BendingData.getFromEntity(entity)).hasStatusControl(StatusControlController.SHIELD_SHATTER);
        }
        return false;
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent e) {
        EntityLivingBase entity = e.getEntityLiving();
        if (IceActionCanceller.isTrapped(entity) && entity.field_70122_E) {
            entity.field_70181_x *= 0.0;
        } else if (IceActionCanceller.isTrapped(entity)) {
            entity.field_70159_w *= 0.0;
            entity.field_70179_y *= 0.0;
        }
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        if (IceActionCanceller.isTrapped((EntityLivingBase)player) && e.isCancelable()) {
            e.setCanceled(true);
        }
    }
}

