/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.ICustomHitbox;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.gorecore.util.Vector;
import com.crowsofwar.gorecore.util.VectorI;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Raytrace {
    private Raytrace() {
    }

    public static Result getTargetBlock(EntityLivingBase entity, double range) {
        return Raytrace.getTargetBlock(entity, range, false);
    }

    public static Result getTargetBlock(EntityLivingBase entity, Info info) {
        if (!info.needsRaytrace()) {
            return new Result();
        }
        if (info.predicateRaytrace()) {
            return Raytrace.predicateRaytrace(entity.field_70170_p, Vector.getEyePos((Entity)entity), Vector.getLookRectangular((Entity)entity), info.range, info.predicate);
        }
        return Raytrace.getTargetBlock(entity, info.getRange(), info.raycastLiquids());
    }

    public static Result getTargetBlock(EntityLivingBase entity, double range, boolean raycastLiquids) {
        if (range == -1.0) {
            range = Raytrace.getReachDistance(entity);
        }
        Vector eyePos = Vector.getEyePos((Entity)entity);
        Vector look = new Vector(entity.func_70040_Z());
        Vector end = eyePos.plus(look.times(range));
        RayTraceResult res = entity.field_70170_p.func_147447_a(eyePos.toMinecraft(), end.toMinecraft(), !raycastLiquids, raycastLiquids, true);
        if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK) {
            return new Result(new VectorI(res.func_178782_a()), res.field_178784_b, new Vector(res.field_72307_f));
        }
        return new Result();
    }

    public static double getReachDistance(EntityLivingBase entity) {
        if (entity instanceof EntityPlayerMP) {
            return 5.0;
        }
        if (entity instanceof EntityPlayer) {
            return AvatarMod.proxy.getPlayerReach();
        }
        return 4.0;
    }

    public static Result raytrace(World world, Vector start, Vector direction, double range, boolean raycastLiquids) {
        RayTraceResult res = world.func_147447_a(start.toMinecraft(), start.plus(direction.times(range)).toMinecraft(), !raycastLiquids, raycastLiquids, true);
        if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK) {
            return new Result(new VectorI(res.func_178782_a()), res.field_178784_b, new Vector(res.field_72307_f));
        }
        return new Result();
    }

    public static Result raytrace(World world, Vec3d start, Vec3d direction, double range, boolean raycastLiquids) {
        RayTraceResult res = world.func_147447_a(start, start.func_178787_e(direction.func_186678_a(range)), !raycastLiquids, raycastLiquids, true);
        if (res != null && res.field_72313_a == RayTraceResult.Type.BLOCK) {
            return new Result(new VectorI(res.func_178782_a()), res.field_178784_b, new Vector(res.field_72307_f));
        }
        return new Result();
    }

    public static Result predicateRaytrace(World world, Vector start, Vector direction, double range, BiPredicate<BlockPos, IBlockState> verify) {
        if (range == -1.0) {
            range = 3.0;
        }
        Vector currentPosition = start;
        Vector increment = direction.times(0.2);
        while (currentPosition.sqrDist(start) <= range * range) {
            IBlockState blockState;
            BlockPos pos = currentPosition.toBlockPos();
            if (verify.test(pos, blockState = world.func_180495_p(pos))) {
                return new Result(new VectorI(pos), EnumFacing.DOWN, currentPosition);
            }
            currentPosition = currentPosition.plus(increment);
        }
        return new Result();
    }

    public static List<Entity> entityRaytrace(World world, Vector start, Vector direction, double maxDistance) {
        return Raytrace.entityRaytrace(world, start, direction, maxDistance, (Entity entity) -> true);
    }

    public static List<Entity> entityRaytrace(World world, Vector start, Vector direction, double maxRange, Predicate<Entity> filter) {
        double range = maxRange;
        Result raytrace = Raytrace.raytrace(world, start, direction, maxRange, true);
        if (raytrace.hitSomething()) {
            Vector stopAt = raytrace.posPrecise;
            range = start.minus(stopAt).magnitude();
        }
        ArrayList<Entity> hit = new ArrayList<Entity>();
        Vector end = start.plus(direction.times(range));
        AxisAlignedBB aabb = new AxisAlignedBB(start.x(), start.y(), start.z(), end.x(), end.y(), end.z());
        List entities = world.func_72872_a(Entity.class, aabb);
        for (Entity entity : entities) {
            AxisAlignedBB collisionBox;
            RayTraceResult result;
            if (!filter.test(entity) || (result = (collisionBox = entity.func_174813_aQ()).func_72327_a(start.toMinecraft(), end.toMinecraft())) == null) continue;
            hit.add(entity);
        }
        return hit;
    }

    public static List<Entity> entityRaytrace(World world, Vec3d start, Vec3d direction, double maxDistance) {
        return Raytrace.entityRaytrace(world, start, direction, maxDistance, (Entity entity) -> true);
    }

    public static List<Entity> entityRaytrace(World world, Vec3d start, Vec3d direction, double maxRange, Predicate<Entity> filter) {
        double range = maxRange;
        Result raytrace = Raytrace.raytrace(world, start, direction, maxRange, true);
        if (raytrace.hitSomething()) {
            Vec3d stopAt = raytrace.posPrecise.toMinecraft();
            range = AvatarUtils.getMagnitude(start.func_178788_d(stopAt));
        }
        ArrayList<Entity> hit = new ArrayList<Entity>();
        Vec3d end = start.func_178787_e(direction.func_186678_a(range));
        AxisAlignedBB aabb = new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c);
        List entities = world.func_72872_a(Entity.class, aabb);
        for (Entity entity : entities) {
            AxisAlignedBB collisionBox;
            RayTraceResult result;
            if (!filter.test(entity) || (result = (collisionBox = entity.func_174813_aQ()).func_72327_a(start, end)) == null) continue;
            hit.add(entity);
        }
        return hit;
    }

    public static List<Entity> entityRaytrace(World world, Vector start, Vector direction, float borderSize, double maxDistance) {
        return Raytrace.entityRaytrace(world, start, direction, maxDistance, borderSize, (? super Entity entity) -> true);
    }

    public static List<Entity> entityRaytrace(World world, Vector start, Vector direction, double maxRange, float borderSize, Predicate<? super Entity> filter) {
        double range = maxRange;
        Result raytrace = Raytrace.raytrace(world, start, direction, maxRange, true);
        if (raytrace.hitSomething()) {
            Vector stopAt = raytrace.posPrecise;
            range = start.minus(stopAt).magnitude();
        }
        ArrayList<Entity> hit = new ArrayList<Entity>();
        Vector end = start.plus(direction.times(range));
        AxisAlignedBB aabb = new AxisAlignedBB(start.x(), start.y(), start.z(), end.x(), end.y(), end.z());
        List entities = world.func_72872_a(Entity.class, aabb);
        for (Entity entity : entities) {
            if (!filter.test((Entity)entity)) continue;
            float entBorder = entity.func_70111_Y();
            AxisAlignedBB collisionBox = entity.func_174813_aQ();
            collisionBox = collisionBox.func_186662_g((double)entBorder);
            RayTraceResult result = (collisionBox = collisionBox.func_186662_g((double)borderSize)).func_72327_a(start.toMinecraft(), end.toMinecraft());
            if (result == null) continue;
            hit.add(entity);
        }
        return hit;
    }

    public static List<Entity> entityRaytrace(World world, Vec3d start, Vec3d direction, float borderSize, double maxDistance) {
        return Raytrace.entityRaytrace(world, start, direction, maxDistance, borderSize, (? super Entity entity) -> true);
    }

    public static List<Entity> entityRaytrace(World world, Vec3d start, Vec3d direction, double maxRange, float borderSize, Predicate<? super Entity> filter) {
        double range = maxRange;
        Result raytrace = Raytrace.raytrace(world, start, direction, maxRange, true);
        if (raytrace.hitSomething()) {
            Vec3d stopAt = raytrace.posPrecise.toMinecraft();
            range = AvatarUtils.getMagnitude(start.func_178788_d(stopAt));
        }
        ArrayList<Entity> hit = new ArrayList<Entity>();
        Vec3d end = start.func_178787_e(direction.func_186678_a(range));
        AxisAlignedBB aabb = new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c);
        List entities = world.func_72872_a(Entity.class, aabb);
        for (Entity entity : entities) {
            if (!filter.test((Entity)entity)) continue;
            float entBorder = entity.func_70111_Y();
            AxisAlignedBB collisionBox = entity.func_174813_aQ();
            collisionBox = collisionBox.func_186662_g((double)entBorder);
            RayTraceResult result = (collisionBox = collisionBox.func_186662_g((double)borderSize)).func_72327_a(start, end);
            if (result == null) continue;
            hit.add(entity);
        }
        return hit;
    }

    @Nullable
    public static RayTraceResult rayTrace(World world, Vec3d origin, Vec3d endpoint, float aimAssist, boolean hitLiquids, boolean ignoreUncollidables, boolean returnLastUncollidable, Class<? extends Entity> entityType, Predicate<? super Entity> filter) {
        float borderSize = 1.0f + aimAssist;
        AxisAlignedBB searchVolume = new AxisAlignedBB(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, endpoint.field_72450_a, endpoint.field_72448_b, endpoint.field_72449_c).func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
        List entities = world.func_72872_a(entityType, searchVolume);
        entities.removeIf(filter);
        RayTraceResult result = world.func_147447_a(origin, endpoint, hitLiquids, ignoreUncollidables, returnLastUncollidable);
        if (result != null) {
            endpoint = result.field_72307_f;
        }
        Entity closestHitEntity = null;
        Vec3d closestHitPosition = endpoint;
        Vec3d intercept = null;
        for (Entity entity : entities) {
            float closestHitDistance;
            float currentHitDistance;
            float fuzziness;
            float f = fuzziness = entity instanceof EntityLiving ? aimAssist : 0.0f;
            if (entity instanceof ICustomHitbox) {
                intercept = ((ICustomHitbox)entity).calculateIntercept(origin, endpoint, fuzziness);
            } else {
                AxisAlignedBB entityBounds = entity.func_174813_aQ();
                if (entityBounds != null) {
                    RayTraceResult hit;
                    float entityBorderSize = entity.func_70111_Y();
                    if (entityBorderSize != 0.0f) {
                        entityBounds = entityBounds.func_72314_b((double)entityBorderSize, (double)entityBorderSize, (double)entityBorderSize);
                    }
                    if (fuzziness != 0.0f) {
                        entityBounds = entityBounds.func_72314_b((double)fuzziness, (double)fuzziness, (double)fuzziness);
                    }
                    if ((hit = entityBounds.func_72327_a(origin, endpoint)) != null) {
                        intercept = hit.field_72307_f;
                    }
                }
            }
            if (intercept == null || !((currentHitDistance = (float)intercept.func_72438_d(origin)) < (closestHitDistance = (float)closestHitPosition.func_72438_d(origin)))) continue;
            closestHitEntity = entity;
            closestHitPosition = intercept;
        }
        if (closestHitEntity != null) {
            result = new RayTraceResult(closestHitEntity, closestHitPosition);
        }
        return result;
    }

    @Nullable
    public static RayTraceResult standardEntityRayTrace(World world, Entity entity, Entity spellEntity, Vec3d startPos, Vec3d endPos, float borderSize, boolean transparentBlocks, Predicate<? super Entity> filter) {
        filter = filter.and(entity1 -> entity1 == entity);
        if (spellEntity != null) {
            filter = filter.and(entity1 -> entity1 == spellEntity);
        }
        return Raytrace.rayTrace(world, startPos, endPos, borderSize, false, transparentBlocks, transparentBlocks, EntityLiving.class, filter);
    }

    public static void handlePiercingBeamCollision(World world, EntityLivingBase bender, Vec3d startPos, Vec3d endPos, float borderSize, Entity abilityEntity, DamageSource damageSource, float damage, Vec3d knockBack, boolean setFire, int fireTime, float radius) {
    }

    public static Predicate<Entity> ignoreEntityFilter(Entity entity) {
        return entity1 -> entity1 == entity;
    }

    public static Predicate<Entity> ignoreBenderFilter(Entity entity) {
        return entity1 -> entity1 == entity || entity1 instanceof AvatarEntity && ((AvatarEntity)((Object)entity1)).getOwner() == entity;
    }

    public static RayTraceResult rayTrace(EntityLivingBase entity, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = entity.func_174824_e(partialTicks);
        Vec3d vec3d1 = entity.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return entity.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public static class Info {
        private final double range;
        private final boolean needsRaytrace;
        private final boolean raycastLiquids;
        private BiPredicate<BlockPos, IBlockState> predicate;

        public Info() {
            this.range = -1.0;
            this.needsRaytrace = false;
            this.raycastLiquids = false;
            this.predicate = null;
        }

        public Info(double range, boolean raycastLiquids) {
            this.range = range;
            this.needsRaytrace = true;
            this.raycastLiquids = raycastLiquids;
            this.predicate = null;
        }

        public double getRange() {
            return this.range;
        }

        public boolean needsRaytrace() {
            return this.needsRaytrace;
        }

        public boolean raycastLiquids() {
            return this.raycastLiquids;
        }

        public boolean predicateRaytrace() {
            return this.predicate != null;
        }

        public BiPredicate<BlockPos, IBlockState> getPredicate() {
            return this.predicate;
        }

        public void setPredicate(BiPredicate<BlockPos, IBlockState> predicate) {
            this.predicate = predicate;
        }
    }

    public static class Result {
        private final boolean hit;
        private final VectorI pos;
        private final EnumFacing side;
        private final Vector posPrecise;

        public Result() {
            this(null, null, null);
        }

        public Result(VectorI pos, EnumFacing side, Vector posPrecise) {
            this.pos = pos;
            this.side = side;
            this.hit = pos != null;
            this.posPrecise = posPrecise;
        }

        public static Result fromBytes(ByteBuf buf) {
            boolean hit = buf.readBoolean();
            EnumFacing side = null;
            VectorI pos = null;
            Vector posPrecise = null;
            if (hit) {
                side = EnumFacing.values()[buf.readInt()];
                pos = VectorI.fromBytes(buf);
                posPrecise = Vector.fromBytes(buf);
            }
            return new Result(pos, side, posPrecise);
        }

        @Nullable
        public VectorI getPos() {
            return this.pos;
        }

        @Nullable
        public EnumFacing getSide() {
            return this.side;
        }

        public boolean hitSomething() {
            return this.hit;
        }

        @Nullable
        public Vector getPosPrecise() {
            return this.posPrecise;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.hit);
            if (this.hit) {
                buf.writeInt(this.side.ordinal());
                this.pos.toBytes(buf);
                this.posPrecise.toBytes(buf);
            }
        }
    }
}

