/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import com.crowsofwar.avatar.entity.mob.EntitySkyBison;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TransferConfirmHandler {
    private static final Map<EntityPlayer, TransferData> inProgressTransfers = new HashMap<EntityPlayer, TransferData>();

    public static void startTransfer(EntityPlayer from, EntityPlayer to, EntitySkyBison bison) {
        inProgressTransfers.put(from, new TransferData(from, to, bison));
        AvatarChatMessages.MSG_BISON_TRANSFER_OLD_START.send((ICommandSender)from, bison.func_70005_c_(), to.func_70005_c_());
        AvatarChatMessages.MSG_BISON_TRANSFER_NEW_START.send((ICommandSender)to, bison.func_70005_c_(), from.func_70005_c_());
    }

    public static void confirmTransfer(EntityPlayer oldOwner) {
        TransferData transfer = inProgressTransfers.get(oldOwner);
        if (transfer != null) {
            EntitySkyBison bison = transfer.bison;
            EntityPlayer newOwner = transfer.to;
            bison.setOwner(newOwner);
            AvatarChatMessages.MSG_BISON_TRANSFER_OLD.send((ICommandSender)oldOwner, bison.func_70005_c_(), newOwner.func_70005_c_());
            AvatarChatMessages.MSG_BISON_TRANSFER_NEW.send((ICommandSender)newOwner, bison.func_70005_c_(), oldOwner.func_70005_c_());
            inProgressTransfers.remove(oldOwner);
        } else {
            AvatarChatMessages.MSG_BISON_TRANSFER_NONE.send((ICommandSender)oldOwner, new Object[0]);
        }
    }

    @Mod.EventBusSubscriber(modid="avatarmod")
    public static class TickHandler {
        @SubscribeEvent
        public static void onTick(TickEvent.ServerTickEvent e) {
            if (e.phase == TickEvent.Phase.START) {
                Set entries = inProgressTransfers.entrySet();
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    TransferData data = (TransferData)entry.getValue();
                    data.ticksLeft--;
                    if (data.ticksLeft > 0 && !((TransferData)data).bison.field_70128_L && !((TransferData)data).from.field_70128_L && !((TransferData)data).to.field_70128_L) continue;
                    AvatarChatMessages.MSG_BISON_TRANSFER_OLD_IGNORE.send((ICommandSender)data.from, data.to.func_70005_c_());
                    AvatarChatMessages.MSG_BISON_TRANSFER_NEW_IGNORE.send((ICommandSender)data.to, data.from.func_70005_c_());
                    iterator.remove();
                }
            }
        }
    }

    private static class TransferData {
        private final EntityPlayer from;
        private final EntityPlayer to;
        private final EntitySkyBison bison;
        private int ticksLeft;

        public TransferData(EntityPlayer from, EntityPlayer to, EntitySkyBison bison) {
            this.from = from;
            this.to = to;
            this.bison = bison;
            this.ticksLeft = 100;
        }
    }
}

