/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util;

import net.minecraft.entity.player.EntityPlayer;

public class XPUtils {
    public static int takeXP(EntityPlayer player, int xp) {
        int total = XPUtils.getXPTotal(player);
        int taken = Math.min(xp, total);
        XPUtils.setPlayersExpTo(player, total -= taken);
        return taken;
    }

    public static void giveXP(EntityPlayer player, int xp) {
        XPUtils.setPlayersExpTo(player, XPUtils.getXPTotal(player) + xp);
    }

    public static void setPlayersExpTo(EntityPlayer player, int total) {
        player.field_71068_ca = Math.max(XPUtils.getLevelFromXPValue(total), 0);
        player.field_71106_cc = Math.max(XPUtils.getCurrentFromXPValue(total), 0.0f);
    }

    public static int getXPTotal(int xpLevel, float current) {
        return (int)((float)XPUtils.getXPValueFromLevel(xpLevel) + (float)XPUtils.getXPValueToNextLevel(xpLevel) * current);
    }

    public static int getXPTotal(EntityPlayer player) {
        return (int)((float)XPUtils.getXPValueFromLevel(player.field_71068_ca) + (float)XPUtils.getXPValueToNextLevel(player.field_71068_ca) * player.field_71106_cc);
    }

    public static int getLevelFromXPValue(int value) {
        int level = 0;
        level = value >= XPUtils.getXPValueFromLevel(30) ? (int)(0.07142857142857142 * (Math.sqrt(56.0 * (double)value - 32511.0) + 303.0)) : (value >= XPUtils.getXPValueFromLevel(15) ? (int)(0.16666666666666666 * (Math.sqrt(24.0 * (double)value - 5159.0) + 59.0)) : (int)((double)value / 17.0));
        return level;
    }

    public static float getCurrentFromXPValue(int value) {
        if (value == 0) {
            return 0.0f;
        }
        int level = XPUtils.getLevelFromXPValue(value);
        float needed = XPUtils.getXPValueFromLevel(level);
        float next = XPUtils.getXPValueToNextLevel(level);
        float difference = (float)value - needed;
        float current = difference / next;
        return current;
    }

    public static int getXPValueFromLevel(int xpLevel) {
        int val = 0;
        val = xpLevel >= 30 ? (int)(3.5 * Math.pow(xpLevel, 2.0) - 151.5 * (double)xpLevel + 2220.0) : (xpLevel >= 15 ? (int)(1.5 * Math.pow(xpLevel, 2.0) - 29.5 * (double)xpLevel + 360.0) : 17 * xpLevel);
        return val;
    }

    public static int getXPValueToNextLevel(int xpLevel) {
        int val = 0;
        val = xpLevel >= 30 ? 7 * xpLevel - 148 : (xpLevel >= 15 ? 3 * xpLevel - 28 : 17);
        return val;
    }
}

