/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.analytics;

import com.crowsofwar.avatar.util.analytics.AnalyticEvent;
import net.minecraft.util.DamageSource;

public class AnalyticEvents {
    public static AnalyticEvent getAbilityExecutionEvent(String abilityName, String levelDesc) {
        return new AnalyticEvent("Ability executed", abilityName, levelDesc);
    }

    public static AnalyticEvent getAbilityUpgradeEvent(String abilityName, String levelDesc) {
        String category = "Ability upgrades";
        if (levelDesc.equals("lvl1")) {
            category = "Ability unlocked";
        }
        return new AnalyticEvent(category, abilityName, levelDesc);
    }

    public static AnalyticEvent onPvpKillWithAbility(String damageSourceName) {
        return new AnalyticEvent("Killed", "player > player", damageSourceName);
    }

    public static AnalyticEvent onMobKill(String mobName, DamageSource damageSource) {
        return new AnalyticEvent("Killed", "player > " + mobName, damageSource.field_76373_n);
    }

    public static AnalyticEvent onPlayerDeathWithMob(String mobName) {
        return new AnalyticEvent("Killed", mobName + " > player");
    }

    public static AnalyticEvent onOutOfChi() {
        return new AnalyticEvent("Misc", "out of chi");
    }

    public static AnalyticEvent onSleepRestoration() {
        return new AnalyticEvent("Misc", "Restored chi from sleep");
    }

    public static AnalyticEvent onBisonTamed() {
        return new AnalyticEvent("Bison", "tamed");
    }

    public static AnalyticEvent onBisonDefend(String targetEntity) {
        return new AnalyticEvent("Bison", "defend vs " + targetEntity);
    }

    public static AnalyticEvent onNpcTrade() {
        return new AnalyticEvent("Scrolls", "NPC trade");
    }

    public static AnalyticEvent onMobScrollDrop(String mobName, String scrollType) {
        return new AnalyticEvent("Scrolls", "mob dropped scroll", mobName + " dropped " + scrollType);
    }

    public static AnalyticEvent onAvatarCommand() {
        return new AnalyticEvent("Misc", "used /avatar command");
    }

    public static AnalyticEvent onScrollShared(String scrollType) {
        return new AnalyticEvent("Scrolls", "shared scroll", scrollType);
    }
}

