/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.analytics;

import com.crowsofwar.avatar.config.ConfigAnalytics;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class AnalyticsUtils {
    public static final String GA_TRACKING_ID = "G-HWJB0B4E22";

    public static String getBasicParameters() {
        String params = "v=1";
        params = params + "&tid=G-HWJB0B4E22";
        params = params + "&cid=" + ConfigAnalytics.ANALYTICS_CONFIG.analyticsId;
        return params;
    }

    public static void makeSingleApiRequest(String params) {
        if (ConfigAnalytics.ANALYTICS_CONFIG.isAnalyticsEnabled()) {
            AnalyticsUtils.post("https://www.google-analytics.com/collect", params);
        }
    }

    public static void makeBatchApiRequest(String params) {
        if (ConfigAnalytics.ANALYTICS_CONFIG.isAnalyticsEnabled()) {
            AnalyticsUtils.post("https://www.google-analytics.com/batch", params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void post(String url, String payload) {
        HttpURLConnection connection = null;
        try {
            URL urlObject = new URL(url);
            connection = (HttpURLConnection)urlObject.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            byte[] payloadBytes = payload.getBytes(StandardCharsets.UTF_8);
            connection.setFixedLengthStreamingMode(payloadBytes.length);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.connect();
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(payloadBytes);
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

