/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.analytics;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.network.AvatarServerProxy;
import com.crowsofwar.avatar.util.analytics.AnalyticEvent;
import com.crowsofwar.avatar.util.analytics.AnalyticsUtils;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;

public class AvatarAnalytics {
    public static final int MAX_BULK_EVENTS = 20;
    public static final AvatarAnalytics INSTANCE = new AvatarAnalytics();
    private final Deque<AnalyticEvent> queuedEvents = new LinkedList<AnalyticEvent>();

    public void init() {
        boolean isServer = AvatarMod.proxy instanceof AvatarServerProxy;
        String language = "server";
        if (FMLCommonHandler.instance().getCurrentLanguage() != null) {
            language = isServer ? "server" : FMLCommonHandler.instance().getCurrentLanguage();
        }
        int mods = Loader.instance().getModList().size() - 5;
        String params = AnalyticsUtils.getBasicParameters();
        params = params + "&t=event";
        params = params + "&ec=userstats";
        params = params + "&ea=userstats";
        params = params + "&cd1=" + isServer;
        params = params + "&cd3=" + language;
        params = params + "&cd2=" + AvatarMod.proxy.isOptifinePresent();
        params = params + "&cm1=" + mods;
        params = params + "&an=av2";
        params = params + "&av=1.6.0-alpha.11";
        params = params + "&sc=start";
        AnalyticsUtils.makeSingleApiRequest(params);
        Runtime.getRuntime().addShutdownHook(new Thread(INSTANCE::onExit));
    }

    public void onExit() {
        String params = AnalyticsUtils.getBasicParameters();
        params = params + "&t=event";
        params = params + "&ec=userstats";
        params = params + "&ea=userstats_end";
        params = params + "&sc=end";
        AnalyticsUtils.makeSingleApiRequest(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEvent(AnalyticEvent event) {
        Deque<AnalyticEvent> deque = this.queuedEvents;
        synchronized (deque) {
            this.queuedEvents.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEvents(AnalyticEvent ... events) {
        Deque<AnalyticEvent> deque = this.queuedEvents;
        synchronized (deque) {
            this.queuedEvents.addAll(Arrays.asList(events));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadEvents() {
        AnalyticEvent[] queuedEventsArray;
        Deque<AnalyticEvent> deque = this.queuedEvents;
        synchronized (deque) {
            queuedEventsArray = this.queuedEvents.toArray(new AnalyticEvent[0]);
        }
        this.sendEvents(queuedEventsArray);
        deque = this.queuedEvents;
        synchronized (deque) {
            this.queuedEvents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnsentEventsAmount() {
        Deque<AnalyticEvent> deque = this.queuedEvents;
        synchronized (deque) {
            return this.queuedEvents.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestEventTime() {
        Deque<AnalyticEvent> deque = this.queuedEvents;
        synchronized (deque) {
            if (!this.queuedEvents.isEmpty()) {
                AnalyticEvent latestEvent = this.queuedEvents.getLast();
                return System.currentTimeMillis() - latestEvent.getCreationTime();
            }
        }
        return -1L;
    }

    private String getEventParameters(AnalyticEvent event) {
        String params = AnalyticsUtils.getBasicParameters();
        params = params + "&t=event";
        params = params + "&ec=" + event.getCategory();
        params = params + "&ea=" + event.getAction();
        if (event.hasLabel()) {
            params = params + "&el=" + event.getLabel();
        }
        params = params + "&qt=" + (System.currentTimeMillis() - event.getCreationTime());
        return params;
    }

    private void sendEvents(AnalyticEvent ... events) {
        int sentEvents = 0;
        while (events.length - sentEvents > 0) {
            int sentHere;
            String params = "";
            for (sentHere = 0; sentEvents < events.length && sentHere < 20; ++sentEvents, ++sentHere) {
                params = params + this.getEventParameters(events[sentEvents]) + "\n";
            }
            if (sentHere == 1) {
                AnalyticsUtils.makeSingleApiRequest(params);
                continue;
            }
            AnalyticsUtils.makeBatchApiRequest(params);
        }
    }
}

