/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.command;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.TreeCommandException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;

public class ArgumentAbility
implements IArgument<Ability> {
    private final String name;

    public ArgumentAbility(String name) {
        this.name = name;
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public Ability getDefaultValue() {
        return null;
    }

    @Override
    public Ability convert(String input) {
        for (Ability ability : Abilities.all()) {
            if (!ability.getName().equals(input)) continue;
            return ability;
        }
        throw new TreeCommandException("avatar.cmd.noAbility", input);
    }

    @Override
    public String getArgumentName() {
        return this.name;
    }

    @Override
    public String getHelpString() {
        String out = "<";
        for (Ability ability : Abilities.all()) {
            out = out + ability.getName() + "|";
        }
        return out.substring(0, out.length() - 1) + ">";
    }

    @Override
    public String getSpecificationString() {
        return "<" + this.name + ">";
    }

    @Override
    public List<String> getCompletionSuggestions(ICommandSender sender, String currentInput) {
        ArrayList<String> out = new ArrayList<String>();
        for (Ability ability : Abilities.all()) {
            out.add(ability.getName());
        }
        return out;
    }
}

