/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.command;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.BendingStyles;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.util.analytics.AnalyticEvents;
import com.crowsofwar.avatar.util.analytics.AvatarAnalytics;
import com.crowsofwar.avatar.util.command.NodeAbilityGet;
import com.crowsofwar.avatar.util.command.NodeAbilitySet;
import com.crowsofwar.avatar.util.command.NodeBendingAdd;
import com.crowsofwar.avatar.util.command.NodeBendingList;
import com.crowsofwar.avatar.util.command.NodeBendingRemove;
import com.crowsofwar.avatar.util.command.NodeConfig;
import com.crowsofwar.avatar.util.command.NodeXpSet;
import com.crowsofwar.gorecore.tree.ICommandNode;
import com.crowsofwar.gorecore.tree.ITypeConverter;
import com.crowsofwar.gorecore.tree.NodeBranch;
import com.crowsofwar.gorecore.tree.TreeCommand;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class AvatarCommand
extends TreeCommand {
    public static final List<BendingStyle>[] CONTROLLER_BENDING_OPTIONS;
    public static final ITypeConverter<List<BendingStyle>> CONVERTER_BENDING;

    public AvatarCommand() {
        super(AvatarChatMessages.CFG);
    }

    public String func_71517_b() {
        return "avatar";
    }

    @Override
    protected ICommandNode[] addCommands() {
        NodeBendingList bendingList = new NodeBendingList();
        NodeBendingAdd bendingAdd = new NodeBendingAdd();
        NodeBendingRemove bendingRemove = new NodeBendingRemove();
        NodeBranch branchBending = new NodeBranch(AvatarChatMessages.MSG_BENDING_BRANCH_INFO, "bending", bendingList, bendingAdd, bendingRemove);
        NodeBranch branchAbility = new NodeBranch(this.branchHelpDefault, "ability", new NodeAbilityGet(), new NodeAbilitySet());
        return new ICommandNode[]{branchBending, new NodeConfig(), branchAbility, new NodeXpSet()};
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] arguments) throws CommandException {
        if (sender.func_70003_b(2, "avatarmod.command.avatar")) {
            super.func_184881_a(server, sender, arguments);
            AvatarAnalytics.INSTANCE.pushEvent(AnalyticEvents.onAvatarCommand());
        } else {
            TextComponentTranslation messagePermission = new TextComponentTranslation("commands.generic.permission", new Object[0]);
            messagePermission.func_150256_b().func_150238_a(TextFormatting.RED);
            sender.func_145747_a((ITextComponent)messagePermission);
        }
    }

    static {
        CONVERTER_BENDING = new ITypeConverter<List<BendingStyle>>(){

            @Override
            public List<BendingStyle> convert(String str) {
                return str.equals("all") ? BendingStyles.all() : Arrays.asList(BendingStyles.get(str.toLowerCase()));
            }

            @Override
            public String toString(List<BendingStyle> obj) {
                return obj.equals(BendingStyles.all()) ? "all" : obj.get(0).getName();
            }

            @Override
            public String getTypeName() {
                return "Bending";
            }
        };
        CONTROLLER_BENDING_OPTIONS = new List[BendingStyles.all().size() + 1];
        AvatarCommand.CONTROLLER_BENDING_OPTIONS[0] = BendingStyles.all();
        for (int i = 1; i < CONTROLLER_BENDING_OPTIONS.length; ++i) {
            AvatarCommand.CONTROLLER_BENDING_OPTIONS[i] = Arrays.asList(BendingStyles.all().get(i - 1));
        }
    }
}

