/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.command;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.util.command.ArgumentAbility;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.gorecore.tree.ArgumentList;
import com.crowsofwar.gorecore.tree.ArgumentPlayerName;
import com.crowsofwar.gorecore.tree.ArgumentRangeInteger;
import com.crowsofwar.gorecore.tree.CommandCall;
import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ICommandNode;
import com.crowsofwar.gorecore.tree.NodeFunctional;
import java.util.List;

public class NodeAbilitySet
extends NodeFunctional {
    private final IArgument<String> argPlayer = this.addArgument(new ArgumentPlayerName("player"));
    private final IArgument<Ability> argAbility = this.addArgument(new ArgumentAbility("ability"));
    private final IArgument<Integer> argSetTo = this.addArgument(new ArgumentRangeInteger("value", 0, 100));

    public NodeAbilitySet() {
        super("set", true);
    }

    @Override
    protected ICommandNode doFunction(CommandCall call, List<String> options) {
        ArgumentList args = call.popArguments(this);
        String player = args.get(this.argPlayer);
        Ability ability = args.get(this.argAbility);
        int setXp = args.get(this.argSetTo);
        if (setXp >= 0 && setXp <= 100) {
            BendingData data = BendingData.get(call.getFrom().func_130014_f_(), player);
            if (data != null) {
                data.getAbilityData(ability).setXp(setXp);
                AvatarChatMessages.MSG_ABILITY_SET_SUCCESS.send(call.getFrom(), player, ability.getName(), setXp);
            }
        } else {
            AvatarChatMessages.MSG_ABILITY_SET_RANGE.send(call.getFrom(), new Object[0]);
        }
        return null;
    }
}

