/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.command;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.command.AvatarCommand;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.event.ElementUnlockEvent;
import com.crowsofwar.gorecore.tree.ArgumentList;
import com.crowsofwar.gorecore.tree.ArgumentOptions;
import com.crowsofwar.gorecore.tree.ArgumentPlayerName;
import com.crowsofwar.gorecore.tree.CommandCall;
import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ICommandNode;
import com.crowsofwar.gorecore.tree.NodeFunctional;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class NodeBendingAdd
extends NodeFunctional {
    private final IArgument<String> argPlayerName = this.addArgument(new ArgumentPlayerName("player"));
    private final IArgument<List<BendingStyle>> argBendingController = this.addArgument(new ArgumentOptions<List<BendingStyle>>(AvatarCommand.CONVERTER_BENDING, "bending", AvatarCommand.CONTROLLER_BENDING_OPTIONS));

    public NodeBendingAdd() {
        super("add", true);
    }

    @Override
    protected ICommandNode doFunction(CommandCall call, List<String> options) {
        ICommandSender sender = call.getFrom();
        World world = sender.func_130014_f_();
        ArgumentList args = call.popArguments(this);
        String playerName = args.get(this.argPlayerName);
        List<BendingStyle> controllers = args.get(this.argBendingController);
        EntityPlayer player = AvatarEntityUtils.getPlayerFromUsername(playerName);
        for (BendingStyle controller : controllers) {
            BendingData data = BendingData.get(world, playerName);
            if (!controller.canEntityUse()) continue;
            if (data == null) {
                AvatarChatMessages.MSG_PLAYER_DATA_NO_DATA.send(sender, playerName);
                continue;
            }
            if (data.hasBendingId(controller.getId())) {
                AvatarChatMessages.MSG_BENDING_ADD_ALREADY_HAS.send(sender, playerName, controller.getName());
                continue;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new ElementUnlockEvent((EntityLivingBase)player, controller))) continue;
            data.addBending(controller);
            AvatarChatMessages.MSG_BENDING_ADD_SUCCESS.send(sender, playerName, controller.getName());
        }
        return null;
    }
}

