/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.command;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.gorecore.tree.ArgumentList;
import com.crowsofwar.gorecore.tree.ArgumentPlayerName;
import com.crowsofwar.gorecore.tree.CommandCall;
import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ICommandNode;
import com.crowsofwar.gorecore.tree.NodeFunctional;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.world.World;

public class NodeBendingList
extends NodeFunctional {
    private final IArgument<String> argPlayerName = new ArgumentPlayerName("player");

    public NodeBendingList() {
        super("list", true);
        this.addArgument(this.argPlayerName);
    }

    @Override
    protected ICommandNode doFunction(CommandCall call, List<String> options) {
        ArgumentList args;
        String playerName;
        ICommandSender sender = call.getFrom();
        World world = sender.func_130014_f_();
        BendingData data = BendingData.get(world, playerName = (args = call.popArguments(this)).get(this.argPlayerName));
        if (data == null) {
            AvatarChatMessages.MSG_PLAYER_DATA_NO_DATA.send(sender, playerName);
        } else if (!data.getAllBending().isEmpty()) {
            List<BendingStyle> allControllers = data.getAllBending();
            AvatarChatMessages.MSG_BENDING_LIST_TOP.send(sender, playerName, allControllers.size());
            for (BendingStyle controller : allControllers) {
                AvatarChatMessages.MSG_BENDING_LIST_ITEM.send(sender, controller.getName());
            }
        } else {
            AvatarChatMessages.MSG_BENDING_LIST_NONBENDER.send(sender, playerName);
        }
        return null;
    }
}

