/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.command;

import com.crowsofwar.avatar.config.ConfigAnalytics;
import com.crowsofwar.avatar.config.ConfigChi;
import com.crowsofwar.avatar.config.ConfigClient;
import com.crowsofwar.avatar.config.ConfigMobs;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.gorecore.config.ConfigurationException;
import com.crowsofwar.gorecore.tree.ArgumentDirect;
import com.crowsofwar.gorecore.tree.ArgumentList;
import com.crowsofwar.gorecore.tree.CommandCall;
import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ICommandNode;
import com.crowsofwar.gorecore.tree.ITypeConverter;
import com.crowsofwar.gorecore.tree.NodeFunctional;
import java.util.List;
import net.minecraft.command.ICommandSender;

public class NodeConfig
extends NodeFunctional {
    private final IArgument<String> argKey = this.addArgument(new ArgumentDirect<String>("key", ITypeConverter.CONVERTER_STRING, ""));
    private final IArgument<String> argVal = this.addArgument(new ArgumentDirect<String>("value", ITypeConverter.CONVERTER_STRING, ""));

    public NodeConfig() {
        super("config", true);
    }

    @Override
    protected ICommandNode doFunction(CommandCall call, List<String> options) {
        ArgumentList list = call.popArguments(this);
        String key = list.get(this.argKey);
        String val = list.get(this.argVal);
        if (key.equals("") || val.equals("")) {
            ICommandSender from = call.getFrom();
            boolean exception = false;
            try {
                ConfigStats.load();
                ConfigSkills.load();
                ConfigClient.load();
                ConfigChi.load();
                ConfigMobs.load();
                ConfigStats.STATS_CONFIG.loadBlocks();
                ConfigAnalytics.load();
            }
            catch (ConfigurationException e) {
                exception = true;
                AvatarChatMessages.MSG_CONFIG_EXCEPTION_1.send(from, new Object[0]);
                AvatarChatMessages.MSG_CONFIG_EXCEPTION_2.send(from, e.getCause().toString());
                e.printStackTrace();
            }
            if (!exception) {
                AvatarChatMessages.MSG_CONFIG_SUCCESS.send(from, new Object[0]);
            }
        }
        return null;
    }
}

