/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.command;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.network.AvatarChatMessages;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.command.ArgumentAbility;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.event.AbilityLevelEvent;
import com.crowsofwar.avatar.util.event.AbilityUnlockEvent;
import com.crowsofwar.gorecore.tree.ArgumentDirect;
import com.crowsofwar.gorecore.tree.ArgumentList;
import com.crowsofwar.gorecore.tree.ArgumentOptions;
import com.crowsofwar.gorecore.tree.ArgumentPlayerName;
import com.crowsofwar.gorecore.tree.CommandCall;
import com.crowsofwar.gorecore.tree.IArgument;
import com.crowsofwar.gorecore.tree.ICommandNode;
import com.crowsofwar.gorecore.tree.ITypeConverter;
import com.crowsofwar.gorecore.tree.NodeFunctional;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class NodeXpSet
extends NodeFunctional {
    private final IArgument<String> argPlayerName = new ArgumentPlayerName("player");
    private final IArgument<Ability> argAbility = new ArgumentAbility("ability");
    private final IArgument<String> argSpecification = new ArgumentOptions<String>(ITypeConverter.CONVERTER_STRING, "specification", "locked", "lvl1", "lvl2", "lvl3", "lvl4_1", "lvl4_2");
    private final IArgument<Float> argNewXp = new ArgumentDirect<Float>("xp", ITypeConverter.CONVERTER_FLOAT, Float.valueOf(0.0f));

    public NodeXpSet() {
        super("xp", true);
        this.addArguments(this.argPlayerName, this.argAbility, this.argSpecification, this.argNewXp);
    }

    @Override
    protected ICommandNode doFunction(CommandCall call, List<String> options) {
        int level;
        ArgumentList args = call.popArguments(this);
        String playerName = args.get(this.argPlayerName);
        Ability ability = args.get(this.argAbility);
        String specification = args.get(this.argSpecification);
        float xp = args.get(this.argNewXp).floatValue();
        BendingData data = BendingData.get(call.getFrom().func_130014_f_(), playerName);
        AbilityData abilityData = data.getAbilityData(ability);
        EntityPlayer player = AvatarEntityUtils.getPlayerFromUsername(playerName);
        AbilityData.AbilityTreePath path = AbilityData.AbilityTreePath.MAIN;
        if (specification.equals("locked")) {
            level = -1;
            xp = 0.0f;
        } else {
            String secondPart = specification.substring("lvl".length());
            level = Integer.parseInt(secondPart.charAt(0) + "") - 1;
            if (level == 3) {
                String pathStr = secondPart.substring("n_".length());
                int index = Integer.parseInt(pathStr);
                path = AbilityData.AbilityTreePath.values()[index];
            }
        }
        if (level == 0 && abilityData.getLevel() < 0 && !MinecraftForge.EVENT_BUS.post((Event)new AbilityUnlockEvent((EntityLivingBase)player, ability)) || !MinecraftForge.EVENT_BUS.post((Event)new AbilityLevelEvent((EntityLivingBase)player, ability, abilityData.getLevel() + 1, level + 1))) {
            abilityData.setLevel(level);
            abilityData.setXp(xp);
            abilityData.setPath(path);
            AvatarChatMessages.MSG_XPSET_SUCCESS.send(call.getFrom(), playerName, ability.getName(), specification);
        }
        return null;
    }
}

