/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.damageutils;

import com.crowsofwar.avatar.util.AvatarUtils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="avatarmod")
public class AvatarDamageSource {
    public static final DamageSource WATER = new DamageSource("avatar_Water");
    public static final DamageSource FIRE = new DamageSource("avatar_Fire");
    public static final DamageSource EARTH = new DamageSource("avatar_Earth");
    public static final DamageSource AIR = new DamageSource("avatar_Air");
    public static final DamageSource LIGHTNING = new DamageSource("avatar_Lightning");
    public static final DamageSource COMBUSTION = new DamageSource("avatar_Combustion");
    public static final DamageSource SAND = new DamageSource("avatar_Sand");
    public static final DamageSource ICE = new DamageSource("avatar_Ice");

    public static boolean isAvatarDamageSource(DamageSource source) {
        return source.func_76355_l().startsWith("avatar_");
    }

    public static String getNameFromBendingStyle(String elementName) {
        String damageName = "";
        if (elementName.equalsIgnoreCase("firebending")) {
            damageName = "Fire";
        } else if (elementName.equalsIgnoreCase("waterbending")) {
            damageName = "Water";
        } else if (elementName.equalsIgnoreCase("earthbending")) {
            damageName = "Earth";
        } else if (elementName.equalsIgnoreCase("airbending")) {
            damageName = "Air";
        } else if (elementName.equalsIgnoreCase("lightningbending")) {
            damageName = "Lightning";
        } else if (elementName.equalsIgnoreCase("sandbending")) {
            damageName = "Sand";
        } else if (elementName.equalsIgnoreCase("icebending")) {
            damageName = "Ice";
        } else if (elementName.equalsIgnoreCase("combustionbending")) {
            damageName = "Combustion";
        }
        return damageName;
    }

    public static boolean isAirDamage(DamageSource source) {
        return source.func_76355_l().startsWith("avatar_Air");
    }

    public static boolean isEarthDamage(DamageSource source) {
        return source.func_76355_l().startsWith("avatar_Earth");
    }

    public static boolean isWaterDamage(DamageSource source) {
        return source.func_76355_l().startsWith("avatar_Water");
    }

    public static boolean isFireDamage(DamageSource source) {
        return source.func_76355_l().startsWith("avatar_Fire");
    }

    public static boolean isLightningDamage(DamageSource source) {
        return source.func_76355_l().startsWith("avatar_Lightning");
    }

    public static boolean isCombustionDamage(DamageSource source) {
        return source.func_76355_l().startsWith("avatar_Combustion");
    }

    public static boolean isIceDamage(DamageSource source) {
        return source.func_76355_l().startsWith("avatar_Ice");
    }

    public static boolean isSandDamage(DamageSource source) {
        return source.func_76355_l().startsWith("avatar_Sand");
    }

    public static DamageSource causeAirDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(AIR.func_76355_l(), hit, owner);
    }

    public static DamageSource causeAirbladeDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(AIR.func_76355_l() + "_airblade", hit, owner).func_76349_b();
    }

    public static DamageSource causeWaterDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(WATER.func_76355_l(), hit, owner);
    }

    public static DamageSource causeWaterArcDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(WATER.func_76355_l() + "_waterArc", hit, owner).func_76349_b();
    }

    public static DamageSource causeWaveDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(WATER.func_76355_l() + "_wave", hit, owner).func_76349_b();
    }

    public static DamageSource causeWaterCannonDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(WATER.func_76355_l() + "_waterBlast", hit, owner);
    }

    public static DamageSource causeFireDamage(Entity source, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(FIRE.func_76355_l(), source, owner);
    }

    public static DamageSource causeFireShotDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(FIRE.func_76355_l() + "_fireShot", hit, owner);
    }

    public static DamageSource causeDragonFireDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(FIRE.func_76355_l() + "_dragonFire", hit, owner).func_76349_b();
    }

    public static DamageSource causeFireballDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(FIRE.func_76355_l() + "_fireball", hit, owner).func_76349_b().func_94540_d();
    }

    public static DamageSource causeFlamethrowerDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(FIRE.func_76355_l() + "_flamethrower", hit, owner).func_76349_b();
    }

    public static DamageSource causeEarthDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect(EARTH.func_76355_l(), hit, owner);
    }

    public static DamageSource causeFloatingBlockDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect("avatar_Earth_floatingBlock", hit, owner).func_76349_b();
    }

    public static DamageSource causeRavineDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect("avatar_Earth_ravine", hit, owner);
    }

    public static DamageSource causeEarthspikeDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect("avatar_Earth_earthspike", hit, owner);
    }

    public static DamageSource causeShockwaveDamage(Entity hit, @Nullable Entity owner, DamageSource element) {
        return new EntityDamageSourceIndirect(element.func_76355_l() + "_shockwave", hit, owner);
    }

    public static DamageSource causeSphericalShockwaveDamage(Entity hit, @Nullable Entity owner, DamageSource element) {
        return new EntityDamageSourceIndirect(element.func_76355_l() + "_sphere_shockwave", hit, owner);
    }

    public static DamageSource causeBeamDamage(Entity hit, @Nullable Entity owner, DamageSource element) {
        return new EntityDamageSourceIndirect(element.func_76355_l() + "_beam", hit, owner);
    }

    public static DamageSource causeLightningDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect("avatar_Lightning", hit, owner).func_76348_h();
    }

    public static DamageSource causeRedirectedLightningDamage(Entity hit, @Nullable Entity controller) {
        return new EntityDamageSourceIndirect("avatar_Lightning_redirected", hit, controller).func_76348_h();
    }

    public static DamageSource causeLightningSpearDamage(Entity hit, @Nullable Entity controller) {
        return new EntityDamageSourceIndirect("avatar_Lightning_lightningSpear", hit, controller).func_76348_h().func_76349_b();
    }

    public static DamageSource causeIcePrisonDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect("avatar_Ice_icePrison", hit, owner).func_76348_h();
    }

    public static DamageSource causeIceShardDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect("avatar_Ice_iceShard", hit, owner).func_76348_h().func_76349_b();
    }

    public static DamageSource causeSandPrisonDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect("avatar_Sand_sandPrison", hit, owner);
    }

    public static DamageSource causeSandstormDamage(Entity hit, @Nullable Entity owner) {
        return new EntityDamageSourceIndirect("avatar_Sand_sandstorm", hit, owner);
    }

    @SubscribeEvent
    public static void onElementalDamage(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        Entity hit = event.getEntity();
        if (hit instanceof EntityLivingBase) {
            if (AvatarDamageSource.isAvatarDamageSource(source)) {
                source.func_82726_p();
            }
            if (AvatarDamageSource.isWaterDamage(source)) {
                hit.func_70015_d(0);
                if (hit instanceof EntityEnderman || hit instanceof EntityEndermite) {
                    event.setAmount(event.getAmount() * 1.25f);
                }
                if (hit instanceof EntityGuardian || hit instanceof EntityWaterMob) {
                    event.setAmount(event.getAmount() * 0.75f);
                }
            }
            if (AvatarDamageSource.isFireDamage(source)) {
                if (hit.func_70045_F()) {
                    event.setAmount(event.getAmount() * 0.25f);
                }
                if (((EntityLivingBase)hit).func_70644_a(MobEffects.field_76426_n)) {
                    event.setAmount(event.getAmount() * (0.75f / (float)(Objects.requireNonNull(((EntityLivingBase)hit).func_70660_b(MobEffects.field_76426_n)).func_76458_c() + 1)));
                }
            }
            if (AvatarDamageSource.isAirDamage(source) && hit instanceof EntityFlying) {
                event.setAmount(event.getAmount() * 1.25f);
            }
            if (AvatarDamageSource.isLightningDamage(source)) {
                source.func_76348_h();
                if (hit instanceof EntityWaterMob) {
                    event.setAmount(event.getAmount() * 1.5f);
                }
                if (hit instanceof EntityCreeper) {
                    AvatarUtils.chargeCreeper((EntityCreeper)hit);
                }
            }
            if (AvatarDamageSource.isCombustionDamage(source)) {
                source.func_94540_d();
                if (hit instanceof EntityCreeper) {
                    event.setAmount(event.getAmount() * 0.5f);
                    AvatarUtils.igniteCreeper((EntityCreeper)hit);
                }
            }
            if (AvatarDamageSource.isSandDamage(source)) {
                if (hit instanceof EntityHusk) {
                    event.setAmount(event.getAmount() * 0.75f);
                }
                if (hit.field_70170_p.field_73012_v.nextInt(3) + 1 == 2) {
                    ((EntityLivingBase)hit).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 5, 0, false, false));
                }
            }
            if (AvatarDamageSource.isIceDamage(source)) {
                if (hit instanceof EntityStray) {
                    event.setAmount(event.getAmount() * 0.75f);
                }
                if (hit.field_70170_p.field_73012_v.nextInt(3) + 1 == 2) {
                    ((EntityLivingBase)hit).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 5, 0, false, false));
                }
            }
        }
    }
}

