/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.AbilityModifier;
import com.crowsofwar.avatar.bending.bending.SourceInfo;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.DataCategory;
import com.crowsofwar.gorecore.util.GoreCoreByteBufUtil;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class AbilityData {
    public static final int MAX_LEVEL = 3;
    private final BendingData data;
    private final String abilityName;
    private float lastXp;
    private float xp;
    private boolean switchPath;
    private int abilityCooldown;
    private double powerRating;
    private float exhaustion;
    private boolean shouldRegenBurnout;
    private int useNumber;
    private SourceInfo sourceInfo;
    private List<AbilityModifier> modifiers;
    private float burnOut;
    private int level;
    private AbilityTreePath path;

    public AbilityData(BendingData data, Ability ability) {
        this(data, ability.getName());
    }

    public AbilityData(BendingData data, String abilityName) {
        this.data = data;
        this.abilityName = abilityName;
        this.xp = 0.0f;
        this.level = -1;
        this.path = AbilityTreePath.MAIN;
        this.switchPath = false;
        this.abilityCooldown = 0;
        this.burnOut = 0.0f;
        this.exhaustion = 0.0f;
        this.powerRating = 0.0;
        this.shouldRegenBurnout = true;
        this.useNumber = 1;
        this.sourceInfo = new SourceInfo();
        this.modifiers = new ArrayList<AbilityModifier>();
    }

    public AbilityData(BendingData data, String abilityName, boolean switchPath) {
        this.data = data;
        this.abilityName = abilityName;
        this.xp = 0.0f;
        this.level = -1;
        this.path = AbilityTreePath.MAIN;
        this.switchPath = switchPath;
        this.abilityCooldown = 0;
        this.burnOut = 0.0f;
        this.exhaustion = 0.0f;
        this.powerRating = 0.0;
        this.shouldRegenBurnout = true;
        this.useNumber = 1;
        this.sourceInfo = new SourceInfo();
        this.modifiers = new ArrayList<AbilityModifier>();
    }

    public static AbilityData createFromBytes(ByteBuf buf, BendingData data) {
        String abilityName = GoreCoreByteBufUtil.readString(buf);
        AbilityData abilityData = new AbilityData(data, abilityName);
        abilityData.fromBytes(buf);
        return abilityData;
    }

    @Nullable
    public static AbilityData get(EntityLivingBase entity, String abilityName) {
        return BendingData.getFromEntity(entity).getAbilityData(abilityName);
    }

    public static AbilityData get(World world, UUID playerId, String abilityName) {
        return BendingData.get(world, playerId).getAbilityData(abilityName);
    }

    public static AbilityData get(World world, String playerName, String abilityName) {
        return BendingData.get(world, playerName).getAbilityData(abilityName);
    }

    public int getUseNumber() {
        return this.useNumber;
    }

    public void setUseNumber(int number) {
        this.useNumber = number;
    }

    public void setSwitchPath(boolean switchPath) {
        this.switchPath = switchPath;
    }

    public boolean shouldSwitchPath() {
        return this.switchPath;
    }

    public void setRegenBurnout(boolean regen) {
        this.shouldRegenBurnout = regen;
    }

    public boolean shouldRegenBurnout() {
        return this.shouldRegenBurnout;
    }

    public void addBurnout(float burnout) {
        this.burnOut += MathHelper.func_76131_a((float)burnout, (float)0.0f, (float)100.0f);
    }

    public float getBurnOut() {
        return this.burnOut;
    }

    public void setBurnOut(float burnOut) {
        this.burnOut = burnOut;
        this.burnOut = MathHelper.func_76131_a((float)this.burnOut, (float)0.0f, (float)100.0f);
    }

    public int getAbilityCooldown() {
        return this.abilityCooldown;
    }

    public void setAbilityCooldown(int cooldown) {
        this.abilityCooldown = cooldown;
    }

    public int getAbilityCooldown(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
            return 0;
        }
        return this.getAbilityCooldown();
    }

    public Number modify(String property, Number val) {
        float baseVal = val.floatValue();
        for (AbilityModifier modifier : this.getModifiers()) {
            baseVal *= modifier.getProperty(property).floatValue();
        }
        return Float.valueOf(baseVal);
    }

    public void setModifier(List<AbilityModifier> modifiers) {
        this.modifiers = modifiers;
    }

    public List<AbilityModifier> getModifiers() {
        return this.modifiers;
    }

    public void addModifiers(AbilityModifier ... modifiers) {
        if (!this.modifiers.contains(modifiers)) {
            this.modifiers.addAll(Arrays.asList((Object[])modifiers.clone()));
        }
    }

    public void removeModifiers(AbilityModifier ... modifiers) {
        if (this.modifiers.contains(modifiers)) {
            this.modifiers.removeAll(Arrays.asList((Object[])modifiers.clone()));
        }
    }

    public void clearModifier() {
        this.modifiers = new ArrayList<AbilityModifier>();
    }

    public void decrementCooldown() {
        --this.abilityCooldown;
    }

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public void setSourceInfo(SourceInfo info) {
        this.sourceInfo = info;
    }

    public IBlockState getSourceBlock() {
        return this.sourceInfo.getBlockState();
    }

    public void setSourceBlock(IBlockState state) {
        this.sourceInfo.setState(state);
    }

    public void clearSourceBlock() {
        this.sourceInfo.setState(Blocks.field_150350_a.func_176223_P());
    }

    public int getSourceTime() {
        return this.sourceInfo.getTime();
    }

    public void setSourceTime(int time) {
        this.sourceInfo.setTime(time);
    }

    public void incrementSourceTime() {
        this.setSourceTime(this.getSourceTime() + 1);
    }

    public void clearSourceTime() {
        this.sourceInfo.setTime(-1);
    }

    public double getPowerRating() {
        return this.powerRating;
    }

    public void setPowerRating(double power) {
        this.powerRating = power;
    }

    public double getDamageMult() {
        double powerRating = this.getPowerRating();
        if (powerRating < 0.0) {
            return 0.005 * powerRating + 1.0 < 0.0 ? (double)0.02f : 0.005 * powerRating + 1.0;
        }
        return 0.005 * powerRating + 1.0;
    }

    public double getPowerRatingMult() {
        double powerRating = this.getPowerRating();
        if (powerRating < 0.0) {
            return 0.01 * powerRating + 1.0 < 0.0 ? (double)0.01f : 0.01 * powerRating + 1.0;
        }
        return 0.01 * powerRating + 1.0;
    }

    @Nullable
    public Ability getAbility() {
        return Abilities.get(this.abilityName);
    }

    public String getAbilityName() {
        return this.abilityName;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (level < -1) {
            level = -1;
        }
        if (level > 3) {
            level = 3;
        }
        this.level = level;
        this.checkPath();
        this.save();
    }

    public void addLevel() {
        this.setLevel(this.level + 1);
    }

    public String getLevelDesc() {
        String str = "lvl" + (this.level + 1);
        if (this.level == 3) {
            str = str + "_" + this.path.ordinal();
        }
        return str;
    }

    public AbilityTreePath getPath() {
        return this.path;
    }

    public void setPath(AbilityTreePath path) {
        this.path = path;
        this.checkPath();
        this.save();
    }

    public boolean isMasterPath(AbilityTreePath path) {
        return this.isMaxLevel() && this.path == path;
    }

    public boolean isDynamicMasterLevel(AbilityTreePath path) {
        return this.getLevel() == 3 && this.getDynamicPath() == path;
    }

    private void checkPath() {
        if (this.level == 3 && this.path == AbilityTreePath.MAIN) {
            this.setPath(AbilityTreePath.FIRST);
        }
    }

    public AbilityTreePath getDynamicPath() {
        AbilityTreePath currentPath = this.getPath();
        if (this.switchPath) {
            if (currentPath == AbilityTreePath.FIRST) {
                return AbilityTreePath.SECOND;
            }
            if (currentPath == AbilityTreePath.SECOND) {
                return AbilityTreePath.FIRST;
            }
            return AbilityTreePath.MAIN;
        }
        return currentPath;
    }

    public float getTotalXp() {
        return (float)(this.level * 33) + this.xp * 33.0f / 100.0f;
    }

    public float getXpModifier() {
        return (float)Math.min(this.getTotalXp() / 100.0f < 1.0f ? 1.0 : (double)(this.getTotalXp() / 100.0f), 1.36);
    }

    public float getXp() {
        return this.xp;
    }

    public void setXp(float xp) {
        if (xp == this.xp) {
            return;
        }
        this.lastXp = this.xp;
        if (xp < 0.0f) {
            xp = 0.0f;
        }
        if (xp > 100.0f) {
            xp = 100.0f;
        }
        this.xp = xp;
        this.save();
    }

    public void addXp(float xp) {
        if ((xp *= this.getXpMultiplier()) == 0.0f) {
            return;
        }
        this.setXp(this.xp + xp);
    }

    public float getLastXp() {
        return this.lastXp;
    }

    public void resetLastXp() {
        this.lastXp = this.xp;
    }

    public boolean isMaxLevel() {
        return this.level >= 3;
    }

    public float getXpMultiplier() {
        float x = this.xp / 100.0f;
        if (this.level == 0) {
            return 1.0f - 0.2f * x * x;
        }
        if (this.level == 1) {
            return 0.8f - 0.2f * (x - 1.0f) * (x - 1.0f);
        }
        if (this.level == 2) {
            return 0.6f - 0.1f * (x - 2.0f) * (x - 2.0f);
        }
        return 0.0f;
    }

    public boolean isLocked() {
        return this.level == -1;
    }

    public void unlockAbility() {
        if (this.isLocked()) {
            this.level = 0;
        }
    }

    public int getCurrentTier() {
        int tier = 0;
        if (this.getAbility() != null) {
            tier += this.getAbility().getBaseTier();
            switch (this.level) {
                default: {
                    break;
                }
                case 2: {
                    ++tier;
                    break;
                }
                case 3: {
                    tier += 2;
                }
            }
        }
        return tier;
    }

    public void readFromNbt(NBTTagCompound nbt) {
        this.xp = nbt.func_74760_g("Xp");
        this.lastXp = nbt.func_74760_g("lastXp");
        this.level = nbt.func_74762_e("Level");
        this.path = AbilityTreePath.get(nbt.func_74762_e("Path"));
        this.abilityCooldown = nbt.func_74762_e("AbilityCooldown");
        this.powerRating = nbt.func_74769_h("PowerRating");
        this.exhaustion = nbt.func_74760_g("Exhaustion");
        this.burnOut = nbt.func_74760_g("Burnout");
        this.shouldRegenBurnout = nbt.func_74767_n("RegenBurnout");
        this.useNumber = nbt.func_74762_e("Jumps");
        this.sourceInfo = this.sourceInfo.readFromNBT(nbt);
        nbt.func_74768_a("Modifier Size", this.modifiers.size());
        for (AbilityModifier modifier : this.modifiers) {
            modifier.toNBT(nbt);
        }
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74776_a("Xp", this.xp);
        nbt.func_74776_a("LastXp", this.lastXp);
        nbt.func_74768_a("Level", this.level);
        nbt.func_74768_a("Path", this.path.id());
        nbt.func_74768_a("AbilityCooldown", this.abilityCooldown);
        nbt.func_74780_a("PowerRating", this.powerRating);
        nbt.func_74776_a("Exhaustion", this.exhaustion);
        nbt.func_74776_a("Burnout", this.burnOut);
        nbt.func_74757_a("RegenBurnout", this.shouldRegenBurnout);
        nbt.func_74768_a("Jumps", this.useNumber);
        this.sourceInfo.writeToNBT(nbt);
        int size = nbt.func_74762_e("Modifier Size");
        this.modifiers.clear();
        for (int i = 0; i < size; ++i) {
            this.modifiers.add(i, AbilityModifier.staticFromNBT(nbt));
        }
    }

    public void toBytes(ByteBuf buf) {
        GoreCoreByteBufUtil.writeString(buf, this.abilityName);
        buf.writeFloat(this.xp);
        buf.writeInt(this.level);
        buf.writeInt(this.path.id());
        buf.writeInt(this.abilityCooldown);
        buf.writeDouble(this.powerRating);
        buf.writeFloat(this.exhaustion);
        buf.writeFloat(this.burnOut);
        buf.writeBoolean(this.shouldRegenBurnout);
        buf.writeInt(this.useNumber);
        this.sourceInfo.writeToBytes(buf);
        buf.writeInt(this.modifiers.size());
        if (!this.modifiers.isEmpty()) {
            for (AbilityModifier modifier : this.modifiers) {
                modifier.toBytes(buf);
            }
        }
    }

    private void fromBytes(ByteBuf buf) {
        this.xp = buf.readFloat();
        this.level = buf.readInt();
        this.path = AbilityTreePath.get(buf.readInt());
        this.abilityCooldown = buf.readInt();
        this.powerRating = buf.readDouble();
        this.exhaustion = buf.readFloat();
        this.burnOut = buf.readFloat();
        this.shouldRegenBurnout = buf.readBoolean();
        this.useNumber = buf.readInt();
        this.sourceInfo = this.sourceInfo.readFromBytes(buf);
        int size = buf.readInt();
        if (size > 0) {
            this.modifiers.clear();
            for (int i = 0; i < size; ++i) {
                this.modifiers.add(i, new AbilityModifier().fromBytes(buf));
            }
        }
    }

    private void save() {
        this.data.save(DataCategory.ABILITY_DATA);
    }

    public static enum AbilityTreePath {
        MAIN,
        FIRST,
        SECOND;


        @Nullable
        public static AbilityTreePath get(int id) {
            if (id < 0 || id >= AbilityTreePath.values().length) {
                return null;
            }
            return AbilityTreePath.values()[id];
        }

        public int id() {
            return this.ordinal();
        }
    }
}

