/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.AvatarMod;
import com.crowsofwar.avatar.network.packets.PacketCPlayerData;
import com.crowsofwar.avatar.util.data.AvatarWorldData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.DataCategory;
import com.crowsofwar.gorecore.data.DataSaver;
import com.crowsofwar.gorecore.data.PlayerData;
import com.crowsofwar.gorecore.data.PlayerDataFetcher;
import com.crowsofwar.gorecore.data.PlayerDataFetcherServer;
import com.crowsofwar.gorecore.data.PlayerDataFetcherSided;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AvatarPlayerData
extends PlayerData {
    private static PlayerDataFetcher<AvatarPlayerData> fetcher;
    private final BendingData bendingData;
    private SortedSet<DataCategory> changed;
    private int lastChiPacketTime = -1;

    public AvatarPlayerData(DataSaver dataSaver, UUID playerID, EntityPlayer player) {
        super(dataSaver, playerID, player);
        boolean isClient = !(player instanceof EntityPlayerMP);
        this.bendingData = new BendingData(this::save, this::saveAll);
        this.changed = new TreeSet<DataCategory>();
    }

    public static void initFetcher(PlayerDataFetcher<AvatarPlayerData> clientFetcher) {
        fetcher = new PlayerDataFetcherSided<AvatarPlayerData>(clientFetcher, new PlayerDataFetcherServer(AvatarWorldData::getDataFromWorld));
    }

    public static PlayerDataFetcher<AvatarPlayerData> fetcher() {
        return fetcher;
    }

    @Override
    protected void readPlayerDataFromNBT(NBTTagCompound nbt) {
        this.bendingData.readFromNbt(nbt);
    }

    @Override
    protected void writePlayerDataToNBT(NBTTagCompound nbt) {
        this.bendingData.writeToNbt(nbt);
    }

    public void save(DataCategory category) {
        this.changed.add(category);
        this.sendPacket();
        this.saveChanges();
    }

    public void saveAll() {
        this.changed.addAll(Arrays.asList(DataCategory.values()));
        this.sendPacket();
        this.saveChanges();
    }

    private void sendPacket() {
        PacketCPlayerData packet = new PacketCPlayerData(this.bendingData, this.playerID, this.changed);
        EntityPlayer player = this.getPlayerEntity();
        if (player != null && !player.field_70170_p.field_72995_K) {
            if (!this.doesChiLimitPass(player)) {
                return;
            }
            EntityTracker tracker = ((WorldServer)player.field_70170_p).func_73039_n();
            ArrayList<EntityPlayer> nearbyPlayers = new ArrayList<EntityPlayer>();
            nearbyPlayers.add(player);
            nearbyPlayers.addAll(tracker.getTrackingPlayers((Entity)player));
            double rangeSq = 0.0;
            for (EntityPlayer p : nearbyPlayers) {
                if (!(p.func_70068_e((Entity)player) > rangeSq)) continue;
                rangeSq = p.func_70068_e((Entity)player);
            }
            double range = Math.sqrt(rangeSq) + 0.01;
            NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
            AvatarMod.network.sendToAllAround((IMessage)packet, targetPoint);
            this.changed.clear();
        }
    }

    public BendingData getData() {
        return this.bendingData;
    }

    private boolean doesChiLimitPass(EntityPlayer player) {
        if (this.changed.size() == 1 && this.changed.first() == DataCategory.CHI) {
            if (player.field_70173_aa - this.lastChiPacketTime < 20 && this.lastChiPacketTime != -1) {
                return false;
            }
            this.lastChiPacketTime = player.field_70173_aa;
        }
        return true;
    }

    @Override
    protected void saveChanges() {
        super.saveChanges();
        this.bendingData.updateMaxChi();
    }
}

