/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.util.data;

import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AvatarPlayerData;
import com.crowsofwar.avatar.util.data.ScheduledDestroyBlock;
import com.crowsofwar.avatar.util.data.TemporaryWaterLocation;
import com.crowsofwar.gorecore.data.WorldDataPlayers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AvatarWorldData
extends WorldDataPlayers<AvatarPlayerData> {
    public static final String WORLD_DATA_KEY = "Avatar";
    private int nextEntityId = 1;
    private List<ScheduledDestroyBlock> scheduledDestroyBlocks = new ArrayList<ScheduledDestroyBlock>();
    private List<TemporaryWaterLocation> temporaryWater = new ArrayList<TemporaryWaterLocation>();

    public AvatarWorldData() {
        super(WORLD_DATA_KEY);
    }

    public AvatarWorldData(String key) {
        this();
    }

    public static AvatarWorldData getDataFromWorld(World world) {
        if (world.field_72995_K) {
            throw new IllegalStateException("AvatarWorldData is designed to be used only on server side");
        }
        return AvatarWorldData.getDataForWorld(AvatarWorldData.class, WORLD_DATA_KEY, world, false);
    }

    @Override
    public Class<AvatarPlayerData> playerDataClass() {
        return AvatarPlayerData.class;
    }

    @Override
    public void func_76184_a(NBTTagCompound nbt) {
        super.func_76184_a(nbt);
        this.nextEntityId = nbt.func_74762_e("NextEntityId");
        AvatarUtils.readList(this.scheduledDestroyBlocks, compound -> {
            BlockPos pos = new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
            return new ScheduledDestroyBlock(this, pos, compound.func_74762_e("Ticks"), compound.func_74767_n("Drop"), compound.func_74762_e("Fortune"));
        }, nbt, "DestroyBlocks");
        AvatarUtils.readList(this.temporaryWater, c -> {
            BlockPos pos = new BlockPos(c.func_74762_e("x"), c.func_74762_e("y"), c.func_74762_e("z"));
            return new TemporaryWaterLocation(this, pos, c.func_74762_e("Dimension"), c.func_74762_e("Ticks"));
        }, nbt, "TemporaryWater");
    }

    @Override
    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        super.func_189551_b(nbt);
        nbt.func_74768_a("NextEntityId", this.nextEntityId);
        AvatarUtils.writeList(this.scheduledDestroyBlocks, (compound, sdb) -> {
            compound.func_74768_a("x", sdb.pos.func_177958_n());
            compound.func_74768_a("y", sdb.pos.func_177956_o());
            compound.func_74768_a("z", sdb.pos.func_177952_p());
            compound.func_74768_a("Ticks", sdb.ticks);
            compound.func_74757_a("Drop", sdb.drop);
            compound.func_74768_a("Fortune", sdb.fortune);
        }, nbt, "DestroyBlocks");
        AvatarUtils.writeList(this.temporaryWater, (c, water) -> {
            c.func_74768_a("x", water.getPos().func_177958_n());
            c.func_74768_a("y", water.getPos().func_177956_o());
            c.func_74768_a("z", water.getPos().func_177952_p());
            c.func_74768_a("Ticks", water.getTicks());
            c.func_74768_a("Dimension", water.getDimension());
        }, nbt, "TemporaryWater");
        return nbt;
    }

    public int nextEntityId() {
        return ++this.nextEntityId;
    }

    public List<ScheduledDestroyBlock> getScheduledDestroyBlocks() {
        return this.scheduledDestroyBlocks;
    }

    public List<TemporaryWaterLocation> geTemporaryWaterLocations() {
        return this.temporaryWater;
    }

    public void addTemporaryWaterLocation(BlockPos pos) {
        this.temporaryWater.add(new TemporaryWaterLocation(this, pos, this.getWorld().field_73011_w.getDimension(), 15));
    }
}

